/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.ComparableTorrentJsonItem;
import com.frostwire.search.torrent.TorrentSearchPerformer;
import com.frostwire.search.torrent.TorrentSearchResult;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class TorrentJsonSearchPerformer<T extends ComparableTorrentJsonItem, R extends TorrentSearchResult>
extends TorrentSearchPerformer {
    private static final int DEFAULT_NUM_CRAWLS = 10;
    private final Comparator<T> itemComparator = (a, b) -> b.getSeeds() - a.getSeeds();

    private TorrentJsonSearchPerformer(String domainName, long token, String keywords, int timeout, int pages, int numCrawls) {
        super(domainName, token, keywords, timeout, pages, numCrawls);
    }

    public TorrentJsonSearchPerformer(String domainName, long token, String keywords, int timeout, int pages) {
        this(domainName, token, keywords, timeout, pages, 10);
    }

    @Override
    protected final List<? extends SearchResult> searchPage(String page) {
        LinkedList<R> result = new LinkedList<R>();
        List<T> items = this.parseJson(page);
        if (items != null) {
            items.sort(this.itemComparator);
            for (ComparableTorrentJsonItem item : items) {
                if (this.isStopped()) continue;
                R sr = this.fromItem(item);
                result.add(sr);
            }
        }
        return result;
    }

    abstract List<T> parseJson(String var1);

    abstract R fromItem(T var1);
}

