/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public final class ZipUtils {
    private static final Logger LOG = Logger.getLogger(ZipUtils.class);

    public static boolean unzip(File zipFile, File outputDir) {
        return ZipUtils.unzip(zipFile, outputDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(File zipFile, File outputDir, ZipListener listener) {
        boolean result = false;
        try {
            FileUtils.deleteDirectory(outputDir);
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
                ZipUtils.unzipEntries(outputDir, zis, ZipUtils.getItemCount(zipFile), System.currentTimeMillis(), listener);
            }
            result = true;
        }
        catch (IOException e) {
            LOG.error("Unable to uncompress " + zipFile + " to " + outputDir, e);
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntries(File folder, ZipInputStream zis, int itemCount, long time, ZipListener listener) throws IOException {
        ZipEntry ze = null;
        int item = 0;
        while ((ze = zis.getNextEntry()) != null) {
            ++item;
            String fileName = ze.getName();
            File newFile = new File(folder, fileName);
            LOG.debug("unzip: " + newFile.getAbsoluteFile());
            if (ze.isDirectory()) {
                if (newFile.mkdirs()) continue;
                break;
            }
            if (listener != null) {
                int progress = item == itemCount ? 100 : (int)((double)(item * 100) / (double)itemCount);
                listener.onUnzipping(fileName, progress);
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, n);
                    if (listener == null || !listener.isCanceled()) continue;
                    throw new IOException("Uncompress operation cancelled");
                }
            }
            finally {
                fos.close();
                zis.closeEntry();
            }
            newFile.setLastModified(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getItemCount(File file) throws IOException {
        ZipFile zip = null;
        int count = 0;
        try {
            zip = new ZipFile(file);
            count = zip.size();
        }
        finally {
            try {
                zip.close();
            }
            catch (Throwable throwable) {}
        }
        return count;
    }

    public static interface ZipListener {
        public void onUnzipping(String var1, int var2);

        public boolean isCanceled();
    }
}

