/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.MagnetOptions;
import com.limegroup.gnutella.gui.GUIUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public class ExternalControl {
    private static final Logger LOG = Logger.getLogger(ExternalControl.class);
    private static ExternalControl INSTANCE;
    private static final String NL = "\r\n";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final String LOCALHOST_NAME = "localhost";
    private static final int SERVER_PORT = 45099;
    private boolean initialized = false;
    private volatile String enqueuedRequest = null;
    private final ActivityCallback activityCallback;

    public static ExternalControl instance(ActivityCallback activityCallback) {
        if (INSTANCE == null) {
            INSTANCE = new ExternalControl(activityCallback);
        }
        return INSTANCE;
    }

    private ExternalControl(ActivityCallback activityCallback) {
        this.activityCallback = activityCallback;
    }

    public void startServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(45099, 50, InetAddress.getByName(ExternalControl.LOCALHOST_IP));
                    while (true) {
                        final Socket socket = serverSocket.accept();
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                boolean closeSocket = true;
                                try {
                                    BufferedReader br;
                                    String line;
                                    String address2 = socket.getInetAddress().getHostAddress();
                                    if ((address2.equals(ExternalControl.LOCALHOST_NAME) || address2.equals(ExternalControl.LOCALHOST_IP)) && (line = (br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF8"))).readLine()) != null && line.toUpperCase().startsWith("GET ")) {
                                        line = line.substring(4);
                                        int pos = line.lastIndexOf(32);
                                        line = line.substring(0, pos);
                                        closeSocket = ExternalControl.this.process(line, socket.getOutputStream());
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    if (closeSocket) {
                                        try {
                                            socket.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        }).start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    private boolean process(String get, OutputStream os) throws IOException {
        String arg_str;
        HashMap<String, String> original_params = new HashMap<String, String>();
        HashMap<String, String> lc_params = new HashMap<String, String>();
        ArrayList<String> source_params = new ArrayList<String>();
        int pos = get.indexOf(63);
        if (pos == -1) {
            arg_str = "";
        } else {
            arg_str = get.substring(pos + 1);
            if ((pos = arg_str.lastIndexOf(32)) >= 0) {
                arg_str = arg_str.substring(0, pos).trim();
            }
            StringTokenizer tok = new StringTokenizer(arg_str, "&");
            while (tok.hasMoreTokens()) {
                String lhs;
                String arg = tok.nextToken();
                pos = arg.indexOf(61);
                if (pos == -1) {
                    lhs = arg.trim();
                    original_params.put(lhs, "");
                    lc_params.put(lhs.toLowerCase(GUIUtils.LOCALE_ENGLISH), "");
                    continue;
                }
                try {
                    lhs = arg.substring(0, pos).trim();
                    String lc_lhs = lhs.toLowerCase(GUIUtils.LOCALE_ENGLISH);
                    String rhs = URLDecoder.decode(arg.substring(pos + 1).trim(), "UTF8");
                    original_params.put(lhs, rhs);
                    lc_params.put(lc_lhs, rhs);
                    if (!lc_lhs.equals("xsource")) continue;
                    source_params.add(rhs);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        if (get.startsWith("/download")) {
            String info_hash = (String)lc_params.get("info_hash");
            if (info_hash != null) {
                if (this.activityCallback.isRemoteDownloadsAllowed()) {
                    this.writeJSReply(os, "checkResult(1);");
                    this.handleTorrentMagnetRequest("magnet:?xt=urn:btih:" + info_hash + '&' + arg_str);
                } else {
                    this.writeJSReply(os, "checkResult(0);");
                }
                return true;
            }
            String url = UrlUtils.decode((String)lc_params.get("url"));
            if (!StringUtils.isNullOrEmpty(url) && this.activityCallback.isRemoteDownloadsAllowed()) {
                if (url.startsWith("magnet:?")) {
                    this.handleTorrentMagnetRequest(url);
                } else if (url.startsWith("file://") || url.endsWith(".torrent")) {
                    this.handleTorrentRequest(url);
                }
            }
            this.writeHTTPReply(os);
            return true;
        }
        if (get.startsWith("/show")) {
            this.writeHTTPReply(os);
            this.restoreApplication();
            return true;
        }
        this.writeNotFound(os);
        return true;
    }

    private void writeNotFound(OutputStream os) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 404 Not Found\r\n\r\n");
        pw.flush();
    }

    private void writeJSReply(OutputStream os, String string) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.1 200 OK\r\n");
        pw.print("Cache-Control: no-cache\r\n");
        pw.print("Pragma: no-cache\r\n");
        pw.print("Content-Type: text/javascript\r\n");
        pw.print("Content-Length: " + string.length() + NL + NL);
        pw.write(string);
        pw.flush();
    }

    private void writeHTTPReply(OutputStream os) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.1 200 OK\r\n");
        pw.print("Cache-Control: no-cache\r\n");
        pw.print("Pragma: no-cache\r\n");
        pw.print("Content-Type: text/plain\r\n");
        pw.print("Content-Length: " + "Running".length() + NL + NL);
        pw.write("Running");
        pw.flush();
    }

    public String preprocessArgs(String[] args) {
        LOG.info("enter proprocessArgs");
        StringBuilder arg = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            arg.append(args[i]);
        }
        return arg.toString();
    }

    public void checkForActiveFrostWire() {
        if (this.testForFrostWire(null)) {
            System.exit(0);
        }
    }

    public void checkForActiveFrostWire(String arg) {
        if ((OSUtils.isWindows() || OSUtils.isLinux()) && this.testForFrostWire(arg)) {
            System.exit(0);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void enqueueControlRequest(String arg) {
        this.enqueuedRequest = arg;
    }

    public void runQueuedControlRequest() {
        this.initialized = true;
        if (this.enqueuedRequest != null) {
            String request = this.enqueuedRequest;
            this.enqueuedRequest = null;
            if (this.isTorrentMagnetRequest(request)) {
                LOG.info("ExternalControl.runQueuedControlRequest() handleTorrentMagnetRequest() - " + request);
                this.handleTorrentMagnetRequest(request);
            } else if (this.isTorrentRequest(request)) {
                LOG.info("ExternalControl.runQueuedControlRequest() handleTorrentRequest() - " + request);
                this.handleTorrentRequest(request);
            } else {
                LOG.info("ExternalControl.runQueuedControlRequest() handleMagnetRequest() - " + request);
                this.handleMagnetRequest(request);
            }
        }
    }

    private boolean isTorrentMagnetRequest(String request) {
        return request.startsWith("magnet:?xt=urn:btih");
    }

    private void handleTorrentMagnetRequest(String request) {
        ActivityCallback callback = this.restoreApplication();
        LOG.info("handleTorrentMagnetRequest restored application. About to callback.handleTorrentMagnet()");
        callback.handleTorrentMagnet(request, true);
    }

    private boolean isTorrentRequest(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase()).endsWith(".torrent") && !arg.startsWith("magnet:");
    }

    public void handleMagnetRequest(String arg) {
        LOG.info("enter handleMagnetRequest");
        if (this.isTorrentMagnetRequest(arg)) {
            LOG.info("ExternalControl.handleMagnetRequest(" + arg + ") -> handleTorrentMagnetRequest()");
            this.handleTorrentMagnetRequest(arg);
            return;
        }
        MagnetOptions[] options = MagnetOptions.parseMagnet(arg);
        if (options.length == 0) {
            LOG.warn("Invalid magnet, ignoring: " + arg);
        }
    }

    private ActivityCallback restoreApplication() {
        this.activityCallback.restoreApplication();
        this.activityCallback.showDownloads();
        return this.activityCallback;
    }

    private void handleTorrentRequest(String arg) {
        LOG.info("enter handleTorrentRequest");
        ActivityCallback callback = this.restoreApplication();
        File torrentFile = new File(arg.trim());
        callback.handleTorrent(torrentFile);
    }

    private boolean testForFrostWire(String arg) {
        try {
            String urlParameter = arg != null && (arg.startsWith("http://") || arg.startsWith("https://") || arg.startsWith("magnet:?") || arg.endsWith(".torrent")) ? "/download?url=" + UrlUtils.encode(arg) : "/show";
            String response = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC).get("http://127.0.0.1:45099" + urlParameter, 1000);
            if (response != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

