/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.bugs.BugManager;
import org.limewire.service.ErrorCallback;

public final class ErrorHandler
implements ErrorCallback {
    @Override
    public void error(Throwable problem) {
        this.error(problem, null);
    }

    @Override
    public void error(Throwable problem, String msg) {
        if (problem instanceof ThreadDeath) {
            throw (ThreadDeath)problem;
        }
        Error doWorkRunnable = new Error(problem, msg);
        GUIMediator.safeInvokeLater(doWorkRunnable);
    }

    private static class Error
    implements Runnable {
        private final Throwable PROBLEM;
        private final String MESSAGE;
        private final String CURRENT_THREAD_NAME;

        private Error(Throwable problem, String msg) {
            this.PROBLEM = problem;
            this.MESSAGE = msg;
            this.CURRENT_THREAD_NAME = Thread.currentThread().getName();
        }

        @Override
        public void run() {
            try {
                GUIMediator.closeStartupDialogs();
                BugManager.instance().handleBug(this.PROBLEM, this.CURRENT_THREAD_NAME, this.MESSAGE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

