/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.HideExitDialog;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.tabs.Tab;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import com.frostwire.util.ThreadPool;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.JavaVersionNotice;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.LimeJFrame;
import com.limegroup.gnutella.gui.MPlayerMediator;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SendFeedbackDialog;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.TipOfTheDayMessages;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.bugs.FatalBugManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.shell.FrostAssociations;
import com.limegroup.gnutella.gui.shell.ShellAssociationManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.Launcher;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.service.ErrorService;
import org.limewire.service.Switch;
import org.limewire.setting.IntSetting;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.VersionUtils;

public final class GUIMediator {
    private static boolean _displayedMessage;
    private static final String DISCONNECTED_MESSAGE;
    private static GUIMediator _instance;
    private boolean _remoteDownloadsAllowed;
    private static JFrame FRAME;
    private static PopupMenu TRAY_MENU;
    private static final List<RefreshListener> REFRESH_LIST;
    private static final String APP_TITLE;
    private static OptionsMediator OPTIONS_MEDIATOR;
    private static ShellAssociationManager ASSOCIATION_MANAGER;
    private MainFrame MAIN_FRAME = new MainFrame(GUIMediator.getAppFrame());
    private BTDownloadMediator BT_DOWNLOAD_MEDIATOR;
    private StatusLine STATUS_LINE;
    private long _lastConnectivityCheckTimestamp;
    private boolean _wasInternetReachable;
    private static boolean _visibleOnce;
    private static boolean _allowVisible;
    private final RefreshTimer timer;
    private static ThreadPool pool;

    private GUIMediator() {
        OPTIONS_MEDIATOR = this.MAIN_FRAME.getOptionsMediator();
        this._remoteDownloadsAllowed = true;
        this.timer = new RefreshTimer();
    }

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    public static boolean isConstructed() {
        return _instance != null;
    }

    void coreInitialized() {
        this.timer.startTimer();
    }

    public static boolean isAppVisible() {
        return GUIMediator.getAppFrame().isShowing();
    }

    static void setAppVisible(final boolean visible) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        if (visible) {
                            GUIMediator.getAppFrame().toFront();
                        }
                        GUIMediator.getAppFrame().setVisible(visible);
                    }
                    catch (NullPointerException npe) {
                        System.out.println("GUIMediator - NULL POINTER EXCEPTION HAPPENED");
                        if (OSUtils.isNativeThemeWindows()) {
                            try {
                                GUIMediator.showError(I18n.tr("FrostWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing FrostWire's Windows Compatibility. Right-click on the FrostWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart FrostWire."));
                                System.exit(0);
                            }
                            catch (Throwable t) {
                                if (visible) {
                                    FatalBugManager.handleFatalBug(npe);
                                    break block13;
                                }
                                ErrorService.error(npe);
                            }
                        }
                        if (visible) {
                            FatalBugManager.handleFatalBug(npe);
                        } else {
                            ErrorService.error(npe);
                        }
                    }
                    catch (Throwable t) {
                        if (visible) {
                            FatalBugManager.handleFatalBug(t);
                        }
                        ErrorService.error(t);
                    }
                }
                if (visible) {
                    SearchMediator.requestSearchFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GUIMediator.getAppFrame().getContentPane().invalidate();
                            GUIMediator.getAppFrame().getContentPane().validate();
                        }
                    });
                }
                if (visible && !_visibleOnce) {
                    GUIMediator.showDialogsForFirstVisibility();
                    _visibleOnce = true;
                }
            }
        });
    }

    private static void showDialogsForFirstVisibility() {
        JDialog dialog;
        if (_displayedMessage) {
            return;
        }
        _displayedMessage = true;
        GUIMediator.getAssociationManager().checkAndGrab(true);
        if (TipOfTheDayMessages.hasLocalizedMessages() && StartupSettings.SHOW_TOTD.getValue()) {
            TipOfTheDayMediator.instance();
            ThreadExecutor.startThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TipOfTheDayMediator.instance().displayTipWindow();
                        }
                    });
                }
            }, "TOTD");
        }
        if ((dialog = JavaVersionNotice.getUpgradeRecommendedDialog(VersionUtils.getJavaVersion())) != null) {
            dialog.setVisible(true);
        }
    }

    static void closeStartupDialogs() {
        if (SplashWindow.instance().isShowing()) {
            SplashWindow.instance().toBack();
        }
        if (TipOfTheDayMediator.isConstructed()) {
            TipOfTheDayMediator.instance().hide();
        }
    }

    static Dimension getAppSize() {
        return GUIMediator.getAppFrame().getSize();
    }

    static Point getAppLocation() {
        return GUIMediator.getAppFrame().getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public static JFrame getAppFrame() {
        if (FRAME == null) {
            FRAME = new LimeJFrame();
            FRAME.setTitle(APP_TITLE);
        }
        return FRAME;
    }

    public static PopupMenu getTrayMenu() {
        if (TRAY_MENU == null) {
            TRAY_MENU = new PopupMenu();
        }
        return TRAY_MENU;
    }

    public StatusLine getStatusLine() {
        if (this.STATUS_LINE == null) {
            this.STATUS_LINE = this.getMainFrame().getStatusLine();
        }
        return this.STATUS_LINE;
    }

    final void refreshGUI() {
        for (RefreshListener listener : REFRESH_LIST) {
            try {
                listener.refresh();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
        this.updateConnectionQualityAsync();
    }

    private void updateConnectionQualityAsync() {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                final int quality = GUIMediator.this.getConnectionQuality();
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (quality != 0) {
                            GUIMediator.hideDisposableMessage(DISCONNECTED_MESSAGE);
                        }
                        GUIMediator.this.updateConnectionUI(quality);
                    }
                });
            }
        });
    }

    private int getConnectionQuality() {
        if (this.isInternetReachable()) {
            return 1;
        }
        return 0;
    }

    public void setOptionsVisible(boolean visible) {
        if (OPTIONS_MEDIATOR == null) {
            return;
        }
        OPTIONS_MEDIATOR.setOptionsVisible(visible);
    }

    public void setOptionsVisible(boolean visible, String key) {
        if (OPTIONS_MEDIATOR == null) {
            return;
        }
        OPTIONS_MEDIATOR.setOptionsVisible(visible, key);
    }

    static boolean isOptionsVisible() {
        return OPTIONS_MEDIATOR != null && OPTIONS_MEDIATOR.isOptionsVisible();
    }

    static Component getMainOptionsComponent() {
        if (OPTIONS_MEDIATOR == null) {
            return null;
        }
        return OPTIONS_MEDIATOR.getMainOptionsComponent();
    }

    public static ShellAssociationManager getAssociationManager() {
        if (ASSOCIATION_MANAGER == null) {
            ASSOCIATION_MANAGER = new ShellAssociationManager(FrostAssociations.getSupportedAssociations());
        }
        return ASSOCIATION_MANAGER;
    }

    public void setWindow(Tabs tabEnum) {
        if (tabEnum == Tabs.TRANSFERS || tabEnum == Tabs.SEARCH_TRANSFERS) {
            if (Tabs.TRANSFERS.isEnabled()) {
                tabEnum = Tabs.TRANSFERS;
            } else if (Tabs.SEARCH_TRANSFERS.isEnabled()) {
                tabEnum = Tabs.SEARCH_TRANSFERS;
            }
        }
        this.getMainFrame().getApplicationHeader().showSearchField(this.getMainFrame().getTab(tabEnum));
        this.getMainFrame().setSelectedTab(tabEnum);
        if (LibrarySettings.LAST_SELECTED_LIBRARY_DIRECTORY_HOLDER_OFFSET.getValue() == -1) {
            this.selectDefaultSaveFolderOnLibraryFirstTime(tabEnum);
        } else {
            LibraryMediator.instance().getLibraryExplorer().selectDirectoryHolderAt(LibrarySettings.LAST_SELECTED_LIBRARY_DIRECTORY_HOLDER_OFFSET.getValue());
        }
    }

    private void selectDefaultSaveFolderOnLibraryFirstTime(Tabs tab) {
        if (!tab.navigatedTo && tab.equals((Object)Tabs.LIBRARY)) {
            LibraryMediator.instance().getLibraryExplorer().selectFinishedDownloads();
            tab.navigatedTo = true;
        }
    }

    public Tabs getSelectedTab() {
        return this.getMainFrame().getSelectedTab();
    }

    private void updateConnectionUI(int quality) {
        this.getStatusLine().setConnectionQuality(quality);
    }

    int getCurrentUploads() {
        return this.getBTDownloadMediator().getActiveUploads();
    }

    public final int getTotalDownloads() {
        return this.getBTDownloadMediator().getTotalDownloads();
    }

    final int getCurrentDownloads() {
        return this.getBTDownloadMediator().getActiveDownloads();
    }

    public final void openTorrentFile(File torrentFile, boolean partialSelection) {
        BTDownloadMediator btDownloadMediator = this.getBTDownloadMediator();
        List<BTDownload> downloads = this.getBTDownloadMediator().getDownloads();
        Runnable onOpenRunnable = () -> {
            this.showTransfers(TransfersTab.FilterMode.ALL);
            TorrentInfo ti = new TorrentInfo(torrentFile);
            for (BTDownload btDownload : downloads) {
                if (!btDownload.getHash().equals(ti.infoHash().toHex())) continue;
                btDownloadMediator.selectBTDownload(btDownload);
            }
        };
        btDownloadMediator.openTorrentFile(torrentFile, partialSelection, onOpenRunnable);
    }

    public void openTorrentForSeed(File torrentFile, File saveDir) {
        this.getBTDownloadMediator().openTorrentFileForSeed(torrentFile, saveDir);
        this.showTransfers(TransfersTab.FilterMode.ALL);
    }

    public final void openTorrentURI(String uri, boolean partialDownload) {
        this.showTransfers(TransfersTab.FilterMode.ALL);
        this.getBTDownloadMediator().openTorrentURI(uri, partialDownload);
    }

    static boolean isPlaylistVisible() {
        return true;
    }

    static void startupHidden() {
        GUIMediator.showTrayIcon();
        if (OSUtils.isMacOSX()) {
            GUIMediator.hideView();
        }
    }

    static void allowVisibility() {
        _allowVisible = true;
    }

    void loadFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread awt = Thread.currentThread();
                awt.setPriority(awt.getPriority() + 1);
                GUIMediator.this.getStatusLine().loadFinished();
            }
        });
    }

    static void handleReopen() {
        if (_allowVisible) {
            if (!_visibleOnce) {
                GUIMediator.restoreView();
            }
            GUIMediator.setAppVisible(true);
        }
    }

    private static void hideView() {
        GUIMediator.getAppFrame().setState(1);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            GUIMediator.setAppVisible(false);
        }
    }

    public static void restoreView() {
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            boolean doHack = false;
            if (!_visibleOnce) {
                doHack = true;
            }
            GUIMediator.setAppVisible(true);
            if (ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                GUIMediator.showTrayIcon();
            } else {
                GUIMediator.hideTrayIcon();
            }
            if (doHack) {
                GUIMediator.restoreView();
            }
        }
        GUIMediator.getAppFrame().setState(0);
    }

    public static void close(boolean fromFrame) {
        boolean minimizeToTray = ApplicationSettings.MINIMIZE_TO_TRAY.getValue();
        if (!OSUtils.isMacOSX() && ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.getValue()) {
            HideExitDialog dlg = new HideExitDialog(GUIMediator.getAppFrame());
            dlg.setVisible(true);
            int result = dlg.getResult();
            if (result == 0) {
                return;
            }
            boolean bl = minimizeToTray = result == 1;
        }
        if (minimizeToTray) {
            if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
                GUIMediator.applyWindowSettings();
                GUIMediator.showTrayIcon();
                GUIMediator.hideView();
            }
        } else if (OSUtils.isMacOSX() && fromFrame) {
            GUIMediator.setAppVisible(false);
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        GUIMediator.instance().timer.stopTimer();
        GUIMediator.hideVideoPlayerWindow();
        Finalizer.shutdown();
    }

    private static void hideVideoPlayerWindow() {
        try {
            if (MPlayerMediator.instance() != null) {
                try {
                    MPlayerMediator.instance().showPlayerWindow(false);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showTransfers(TransfersTab.FilterMode mode) {
        Tabs tabEnum = Tabs.TRANSFERS;
        if (Tabs.TRANSFERS.isEnabled()) {
            tabEnum = Tabs.TRANSFERS;
        } else if (Tabs.SEARCH_TRANSFERS.isEnabled()) {
            tabEnum = Tabs.SEARCH_TRANSFERS;
        }
        this.setWindow(tabEnum);
        ((TransfersTab)this.getMainFrame().getTab(Tabs.TRANSFERS)).showTransfers(mode);
    }

    public static void showAboutWindow() {
        new AboutWindow().showDialog();
    }

    public static void showSendFeedbackDialog() {
        new SendFeedbackDialog().showDialog();
    }

    private static void showTrayIcon() {
        NotifyUserProxy.instance().showTrayIcon();
    }

    private static void hideTrayIcon() {
        NotifyUserProxy.instance().hideTrayIcon();
    }

    static void applyWindowSettings() {
        ApplicationSettings.RUN_ONCE.setValue(true);
        if (GUIMediator.isAppVisible()) {
            if ((GUIMediator.getAppFrame().getExtendedState() & 6) == 6) {
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            } else {
                Dimension dim = GUIMediator.getAppSize();
                if (dim.height > 100 && dim.width > 100) {
                    Point loc = GUIMediator.getAppLocation();
                    ApplicationSettings.APP_WIDTH.setValue(dim.width);
                    ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                    ApplicationSettings.WINDOW_X.setValue(loc.x);
                    ApplicationSettings.WINDOW_Y.setValue(loc.y);
                }
            }
        }
    }

    public Tab getTab(Tabs tabs) {
        return this.MAIN_FRAME.getTab(tabs);
    }

    public static ImageIcon getThemeImage(String name) {
        return ResourceManager.getThemeImage(name);
    }

    public static ImageIcon getImageFromResourcePath(String loc) {
        return ResourceManager.getImageFromResourcePath(loc);
    }

    static void resetLocale() {
        ResourceManager.resetLocaleOptions();
        GUIUtils.resetLocale();
    }

    public static DialogOption showYesNoMessage(String message, DialogOption defaultOption) {
        return MessageService.instance().showYesNoMessage(message, defaultOption);
    }

    public static DialogOption showYesNoMessage(String message, String title, int msgType) {
        return MessageService.instance().showYesNoMessage(message, title, msgType);
    }

    public static DialogOption showYesNoMessage(String message, IntSetting defaultValue, DialogOption defaultOption) {
        return MessageService.instance().showYesNoMessage(message, defaultValue, defaultOption);
    }

    public static DialogOption showYesNoTitledMessage(String message, String title, DialogOption defaultOption) {
        return MessageService.instance().showYesNoMessage(message, title, defaultOption);
    }

    public static DialogOption showYesNoOtherMessage(String message, IntSetting defaultValue, String otherOptions) {
        return MessageService.instance().showYesNoOtherMessage(message, defaultValue, otherOptions);
    }

    public static DialogOption showYesNoCancelMessage(String message) {
        return MessageService.instance().showYesNoCancelMessage(message);
    }

    public static DialogOption showYesNoCancelMessage(String message, IntSetting defaultValue) {
        return MessageService.instance().showYesNoCancelMessage(message, defaultValue);
    }

    public static void showMessage(String messageKey) {
        MessageService.instance().showMessage(messageKey);
    }

    public static void showMessage(String message, Switch ignore) {
        MessageService.instance().showMessage(message, ignore);
    }

    private static void showDisposableMessage(String messageKey, String message, Switch ignore, int msgType) {
        MessageService.instance().showDisposableMessage(messageKey, message, ignore, msgType);
    }

    private static void hideDisposableMessage(String messageKey) {
        MessageService.instance().hideDisposableMessage(messageKey);
    }

    public static void showError(String message) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(message);
    }

    public static void showError(String message, Switch ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(message, ignore);
    }

    public static void showWarning(String message) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(message);
    }

    public static int openURL(String url) {
        try {
            return Launcher.openURL(url);
        }
        catch (Throwable e) {
            GUIMediator.showError(I18n.tr("FrostWire could not locate your web browser to display the following web page: {0}.", url));
            return -1;
        }
    }

    public static void launchFile(File file) {
        try {
            Launcher.launchFile(file);
        }
        catch (SecurityException se) {
            GUIMediator.showError(I18n.tr("FrostWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException e) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(e.getCommand(), " ")));
        }
        catch (IOException e) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file."));
        }
    }

    public static void launchExplorer(File file) {
        try {
            Launcher.launchExplorer(file);
        }
        catch (SecurityException e) {
            GUIMediator.showError(I18n.tr("FrostWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException e) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(e.getCommand(), " ")));
        }
        catch (IOException e) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file."));
        }
    }

    static Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }

    public static void disconnected() {
        GUIMediator.showDisposableMessage(DISCONNECTED_MESSAGE, I18n.tr("Your machine does not appear to have an active Internet connection or a firewall is blocking FrostWire from accessing the internet. FrostWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu."), QuestionsHandler.NO_INTERNET_RETRYING, 0);
    }

    public static void setSplashScreenString(String text) {
        if (!_allowVisible) {
            SplashWindow.instance().setStatusText(text);
        } else if (GUIMediator.isConstructed()) {
            GUIMediator.instance().getStatusLine().setStatusText(text);
        }
    }

    static Point getScreenCenterPoint(Component comp) {
        Dimension COMPONENT_DIMENSION = comp.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = Math.min(screenSize.width, COMPONENT_DIMENSION.width);
        int appHeight = Math.min(screenSize.height - 40, COMPONENT_DIMENSION.height);
        return new Point((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
    }

    public static void addRefreshListener(RefreshListener listener) {
        if (!REFRESH_LIST.contains(listener)) {
            REFRESH_LIST.add(listener);
        }
    }

    public static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    static boolean isEnglishLocale() {
        return LanguageUtils.isEnglishLocale(GUIMediator.getLocale());
    }

    public void launchMedia(MediaSource song, boolean isPreview) {
        if (MediaPlayer.instance().getCurrentMedia() != null) {
            try {
                MediaPlayer.instance().stop();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean playNextSong = true;
        if (song.getFile() != null && MediaType.getVideoMediaType().matches(song.getFile().getAbsolutePath())) {
            playNextSong = false;
        }
        MediaPlayer.instance().asyncLoadMedia(song, isPreview, playNextSong);
    }

    boolean attemptStopAudio() {
        MediaPlayer mediaPlayer = MediaPlayer.instance();
        mediaPlayer.stop();
        return true;
    }

    public void buttonViewChanged() {
        IconManager.instance().wipeButtonIconCache();
        this.updateButtonView(GUIMediator.getAppFrame());
    }

    private void updateButtonView(Component c) {
        if (c instanceof IconButton) {
            ((IconButton)c).updateUI();
        }
        Component[] children = null;
        if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component aChildren : children) {
                this.updateButtonView(aChildren);
            }
        }
    }

    public static void safeInvokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                ErrorService.error(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void safeInvokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setFrameCursor(Cursor cursor) {
        GUIMediator.getAppFrame().setCursor(cursor);
    }

    public static void openURL(final String link, final long delay) {
        if (delay > 0L) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GUIMediator.openURL(link);
                }
            }).start();
        } else {
            GUIMediator.openURL(link);
        }
    }

    public BTDownloadMediator getBTDownloadMediator() {
        if (this.BT_DOWNLOAD_MEDIATOR == null) {
            this.BT_DOWNLOAD_MEDIATOR = this.getMainFrame().getBTDownloadMediator();
        }
        return this.BT_DOWNLOAD_MEDIATOR;
    }

    public static void setClipboardContent(String str) {
        try {
            StringSelection data = new StringSelection(str);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(data, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isInternetReachable() {
        long _internetConnectivityInterval = 5000L;
        long now = System.currentTimeMillis();
        if (now - this._lastConnectivityCheckTimestamp < _internetConnectivityInterval) {
            return this._wasInternetReachable;
        }
        this._lastConnectivityCheckTimestamp = now;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                this._wasInternetReachable = false;
                return false;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (!iface.isUp() || iface.isLoopback()) continue;
                this._wasInternetReachable = true;
                return true;
            }
        }
        catch (Exception e) {
            this._wasInternetReachable = false;
            return false;
        }
        this._wasInternetReachable = false;
        return false;
    }

    boolean isRemoteDownloadsAllowed() {
        return this._remoteDownloadsAllowed;
    }

    public void setRemoteDownloadsAllowed(boolean remoteDownloadsAllowed) {
        this._remoteDownloadsAllowed = remoteDownloadsAllowed;
    }

    public void openTorrentSearchResult(TorrentSearchResult sr, boolean partial) {
        this.getBTDownloadMediator().openTorrentSearchResult(sr, partial);
    }

    public void openSoundcloudTrackUrl(String trackUrl, SoundcloudSearchResult sr) {
        this.showTransfers(TransfersTab.FilterMode.ALL);
        this.getBTDownloadMediator().downloadSoundcloudFromTrackUrlOrSearchResult(trackUrl, sr);
    }

    public void openSlide(Slide slide) {
        this.getBTDownloadMediator().openSlide(slide);
        this.showTransfers(TransfersTab.FilterMode.ALL);
    }

    public void openHttp(String httpUrl, String title, String saveFileAs, long fileSize) {
        this.showTransfers(TransfersTab.FilterMode.ALL);
        this.getBTDownloadMediator().openHttp(httpUrl, title, saveFileAs, fileSize);
    }

    public void startSearch(String query) {
        this.getMainFrame().getApplicationHeader().startSearch(query);
    }

    public void playInOS(MediaSource source) {
        if (source == null) {
            return;
        }
        if (source.getFile() != null) {
            GUIMediator.launchFile(source.getFile());
        } else if (source.getPlaylistItem() != null) {
            GUIMediator.launchFile(new File(source.getPlaylistItem().getFilePath()));
        } else if (source.getURL() != null) {
            GUIMediator.openURL(source.getURL());
        }
    }

    static {
        DISCONNECTED_MESSAGE = I18n.tr("Your machine does not appear to have an active Internet connection or a firewall is blocking FrostWire from accessing the internet. FrostWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu.");
        REFRESH_LIST = new ArrayList<RefreshListener>();
        APP_TITLE = I18n.tr("FrostWire: Share Big Files");
        _visibleOnce = false;
        _allowVisible = false;
        pool = new ThreadPool("GUIMediator-updateConnectionQuality", 1, 1, Integer.MAX_VALUE, new LinkedBlockingQueue<Runnable>(), true);
    }

    public static enum Tabs {
        SEARCH(I18n.tr("&Search")),
        TRANSFERS(I18n.tr("&Transfers")),
        SEARCH_TRANSFERS(I18n.tr("&Search")),
        LIBRARY(I18n.tr("&Library"));

        private Action navAction;
        private String name;
        public boolean navigatedTo;
        private final PropertyChangeSupport propertyChangeSupport;

        private Tabs(String nameWithAmpersand) {
            this.name = GUIUtils.stripAmpersand(nameWithAmpersand);
            this.navAction = new NavigationAction(nameWithAmpersand, I18n.tr("Display the {0} Screen", this.name));
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }

        void setName(String newName) {
            String oldName = this.name;
            this.name = GUIUtils.stripAmpersand(newName);
            this.navAction.putValue("Name", newName);
            this.navAction.putValue("LongDescription", I18n.tr("Display the {0} Screen", this.name));
            this.propertyChangeSupport.firePropertyChange("name", oldName, this.name);
        }

        void setEnabled(boolean enabled) {
            this.navAction.setEnabled(enabled);
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.navAction.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        private class NavigationAction
        extends AbstractAction {
            NavigationAction(String name, String description) {
                super(name);
                this.putValue("LongDescription", description);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().setWindow(Tabs.this);
            }
        }
    }
}

