/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import org.limewire.service.ErrorService;

public final class GURLHandler {
    private static final Logger LOG = Logger.getLogger(GURLHandler.class);
    private static GURLHandler instance;
    private volatile boolean registered = false;

    public static synchronized GURLHandler getInstance() {
        if (instance == null) {
            instance = new GURLHandler();
        }
        return instance;
    }

    private void callback(String uri) {
        LOG.debug("URI: " + uri);
        if (uri.startsWith("magnet:?xt=urn:btih")) {
            GUIMediator.instance().openTorrentURI(uri, false);
        }
    }

    public void register() {
        if (!this.registered && this.InstallEventHandler() == 0) {
            this.registered = true;
        }
    }

    protected void finalize() throws Throwable {
        if (this.registered) {
            this.RemoveEventHandler();
        }
    }

    private final synchronized native int InstallEventHandler();

    private final synchronized native int RemoveEventHandler();

    static {
        try {
            System.loadLibrary("GURLLeopard");
        }
        catch (Throwable err) {
            ErrorService.error(err);
        }
    }
}

