/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageWindow;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LanguageButton
extends JPanel {
    private static final long serialVersionUID = 1795381168007012403L;
    private JButton bheader = new JButton();

    public LanguageButton() {
        this.updateLanguageFlag();
        ActionListener languageButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LanguageWindow lw = new LanguageWindow();
                GUIUtils.centerOnScreen(lw);
                lw.setVisible(true);
            }
        };
        this.bheader.addActionListener(languageButtonListener);
        MouseAdapter languageMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        };
        this.bheader.addMouseListener(languageMouseListener);
        LanguageButton.zeroInsets(this);
        this.setBorder(null);
        this.adjustSizes(this.bheader, 28, 16);
        this.add(this.bheader);
    }

    public void updateLanguageFlag() {
        this.bheader.setContentAreaFilled(false);
        this.bheader.setBorderPainted(false);
        this.bheader.setOpaque(false);
        this.bheader.setIcon(LanguageFlagFactory.getFlag(ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LANGUAGE.getValue(), true));
        String tip = GUIMediator.getLocale().getDisplayName();
        this.bheader.setToolTipText(tip);
        this.setToolTipText(tip);
    }

    @Override
    public void addMouseListener(MouseListener m) {
        this.bheader.addMouseListener(m);
    }

    private void adjustSizes(JComponent jc, int width, int height) {
        LanguageButton.zeroInsets(jc);
        LanguageButton.setSizes((JButton)jc, width, height);
    }

    private static void setSizes(JButton b, int width, int height) {
        Dimension d = new Dimension(width, height);
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        b.setPreferredSize(d);
    }

    private static void zeroInsets(JComponent jc) {
        Insets insets = jc.getInsets();
        insets.left = 0;
        insets.right = 0;
        insets.top = 0;
        insets.bottom = 0;
    }
}

