/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.BTEngine;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.VPNStatusRefresher;
import com.limegroup.gnutella.gui.VPNs;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VPNDropGuard
implements VPNStatusRefresher.VPNStatusListener {
    public static boolean canUseBitTorrent(boolean showExplanationDialog) {
        return VPNDropGuard.canUseBitTorrent(showExplanationDialog, null);
    }

    static boolean canUseBitTorrent(boolean showExplanationDialog, Runnable uiCallback) {
        if (ConnectionSettings.VPN_DROP_PROTECTION.getValue() && !VPNs.isVPNActive()) {
            if (showExplanationDialog) {
                VPNDropGuard.showExplanationDialog(uiCallback);
            }
            return false;
        }
        return true;
    }

    private static void showExplanationDialog(final Runnable uiCallback) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                final JDialog dialog = new JDialog();
                dialog.setTitle(I18n.tr("VPN-Drop Protection Active"));
                dialog.setLayout(new FlowLayout());
                dialog.setModal(true);
                dialog.setResizable(false);
                JLabel icon = new JLabel(GUIMediator.getThemeImage("vpn_drop_guard_dialog_icon"));
                icon.setPreferredSize(new Dimension(115, 96));
                JPanel labelPanel = new JPanel(new MigLayout());
                labelPanel.add((Component)new JLabel("<html><p><strong>" + I18n.tr("BitTorrent is off because your VPN is disconnected") + "</strong></p></html>"), "wrap");
                labelPanel.add((Component)new JLabel("<html><p>" + I18n.tr("Check the status of your VPN connection or disable the VPN-Drop Protection") + ".</p></html>"), "wrap");
                JPanel upperPanel = new JPanel(new MigLayout());
                upperPanel.add(icon);
                upperPanel.add(labelPanel);
                JButton whatIsAVPN = new JButton(I18n.tr("What is a VPN?"));
                whatIsAVPN.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                        GUIMediator.openURL("http://www.frostwire.com/vpn");
                    }
                });
                JButton disableVPNDrop = new JButton(I18n.tr("Disable VPN-Drop protection"));
                disableVPNDrop.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                        ConnectionSettings.VPN_DROP_PROTECTION.setValue(false);
                        if (uiCallback != null) {
                            try {
                                uiCallback.run();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        MessageService.instance().showMessage(I18n.tr("VPN-Drop protection disabled. Restarting BitTorrent engine."));
                        BackgroundExecutorService.schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (BTEngine.getInstance().isPaused()) {
                                    BTEngine.getInstance().resume();
                                }
                            }
                        });
                    }
                });
                JButton ok = new JButton(I18n.tr("Ok"));
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                JPanel buttonsPanel = new JPanel(new MigLayout("insets 10px 0 0 0, align right", ""));
                buttonsPanel.add(whatIsAVPN);
                buttonsPanel.add(disableVPNDrop);
                buttonsPanel.add((Component)ok, "growx, shrink 0");
                JPanel panel = new JPanel(new MigLayout());
                panel.add((Component)upperPanel, "wrap");
                panel.add((Component)buttonsPanel, "growx");
                dialog.add(panel);
                dialog.setPreferredSize(new Dimension(700, 225));
                dialog.pack();
                dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
                dialog.setVisible(true);
            }
        });
    }

    public static boolean canUseBitTorrent() {
        return VPNDropGuard.canUseBitTorrent(true);
    }

    @Override
    public void onStatusUpdated(boolean vpnIsOn) {
        boolean vpnDropProtectionOn = ConnectionSettings.VPN_DROP_PROTECTION.getValue();
        BTEngine instance = BTEngine.getInstance();
        if (vpnDropProtectionOn) {
            if (vpnIsOn && instance.isPaused()) {
                instance.resume();
            }
            if (!vpnIsOn && !instance.isPaused()) {
                instance.pause();
            }
        } else if (!vpnDropProtectionOn && instance.isPaused()) {
            instance.resume();
        }
    }
}

