/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class WindowsUtils {
    private WindowsUtils() {
    }

    public static boolean isLoginStatusAvailable() {
        return OSUtils.isModernWindows();
    }

    public static void setLoginStatus(boolean allow) {
        if (!WindowsUtils.isLoginStatusAvailable()) {
            return;
        }
        File startMenu = WindowsUtils.getUserStartMenu();
        if (startMenu == null || !startMenu.exists()) {
            return;
        }
        char majorVersion = FrostWireUtils.getFrostWireVersion().charAt(0);
        String srcLnkPath = String.format("Programs\\FrostWire %s\\FrostWire %s.lnk", Character.valueOf(majorVersion), Character.valueOf(majorVersion));
        File src = new File(startMenu, srcLnkPath);
        File dst = new File(startMenu, "Programs\\Startup\\FrostWire On Startup.lnk");
        if (allow) {
            FileUtils.copy(src, dst);
        } else {
            dst.delete();
        }
    }

    public static File getUserStartMenu() {
        if (OSUtils.isModernWindows()) {
            return new File(System.getenv("appdata"), "Microsoft\\Windows\\Start Menu");
        }
        return null;
    }
}

