/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesImportSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class iTunesMediator {
    private static final Logger LOG = Logger.getLogger(iTunesMediator.class);
    private static final String JS_IMPORT_SCRIPT_NAME = "itunes_import.js";
    private static final String JS_REMOVE_PLAYLIST_SCRIPT_NAME = "itunes_remove_playlist.js";
    private static iTunesMediator INSTANCE;
    private final ExecutorService QUEUE = ExecutorsHelper.newFixedSizeThreadPool(4, "iTunesAdderThread");

    public static synchronized iTunesMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new iTunesMediator();
        }
        return INSTANCE;
    }

    private iTunesMediator() {
        if (OSUtils.isWindows()) {
            iTunesMediator.createiTunesJavaScript(JS_IMPORT_SCRIPT_NAME);
            iTunesMediator.createiTunesJavaScript(JS_REMOVE_PLAYLIST_SCRIPT_NAME);
        }
    }

    private void addSongsITunes(String playlist, File file) {
        File[] files;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            LOG.warn("File: '" + file + "' does not exist");
            return;
        }
        if (file.isDirectory()) {
            files = FileUtils.getFilesRecursive(file, iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue());
        } else if (file.isFile() && iTunesMediator.isSupported(FilenameUtils.getExtension(file.getName()))) {
            files = new File[]{file};
        } else {
            return;
        }
        if (files.length == 0) {
            return;
        }
        this.addSongsiTunes(playlist, files);
    }

    public void addSongsiTunes(String playlist, File[] files) {
        Set<File> ignorableFiles = TorrentUtil.getIgnorableFiles();
        ArrayList<File> completeFiles = new ArrayList<File>(files.length);
        for (File f : files) {
            if (ignorableFiles.contains(f) || !f.exists() || !f.isFile() || !iTunesMediator.isSupported(FilenameUtils.getExtension(f.getName()))) continue;
            completeFiles.add(f);
        }
        files = completeFiles.toArray(new File[completeFiles.size()]);
        if (files.length == 0) {
            return;
        }
        if (OSUtils.isMacOSX()) {
            this.QUEUE.execute(new ExecOSAScriptCommand(playlist, files));
        } else {
            LOG.info("Will add '" + files.length + " files' to Playlist");
            this.QUEUE.execute(new ExecWSHScriptCommand(playlist, files));
        }
    }

    private static boolean isSupported(String extension) {
        String[] types;
        if (extension == null) {
            return false;
        }
        for (String type : types = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue()) {
            if (!extension.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private static String[] createOSAScriptCommand(String playlist, File[] files) {
        int i;
        ArrayList<String> command = new ArrayList<String>();
        command.add("osascript");
        command.add("-e");
        command.add("tell application \"Finder\"");
        for (i = 0; i < files.length; ++i) {
            File f = files[i];
            String path = f.getAbsolutePath();
            command.add("-e");
            command.add("set hfsFile" + i + " to (POSIX file \"" + path + "\")");
        }
        command.add("-e");
        command.add("set thePlaylist to \"" + playlist + "\"");
        command.add("-e");
        command.add("tell application \"iTunes\"");
        command.add("-e");
        command.add("launch");
        command.add("-e");
        command.add("if not (exists playlist thePlaylist) then");
        command.add("-e");
        command.add("set thisPlaylist to make new playlist");
        command.add("-e");
        command.add("set name of thisPlaylist to thePlaylist");
        command.add("-e");
        command.add("end if");
        for (i = 0; i < files.length; ++i) {
            command.add("-e");
            command.add("add hfsFile" + i + " to playlist thePlaylist");
        }
        command.add("-e");
        command.add("end tell");
        command.add("-e");
        command.add("end tell");
        return command.toArray(new String[command.size()]);
    }

    private static String[] createWSHScriptCommand(String playlist, File[] files) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("wscript");
        command.add("//B");
        command.add("//NoLogo");
        command.add(new File(CommonUtils.getUserSettingsDir(), JS_IMPORT_SCRIPT_NAME).getAbsolutePath());
        command.add(playlist);
        for (File file : files) {
            command.add(file.getAbsolutePath());
        }
        return command.toArray(new String[command.size()]);
    }

    public void scanForSongs(File file) {
        this.scanForSongs(iTunesSettings.ITUNES_PLAYLIST.getValue(), file);
    }

    public void scanForSongs(File[] files) {
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            for (File f : files) {
                iTunesImportSettings.IMPORT_FILES.add(f);
            }
            this.addSongsiTunes(iTunesSettings.ITUNES_PLAYLIST.getValue(), files);
        }
    }

    private void scanForSongs(String playlist, File file) {
        iTunesImportSettings.IMPORT_FILES.add(file);
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.addSongsITunes(playlist, file);
        }
    }

    public boolean isScanned(File file) {
        return iTunesImportSettings.IMPORT_FILES.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createiTunesJavaScript(String scriptName) {
        FileOutputStream out;
        BufferedInputStream is;
        block5: {
            File fileJS = new File(CommonUtils.getUserSettingsDir(), scriptName);
            if (fileJS.exists()) {
                return;
            }
            URL url = ResourceManager.getURLResource(scriptName);
            is = null;
            out = null;
            try {
                if (url == null) break block5;
                is = new BufferedInputStream(url.openStream());
                out = new FileOutputStream(fileJS);
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
            catch (IOException e) {
                try {
                    LOG.error("Error creating iTunes javascript", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(out);
            }
        }
        IOUtils.closeQuietly(is);
        IOUtils.closeQuietly(out);
    }

    void deleteFrostWirePlaylist() {
        String playlistName = iTunesSettings.ITUNES_PLAYLIST.getValue();
        try {
            if (OSUtils.isMacOSX()) {
                String[] command = new String[]{"osascript", "-e", "tell application \"iTunes\"", "-e", "delete playlist \"" + playlistName + "\"", "-e", "end tell"};
                Runtime.getRuntime().exec(command);
            } else if (OSUtils.isWindows()) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("wscript");
                command.add("//B");
                command.add("//NoLogo");
                command.add(new File(CommonUtils.getUserSettingsDir(), JS_REMOVE_PLAYLIST_SCRIPT_NAME).getAbsolutePath());
                command.add(playlistName);
                Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
            }
        }
        catch (IOException e) {
            LOG.error("Error executing itunes command", e);
        }
    }

    public void resetFrostWirePlaylist() {
        this.deleteFrostWirePlaylist();
        this.QUEUE.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iTunesMediator.instance().scanForSongs(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue());
            }
        });
    }

    private static <T> List<T[]> splitArray(T[] items, int maxSubArraySize) {
        T[] slice;
        ArrayList<T[]> result = new ArrayList<T[]>();
        if (items == null || items.length == 0) {
            return result;
        }
        int from = 0;
        int to = 0;
        for (int slicedItems = 0; slicedItems < items.length; slicedItems += slice.length) {
            to = from + Math.min(maxSubArraySize, items.length - to);
            slice = Arrays.copyOfRange(items, from, to);
            result.add(slice);
            from = to;
        }
        return result;
    }

    private class ExecWSHScriptCommand
    implements Runnable {
        private final int MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS = 100;
        private final String playlist;
        private final File[] files;

        public ExecWSHScriptCommand(String playlist, File[] files) {
            this.playlist = playlist;
            this.files = files;
        }

        @Override
        public void run() {
            try {
                if (this.files.length > 100) {
                    List fileArrays = iTunesMediator.splitArray(this.files, 100);
                    for (File[] fileSubset : fileArrays) {
                        Runtime.getRuntime().exec(iTunesMediator.createWSHScriptCommand(this.playlist, fileSubset));
                    }
                } else {
                    Runtime.getRuntime().exec(iTunesMediator.createWSHScriptCommand(this.playlist, this.files));
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    private class ExecOSAScriptCommand
    implements Runnable {
        private final int MAX_SCRIPT_FILE_NUMBER_OF_ARGUMENTS = 300;
        private final String playlist;
        private final File[] files;

        public ExecOSAScriptCommand(String playlist, File[] files) {
            this.playlist = playlist;
            this.files = files;
        }

        @Override
        public void run() {
            try {
                if (this.files.length > 300) {
                    List fileArrays = iTunesMediator.splitArray(this.files, 300);
                    for (File[] fileSubset : fileArrays) {
                        Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.playlist, fileSubset));
                    }
                } else {
                    Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.playlist, this.files));
                }
            }
            catch (Throwable e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }
}

