/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.gui.library.AddLibraryDirectoryAction;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.RecursiveLibraryDirectoryPanel;
import com.frostwire.gui.library.RemoveLibraryDirectoryAction;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

public final class LibraryFoldersPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Library Included Folders");
    public static final String LABEL = I18n.tr("You can choose the folders for include files when browsing the library.");
    private final JButton buttonAddLibraryDirectory;
    private final JButton buttonRemoveLibraryDirectory;
    private final RecursiveLibraryDirectoryPanel directoryPanel = new RecursiveLibraryDirectoryPanel(true, new File[0]);
    private Set<File> initialFoldersToInclude;
    private Set<File> initialFoldersToExclude;
    private final boolean isPortable = CommonUtils.isPortable();

    public LibraryFoldersPaneItem() {
        super(TITLE, LABEL);
        this.buttonAddLibraryDirectory = new JButton(new AddLibraryDirectoryAction(this.directoryPanel, this.directoryPanel));
        this.buttonRemoveLibraryDirectory = new JButton(new RemoveLibraryDirectoryAction(this.directoryPanel));
        this.directoryPanel.getTree().setRootVisible(false);
        this.directoryPanel.getTree().setShowsRootHandles(true);
        if (!this.isPortable) {
            this.directoryPanel.getTree().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    Object comp = e.getPath().getLastPathComponent();
                    if (comp instanceof File && comp.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                        LibraryFoldersPaneItem.this.buttonRemoveLibraryDirectory.setEnabled(false);
                        return;
                    }
                    LibraryFoldersPaneItem.this.buttonRemoveLibraryDirectory.setEnabled(true);
                }
            });
        } else {
            this.removeTreeSelectionListeners();
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.add((Component)this.buttonAddLibraryDirectory, "North");
        buttons.add(Box.createVerticalStrut(4), "Center");
        buttons.add((Component)this.buttonRemoveLibraryDirectory, "South");
        buttonPanel.add((Component)buttons, "North");
        this.directoryPanel.addEastPanel(buttonPanel);
        this.add(this.directoryPanel);
        this.directoryPanel.getTree().setEnabled(!this.isPortable);
        this.buttonAddLibraryDirectory.setEnabled(!this.isPortable);
        this.buttonRemoveLibraryDirectory.setEnabled(!this.isPortable);
    }

    private void removeTreeSelectionListeners() {
        TreeSelectionListener[] treeSelectionListeners;
        for (TreeSelectionListener tsl : treeSelectionListeners = this.directoryPanel.getTree().getTreeSelectionListeners()) {
            this.directoryPanel.getTree().removeTreeSelectionListener(tsl);
        }
    }

    void addAndKeepDirtyStatus(Set<File> foldersToShare, Set<File> foldersToExclude) {
        for (File folder : foldersToShare) {
            this.directoryPanel.addRoot(folder);
        }
        this.directoryPanel.addFoldersToExclude(foldersToExclude);
    }

    boolean isAlreadyGoingToBeIncluded(File dir) {
        if (this.directoryPanel.getFoldersToExclude().contains(dir)) {
            return false;
        }
        for (File folder : this.directoryPanel.getRootsToInclude()) {
            if (!FileUtils.isAncestor(folder, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initOptions() {
        this.initialFoldersToInclude = LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue();
        this.initialFoldersToExclude = LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue();
        ArrayList<File> roots = new ArrayList<File>(LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue());
        roots.addAll(LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
        this.directoryPanel.setRoots(roots.toArray(new File[0]));
        this.directoryPanel.setFoldersToExclude(this.initialFoldersToExclude);
    }

    @Override
    public boolean applyOptions() throws IOException {
        LibrarySettings.DIRECTORIES_TO_INCLUDE.setValue(new HashSet());
        LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.setValue(new HashSet());
        for (File f : this.directoryPanel.getRootsToInclude()) {
            if (f == null) continue;
            LibrarySettings.DIRECTORIES_TO_INCLUDE.add(f);
        }
        for (File f : this.directoryPanel.getFoldersToExclude()) {
            if (f == null) continue;
            if (f.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                LibrarySettings.DIRECTORIES_TO_INCLUDE.add(f);
                continue;
            }
            System.out.println("Not including " + f.getAbsolutePath());
            LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.add(f);
        }
        LibraryMediator.instance().clearDirectoryHolderCaches();
        return false;
    }

    @Override
    public boolean isDirty() {
        return !this.initialFoldersToInclude.equals(this.directoryPanel.getRootsToInclude()) || !this.initialFoldersToExclude.equals(this.directoryPanel.getFoldersToExclude());
    }
}

