/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.swig.settings_pack;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class ProxyPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Proxy Options");
    public static final String LABEL = I18n.tr("Configure Proxy Options for FrostWire.");
    private final String PROXY_HOST_LABEL_KEY = I18n.tr("Proxy:");
    private final String PROXY_PORT_LABEL_KEY = I18n.tr("Port:");
    private final ButtonGroup BUTTONS = new ButtonGroup();
    private final JRadioButton NO_PROXY_BUTTON = new JRadioButton(I18n.tr("No Proxy"));
    private final JRadioButton SOCKS4_PROXY_BUTTON = new JRadioButton("Socks v4");
    private final JRadioButton SOCKS5_PROXY_BUTTON = new JRadioButton("Socks v5");
    private final JRadioButton HTTP_PROXY_BUTTON = new JRadioButton("HTTP");
    private final JTextField PROXY_HOST_FIELD = new SizedTextField(12, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
    private final WholeNumberField PROXY_PORT_FIELD = new SizedWholeNumberField(8080, 5, GUIUtils.SizePolicy.RESTRICT_BOTH);

    public ProxyPaneItem() {
        super(TITLE, LABEL);
        this.BUTTONS.add(this.NO_PROXY_BUTTON);
        this.BUTTONS.add(this.SOCKS4_PROXY_BUTTON);
        this.BUTTONS.add(this.SOCKS5_PROXY_BUTTON);
        this.BUTTONS.add(this.HTTP_PROXY_BUTTON);
        this.NO_PROXY_BUTTON.addItemListener(new LocalProxyListener());
        this.add(this.NO_PROXY_BUTTON);
        this.add(this.SOCKS4_PROXY_BUTTON);
        this.add(this.SOCKS5_PROXY_BUTTON);
        this.add(this.HTTP_PROXY_BUTTON);
        this.add(this.getHorizontalSeparator());
        BoxPanel panel = new BoxPanel(0);
        LabeledComponent comp = new LabeledComponent(this.PROXY_HOST_LABEL_KEY, this.PROXY_HOST_FIELD, 150, 10);
        panel.add(comp.getComponent());
        panel.addHorizontalComponentGap();
        comp = new LabeledComponent(this.PROXY_PORT_LABEL_KEY, this.PROXY_PORT_FIELD, 150, 10);
        panel.add(comp.getComponent());
        this.add(panel);
    }

    @Override
    public void initOptions() {
        String proxy = ConnectionSettings.PROXY_HOST.getValue();
        int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
        int connectionMethod = ConnectionSettings.CONNECTION_METHOD.getValue();
        this.PROXY_PORT_FIELD.setValue(proxyPort);
        this.NO_PROXY_BUTTON.setSelected(connectionMethod == 0);
        this.SOCKS4_PROXY_BUTTON.setSelected(connectionMethod == 4);
        this.SOCKS5_PROXY_BUTTON.setSelected(connectionMethod == 5);
        this.HTTP_PROXY_BUTTON.setSelected(connectionMethod == 1);
        this.PROXY_HOST_FIELD.setText(proxy);
        this.updateState();
    }

    @Override
    public boolean applyOptions() throws IOException {
        int connectionMethod = 0;
        if (this.SOCKS4_PROXY_BUTTON.isSelected()) {
            connectionMethod = 4;
        } else if (this.SOCKS5_PROXY_BUTTON.isSelected()) {
            connectionMethod = 5;
        } else if (this.HTTP_PROXY_BUTTON.isSelected()) {
            connectionMethod = 1;
        }
        int proxyPort = this.PROXY_PORT_FIELD.getValue();
        String proxyHost = this.PROXY_HOST_FIELD.getText();
        ConnectionSettings.PROXY_PORT.setValue(proxyPort);
        ConnectionSettings.CONNECTION_METHOD.setValue(connectionMethod);
        ConnectionSettings.PROXY_HOST.setValue(proxyHost);
        SettingsPack settings = new SettingsPack();
        if (connectionMethod == 0) {
            settings.setInteger(settings_pack.int_types.proxy_type.swigValue(), settings_pack.proxy_type_t.none.swigValue());
        } else if (connectionMethod == 1) {
            settings.setInteger(settings_pack.int_types.proxy_type.swigValue(), settings_pack.proxy_type_t.http.swigValue());
        } else if (connectionMethod == 4) {
            settings.setInteger(settings_pack.int_types.proxy_type.swigValue(), settings_pack.proxy_type_t.socks4.swigValue());
        } else if (connectionMethod == 5) {
            settings.setInteger(settings_pack.int_types.proxy_type.swigValue(), settings_pack.proxy_type_t.socks5.swigValue());
        }
        settings.setString(settings_pack.string_types.proxy_hostname.swigValue(), proxyHost);
        settings.setInteger(settings_pack.int_types.proxy_port.swigValue(), proxyPort);
        BTEngine.getInstance().applySettings(settings);
        return false;
    }

    @Override
    public boolean isDirty() {
        if (ConnectionSettings.PROXY_PORT.getValue() != this.PROXY_PORT_FIELD.getValue()) {
            return true;
        }
        if (!ConnectionSettings.PROXY_HOST.getValue().equals(this.PROXY_HOST_FIELD.getText())) {
            return true;
        }
        switch (ConnectionSettings.CONNECTION_METHOD.getValue()) {
            case 4: {
                return !this.SOCKS4_PROXY_BUTTON.isSelected();
            }
            case 5: {
                return !this.SOCKS5_PROXY_BUTTON.isSelected();
            }
            case 1: {
                return !this.HTTP_PROXY_BUTTON.isSelected();
            }
            case 0: {
                return !this.NO_PROXY_BUTTON.isSelected();
            }
        }
        return true;
    }

    private void updateState() {
        this.PROXY_HOST_FIELD.setEditable(!this.NO_PROXY_BUTTON.isSelected());
        this.PROXY_PORT_FIELD.setEditable(!this.NO_PROXY_BUTTON.isSelected());
        this.PROXY_HOST_FIELD.setEnabled(!this.NO_PROXY_BUTTON.isSelected());
        this.PROXY_PORT_FIELD.setEnabled(!this.NO_PROXY_BUTTON.isSelected());
    }

    private class LocalProxyListener
    implements ItemListener {
        private LocalProxyListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ProxyPaneItem.this.updateState();
        }
    }
}

