/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public final class SmartSearchDBPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Smart Search");
    public static final String LABEL = I18n.tr("The Smart Search database is used to speed up individual file searches, it's how FrostWire remembers information about .torrent contents.");
    private JLabel _numTorrentsLabel;
    private JCheckBox smartSearchEnabled;
    private long _numTorrents = 0L;

    public SmartSearchDBPaneItem() {
        super(TITLE, LABEL);
        Font font = new Font("dialog", 1, 12);
        this._numTorrentsLabel = new JLabel();
        this._numTorrentsLabel.setFont(font);
        this.smartSearchEnabled = new JCheckBox(I18n.tr("Enable Smart Search"), SearchSettings.SMART_SEARCH_ENABLED.getValue());
        LabeledComponent numTorrentsComp = new LabeledComponent(I18n.tr("Total torrents indexed"), this._numTorrentsLabel);
        this.add(this.getVerticalSeparator());
        JButton resetButton = new JButton(I18n.tr("Reset Smart Search Database"));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SmartSearchDBPaneItem.this.resetSmartSearchDB();
                        SmartSearchDBPaneItem.this.initOptions();
                    }
                });
            }
        });
        this.add(this.smartSearchEnabled);
        this.add(this.getVerticalSeparator());
        this.add(numTorrentsComp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(resetButton);
    }

    protected void resetSmartSearchDB() {
        DialogOption showConfirmDialog = GUIMediator.showYesNoMessage(I18n.tr("If you continue you will erase all the information related to\n{0} torrents that FrostWire has learned to speed up your search results.\nDo you wish to continue?", this._numTorrents), I18n.tr("Are you sure?"), 3);
        if (showConfirmDialog == DialogOption.YES) {
            SearchMediator.instance().clearCache();
        }
    }

    @Override
    public void initOptions() {
        this._numTorrentsLabel.setText("...");
        BackgroundExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                SmartSearchDBPaneItem.this._numTorrents = SearchMediator.instance().getTotalTorrents();
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SmartSearchDBPaneItem.this._numTorrentsLabel.setText(String.valueOf(SmartSearchDBPaneItem.this._numTorrents));
                        SmartSearchDBPaneItem.this.smartSearchEnabled.setSelected(SearchSettings.SMART_SEARCH_ENABLED.getValue());
                    }
                });
            }
        });
    }

    @Override
    public boolean applyOptions() throws IOException {
        SearchSettings.SMART_SEARCH_ENABLED.setValue(this.smartSearchEnabled.isSelected());
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

