/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.MacOSXUtils;
import javax.swing.JCheckBox;
import org.limewire.util.OSUtils;

public final class StartupPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("System Startup");
    public static final String LABEL = I18n.tr("You can choose whether or not to automatically run FrostWire when your computer starts.");
    private final String CHECK_BOX_LABEL = I18n.tr("Run on System Startup:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public StartupPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
    }

    @Override
    public boolean applyOptions() {
        StartupSettings.RUN_ON_STARTUP.setValue(this.CHECK_BOX.isSelected());
        if (OSUtils.isMacOSX()) {
            MacOSXUtils.setLoginStatus(this.CHECK_BOX.isSelected());
        } else if (WindowsUtils.isLoginStatusAvailable()) {
            WindowsUtils.setLoginStatus(this.CHECK_BOX.isSelected());
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return StartupSettings.RUN_ON_STARTUP.getValue() != this.CHECK_BOX.isSelected();
    }
}

