/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.theme.SkinTableUI;
import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.tables.BeveledCellPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class FWAbstractJPanelTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private JTable table;
    private boolean isSelected;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        this.isSelected = isSelected;
        this.updateUIData(value, table, row, column);
        this.setOpaque(true);
        this.setEnabled(table.isEnabled());
        this.updateRowBackgroundColor(isSelected, row);
        this.initializeDefaultMouseListeners();
        return this;
    }

    private void updateRowBackgroundColor(boolean isSelected, int row) {
        if (isSelected) {
            this.setBackground(ThemeMediator.TABLE_SELECTED_BACKGROUND_ROW_COLOR);
        } else {
            this.setBackground(row % 2 == 1 ? ThemeMediator.TABLE_ALTERNATE_ROW_COLOR : Color.WHITE);
        }
    }

    private void initializeDefaultMouseListeners() {
        if (this.getMouseListeners() == null || this.getMouseListeners().length == 0) {
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    FWAbstractJPanelTableCellRenderer.this.cancelEdit();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FWAbstractJPanelTableCellRenderer.this.cancelEdit();
                }
            });
        }
    }

    protected void cancelEdit() {
        if (this.table != null && this.table.isEditing()) {
            TableCellEditor editor = this.table.getCellEditor();
            editor.cancelCellEditing();
        }
    }

    protected abstract void updateUIData(Object var1, JTable var2, int var3, int var4);

    protected boolean mouseIsOverRow(JTable table, int row) {
        boolean mouseOver = false;
        try {
            TableUI ui = table.getUI();
            if (ui instanceof SkinTableUI) {
                mouseOver = ((SkinTableUI)ui).getRowAtMouse() == row;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mouseOver;
    }

    protected void syncFontSize(JTable table, JComponent c) {
        Font tableFont = table.getFont();
        if (tableFont != null && !tableFont.equals(c.getFont())) {
            Font syncedFont = c.getFont().deriveFont((float)table.getFont().getSize());
            c.setFont(syncedFont);
        }
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || propertyName == "labelFor" || propertyName == "displayedMnemonic" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        try {
            Component[] components = this.getComponents();
            Point p = event.getPoint();
            int row = this.table.rowAtPoint(p);
            int col = this.table.columnAtPoint(p);
            Rectangle currentCell = this.table.getCellRect(row, col, false);
            p.translate(-currentCell.x, -currentCell.y);
            for (Component c : components) {
                JComponent jc = (JComponent)c;
                if (!jc.isVisible() || !jc.getBounds().contains(p)) continue;
                return jc.getToolTipText(event);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getToolTipText(event);
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (!this.isSelected) {
            BeveledCellPainter.paintBorder(g, this.getWidth(), this.getHeight());
        }
    }
}

