/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FileSetting;
import org.limewire.util.CommonUtils;

public class SharingSettings
extends LimeProps {
    private static final File PORTABLE_ROOT_FOLDER = CommonUtils.getPortableRootFolder();
    public static final File DEFAULT_TORRENTS_DIR = new File(PORTABLE_ROOT_FOLDER == null ? FrostWireUtils.getFrostWireRootFolder() : PORTABLE_ROOT_FOLDER, "Torrents");
    public static final FileSetting TORRENTS_DIR_SETTING = FACTORY.createFileSetting("TORRENTS_DIR_SETTING", DEFAULT_TORRENTS_DIR).setAlwaysSave(true);
    public static final File DEFAULT_TORRENT_DATA_DIR = PORTABLE_ROOT_FOLDER == null ? new File(FrostWireUtils.getFrostWireRootFolder(), "Torrent Data") : new File(PORTABLE_ROOT_FOLDER, "Downloads");
    public static final FileSetting TORRENT_DATA_DIR_SETTING = FACTORY.createFileSetting("DEFAULT_TORRENT_DATA_DIR_SETTING", DEFAULT_TORRENT_DATA_DIR).setAlwaysSave(true);
    public static final BooleanSetting SEED_FINISHED_TORRENTS = FACTORY.createBooleanSetting("SEED_FINISHED_TORRENTS", true);
    public static final BooleanSetting ENABLE_DISTRIBUTED_HASH_TABLE = FACTORY.createBooleanSetting("ENABLE_DISTRIBUTED_HASH_TABLE", true);
    public static final File IMAGE_CACHE_DIR = new File(CommonUtils.getUserSettingsDir(), "image_cache");
    public static final BooleanSetting ALLOW_PARTIAL_SHARING = FACTORY.createBooleanSetting("ALLOW_PARTIAL_SHARING", false);

    private SharingSettings() {
    }

    public static final File getImageCacheDirectory() {
        if (!IMAGE_CACHE_DIR.exists()) {
            IMAGE_CACHE_DIR.mkdirs();
        }
        return IMAGE_CACHE_DIR;
    }

    public static void initTorrentDataDirSetting() {
        if (CommonUtils.isPortable()) {
            TORRENT_DATA_DIR_SETTING.setValue(DEFAULT_TORRENT_DATA_DIR);
        }
    }

    public static void initTorrentsDirSetting() {
        if (CommonUtils.isPortable()) {
            TORRENTS_DIR_SETTING.setValue(DEFAULT_TORRENTS_DIR);
        }
        if (!TORRENTS_DIR_SETTING.getValue().exists()) {
            TORRENTS_DIR_SETTING.getValue().mkdirs();
        }
    }
}

