/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class AEMonSem {
    protected static boolean DEBUG = false;
    protected static boolean DEBUG_CHECK_DUPLICATES = false;
    protected static long DEBUG_TIMER = 30000L;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return new Stack();
        }
    };
    private static long monitor_id_next;
    private static long semaphore_id_next;
    private static Map debug_traces;
    private static List debug_recursions;
    private static List debug_reciprocals;
    private static Map debug_name_mapping;
    private static Map debug_monitors;
    private static Map debug_semaphores;
    protected long entry_count;
    protected long last_entry_count;
    protected String last_trace_key;
    protected String name;
    protected boolean is_monitor;
    protected int waiting = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void check(AEDiagnosticsLogger diag_logger) {
        ArrayList<AEMonSem> active = new ArrayList<AEMonSem>();
        ArrayList<AEMonitor> waiting_monitors = new ArrayList<AEMonitor>();
        ArrayList<AEMonitor> busy_monitors = new ArrayList<AEMonitor>();
        ArrayList<AEMonSem> waiting_semaphores = new ArrayList<AEMonSem>();
        Class<AEMonSem> clazz = AEMonSem.class;
        synchronized (AEMonSem.class) {
            Thread last_waiter;
            int i;
            diag_logger.log("AEMonSem: mid = " + monitor_id_next + ", sid = " + semaphore_id_next + ", monitors = " + debug_monitors.size() + ", semaphores = " + debug_semaphores.size() + ", names = " + debug_name_mapping.size() + ", traces = " + debug_traces.size());
            Iterator it = debug_monitors.keySet().iterator();
            long new_mon_entries = 0L;
            while (it.hasNext()) {
                AEMonitor monitor = (AEMonitor)it.next();
                long diff = monitor.entry_count - monitor.last_entry_count;
                if (diff != 0L) {
                    active.add(monitor);
                    new_mon_entries += diff;
                }
                if (monitor.waiting > 0) {
                    waiting_monitors.add(monitor);
                    continue;
                }
                if (monitor.owner == null) continue;
                busy_monitors.add(monitor);
            }
            it = debug_semaphores.keySet().iterator();
            long new_sem_entries = 0L;
            while (it.hasNext()) {
                AEMonSem semaphore = (AEMonSem)it.next();
                long diff = semaphore.entry_count - semaphore.last_entry_count;
                if (diff != 0L) {
                    active.add(semaphore);
                    new_sem_entries += diff;
                }
                if (semaphore.waiting <= 0) continue;
                waiting_semaphores.add(semaphore);
            }
            diag_logger.log("    activity: monitors = " + new_mon_entries + " - " + new_mon_entries / (DEBUG_TIMER / 1000L) + "/sec, semaphores = " + new_sem_entries + " - " + new_sem_entries / (DEBUG_TIMER / 1000L) + "/sec ");
            // ** MonitorExit[var5_5] (shouldn't be in output)
            AEMonSem[] x = new AEMonSem[active.size()];
            active.toArray(x);
            Arrays.sort(x, new Comparator(){

                public int compare(Object o1, Object o2) {
                    AEMonSem a1 = (AEMonSem)o1;
                    AEMonSem a2 = (AEMonSem)o2;
                    return a1.name.compareTo(a2.name);
                }
            });
            AEMonSem current = null;
            long current_total = 0L;
            Object[][] total_x = new Object[x.length][];
            int total_pos = 0;
            for (int i2 = 0; i2 < x.length; ++i2) {
                AEMonSem ms = x[i2];
                long diff = ms.entry_count - ms.last_entry_count;
                if (current == null) {
                    current = ms;
                    continue;
                }
                if (current.name.equals(ms.name)) {
                    current_total += diff;
                    continue;
                }
                total_x[total_pos++] = new Object[]{current.name, new Long(current_total)};
                current = ms;
                current_total = diff;
            }
            if (current != null) {
                total_x[total_pos++] = new Object[]{current.name, new Long(current_total)};
            }
            Arrays.sort(total_x, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Object[] a1 = (Object[])o1;
                    Object[] a2 = (Object[])o2;
                    if (a1 == null && a2 == null) {
                        return 0;
                    }
                    if (a1 == null) {
                        return 1;
                    }
                    if (a2 == null) {
                        return -1;
                    }
                    long a1_count = (Long)a1[1];
                    long a2_count = (Long)a2[1];
                    return (int)(a2_count - a1_count);
                }
            });
            String top_act_str = "    top activity: ";
            for (i = 0; i < Math.min(10, total_x.length); ++i) {
                if (total_x[i] == null) continue;
                top_act_str = top_act_str + (i == 0 ? "" : ", ") + total_x[i][0] + " = " + total_x[i][1];
            }
            diag_logger.log(top_act_str);
            if (waiting_monitors.size() > 0) {
                diag_logger.log("    waiting monitors");
                for (i = 0; i < waiting_monitors.size(); ++i) {
                    AEMonSem ms = (AEMonSem)waiting_monitors.get(i);
                    last_waiter = ((AEMonitor)ms).last_waiter;
                    diag_logger.log("        [" + (last_waiter == null ? "<waiter lost>" : last_waiter.getName()) + "] " + ms.name + " - " + ms.last_trace_key);
                }
            }
            if (busy_monitors.size() > 0) {
                diag_logger.log("    busy monitors");
                for (i = 0; i < busy_monitors.size(); ++i) {
                    AEMonSem ms = (AEMonSem)busy_monitors.get(i);
                    Thread owner = ((AEMonitor)ms).owner;
                    diag_logger.log("        [" + (owner == null ? "<owner lost>" : owner.getName()) + "] " + ms.name + " - " + ms.last_trace_key);
                }
            }
            if (waiting_semaphores.size() > 0) {
                diag_logger.log("    waiting semaphores");
                for (i = 0; i < waiting_semaphores.size(); ++i) {
                    AEMonSem ms = (AEMonSem)waiting_semaphores.get(i);
                    last_waiter = ((AESemaphore)ms).latest_waiter;
                    diag_logger.log("        [" + (last_waiter == null ? "<waiter lost>" : last_waiter.getName()) + "] " + ms.name + " - " + ms.last_trace_key);
                }
            }
            for (i = 0; i < x.length; ++i) {
                AEMonSem ms = x[i];
                ms.last_entry_count = ms.entry_count;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AEMonSem(String _name, boolean _monitor) {
        this.is_monitor = _monitor;
        this.name = this.is_monitor ? _name : "(S)" + _name;
        if (!DEBUG) return;
        Class<AEMonSem> clazz = AEMonSem.class;
        synchronized (AEMonSem.class) {
            if (this.is_monitor) {
                ++monitor_id_next;
            } else {
                ++semaphore_id_next;
            }
            StackTraceElement elt = new Exception().getStackTrace()[2];
            String class_name = elt.getClassName();
            int line_number = elt.getLineNumber();
            monSemData new_entry = new monSemData(class_name, line_number);
            if (this.is_monitor) {
                debug_monitors.put(this, new_entry);
            } else {
                debug_semaphores.put(this, new_entry);
            }
            if (!DEBUG_CHECK_DUPLICATES) return;
            monSemData existing_name_entry = (monSemData)debug_name_mapping.get(this.name);
            if (existing_name_entry == null) {
                debug_name_mapping.put(this.name, new_entry);
            } else {
                if (existing_name_entry.class_name.equals(class_name) && existing_name_entry.line_number == line_number) return;
                Debug.out(new Exception("Duplicate AEMonSem name '" + this.name + "'"));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debugEntry() {
        block23: {
            try {
                Stack stack = (Stack)tls.get();
                if (stack.size() > 64) {
                    StringBuffer sb = new StringBuffer(1024);
                    for (int i = 0; i < stack.size(); ++i) {
                        AEMonSem mon = (AEMonSem)stack.get(i);
                        sb.append("$" + mon.name);
                    }
                    Debug.out("**** Whoaaaaaa, AEMonSem debug stack is getting too large!!!! **** " + sb);
                }
                if (!stack.isEmpty()) {
                    String recursion_trace = "";
                    StringBuffer sb = new StringBuffer();
                    boolean check_recursion = this.is_monitor && !debug_recursions.contains(this.name);
                    String prev_name = null;
                    for (int i = 0; i < stack.size(); ++i) {
                        AEMonSem mon = (AEMonSem)stack.get(i);
                        if (check_recursion && mon.name.equals(this.name) && mon != this) {
                            recursion_trace = recursion_trace + (recursion_trace.length() == 0 ? "" : "\r\n") + "Recursive locks on different instances: " + this.name;
                            debug_recursions.add(this.name);
                        }
                        if (prev_name == null || !mon.name.equals(prev_name)) {
                            sb.append("$");
                            sb.append(mon.name);
                        }
                        prev_name = mon.name;
                    }
                    sb.append("$");
                    sb.append(this.name);
                    sb.append("$");
                    String trace_key = sb.toString();
                    if (recursion_trace.length() > 0) {
                        Debug.outNoStack(recursion_trace + "\r\n    " + trace_key);
                    }
                    this.last_trace_key = trace_key;
                    if (!this.is_monitor) {
                        boolean match = false;
                        for (int i = 0; i < stack.size(); ++i) {
                            AEMonSem ms = (AEMonSem)stack.get(i);
                            if (!ms.name.equals(this.name)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            stack.push(this);
                        }
                    } else {
                        stack.push(this);
                    }
                    Map map = debug_traces;
                    synchronized (map) {
                        if (debug_traces.get(trace_key) == null) {
                            Thread thread = Thread.currentThread();
                            String thread_name = thread.getName() + "[" + thread.hashCode() + "]";
                            String stack_trace = Debug.getStackTrace(true, false);
                            for (String old_key : debug_traces.keySet()) {
                                int i;
                                String[] data = (String[])debug_traces.get(old_key);
                                String old_thread_name = data[0];
                                String old_trace = data[1];
                                if (thread_name.equals(old_thread_name)) continue;
                                int earliest_common = stack.size();
                                int common_count = 0;
                                for (i = 0; i < stack.size(); ++i) {
                                    String n1 = ((AEMonSem)stack.get((int)i)).name;
                                    int p1 = old_key.indexOf("$" + n1 + "$");
                                    if (p1 == -1) continue;
                                    ++common_count;
                                    earliest_common = Math.min(earliest_common, i + 1);
                                }
                                if (common_count < 2) continue;
                                for (i = 0; i < earliest_common; ++i) {
                                    AEMonSem ms1 = (AEMonSem)stack.get(i);
                                    if (!ms1.is_monitor) continue;
                                    String n1 = ms1.name;
                                    for (int j = i + 1; j < stack.size(); ++j) {
                                        String reciprocal_log;
                                        String n2;
                                        AEMonSem ms2 = (AEMonSem)stack.get(j);
                                        if (!ms2.is_monitor || n1.equals(n2 = ms2.name)) continue;
                                        int p1 = old_key.indexOf("$" + n1 + "$");
                                        int p2 = old_key.indexOf("$" + n2 + "$");
                                        if (p1 == -1 || p2 == -1 || p1 <= p2 || debug_reciprocals.contains(reciprocal_log = trace_key + " / " + old_key)) continue;
                                        debug_reciprocals.add(reciprocal_log);
                                        Debug.outNoStack("AEMonSem: Reciprocal usage:\r\n    " + trace_key + "\r\n        [" + thread_name + "] " + stack_trace + "\r\n    " + old_key + "\r\n        [" + old_thread_name + "] " + old_trace);
                                    }
                                }
                            }
                            debug_traces.put(trace_key, new String[]{thread_name, stack_trace});
                        }
                        break block23;
                    }
                }
                this.last_trace_key = "$" + this.name + "$";
                stack.push(this);
            }
            catch (Throwable e) {
                try {
                    Debug.printStackTrace(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected void debugExit() {
        try {
            Stack stack = (Stack)tls.get();
            if (this.is_monitor) {
                while (stack.peek() != this) {
                    stack.pop();
                }
                stack.pop();
            } else if (!stack.isEmpty() && stack.peek() == this) {
                stack.pop();
            }
        }
        catch (Throwable e) {
            try {
                Debug.printStackTrace(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    static {
        debug_traces = new HashMap();
        debug_recursions = new ArrayList();
        debug_reciprocals = new ArrayList();
        debug_name_mapping = new WeakHashMap();
        debug_monitors = new WeakHashMap();
        debug_semaphores = new WeakHashMap();
        if (DEBUG) {
            Thread t = new Thread("AEMonSem:delay debug init"){

                @Override
                public void run() {
                    debug_recursions.add("ResourceDownloader");
                    debug_recursions.add("ConnectionPool:CP");
                    debug_recursions.add("(S)RDRretry");
                    try {
                        Thread.sleep(DEBUG_TIMER);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    TimerEventPerformer performer = new TimerEventPerformer(){
                        AEDiagnosticsLogger diag_logger;

                        @Override
                        public void perform(TimerEvent event) {
                            if (this.diag_logger == null) {
                                this.diag_logger = AEDiagnostics.getLogger("monsem");
                            }
                            AEMonSem.check(this.diag_logger);
                        }
                    };
                    performer.perform(null);
                    new Timer("AEMonSem").addPeriodicEvent(DEBUG_TIMER, performer);
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected static class monSemData {
        protected String class_name;
        protected int line_number;

        protected monSemData(String _class_name, int _line_number) {
            this.class_name = _class_name;
            this.line_number = _line_number;
        }
    }
}

