/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Date;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;

public class Debug {
    private static boolean STOP_AT_INITIALIZER = System.getProperty("debug.stacktrace.full", "0").equals("0");
    private static AEDiagnosticsLogger diag_logger;

    public static void out(String _debug_message) {
        Debug.out(_debug_message, null);
    }

    public static void out(Throwable _exception) {
        Debug.out("", _exception);
    }

    public static void outNoStack(String str) {
        Debug.outNoStack(str, false);
    }

    public static void outNoStack(String str, boolean stderr) {
        Debug.diagLoggerLogAndOut("DEBUG::" + new Date(SystemTime.getCurrentTime()).toString() + "  " + str, stderr);
    }

    public static void outDiagLoggerOnly(String str) {
        Debug.diagLoggerLog(str);
    }

    public static void out(String _debug_msg, Throwable _exception) {
        if (_exception instanceof ConnectException && _exception.getMessage().startsWith("No route to host")) {
            Debug.diagLoggerLog(_exception.toString());
            return;
        }
        if (_exception instanceof UnknownHostException) {
            Debug.diagLoggerLog(_exception.toString());
            return;
        }
        String header = "DEBUG::";
        header = header + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            StackTraceElement first_line = st[2];
            String className = first_line.getClassName() + "::";
            String methodName = first_line.getMethodName() + "::";
            int lineNumber = first_line.getLineNumber();
            trace_trace_tail = Debug.getCompressedStackTrace(e, 3, 200, false);
            Debug.diagLoggerLogAndOut(header + className + methodName + lineNumber + ":", true);
            if (_debug_msg.length() > 0) {
                Debug.diagLoggerLogAndOut("  " + _debug_msg, true);
            }
            if (trace_trace_tail != null) {
                Debug.diagLoggerLogAndOut("    " + trace_trace_tail, true);
            }
            if (_exception != null) {
                Debug.diagLoggerLogAndOut(_exception);
            }
            return;
        }
    }

    private static String getStackTrace(int endNumToSkip) {
        String sStackTrace = "";
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            for (int i = 1; i < st.length - endNumToSkip; ++i) {
                if (st[i].getMethodName().endsWith("StackTrace")) continue;
                sStackTrace = sStackTrace + st[i].toString() + "\n";
            }
            if (e.getCause() != null) {
                sStackTrace = sStackTrace + "\tCaused By: " + Debug.getStackTrace(e.getCause()) + "\n";
            }
            return sStackTrace;
        }
    }

    private static String getCompressedStackTrace(Throwable t, int frames_to_skip) {
        return Debug.getCompressedStackTrace(t, frames_to_skip, 200);
    }

    public static String getCompressedStackTrace(Throwable t, int frames_to_skip, int iMaxLines) {
        return Debug.getCompressedStackTrace(t, frames_to_skip, iMaxLines, true);
    }

    public static String getCompressedStackTrace(Throwable t, int frames_to_skip, int iMaxLines, boolean showErrString) {
        Throwable cause;
        StringBuffer sbStackTrace = new StringBuffer(showErrString ? t.toString() + "; " : "");
        StackTraceElement[] st = t.getStackTrace();
        if (iMaxLines < 0 && (iMaxLines = st.length + iMaxLines) < 0) {
            iMaxLines = 1;
        }
        int iMax = Math.min(st.length, iMaxLines + frames_to_skip);
        for (int i = frames_to_skip; i < iMax; ++i) {
            if (i > frames_to_skip) {
                sbStackTrace.append(", ");
            }
            String classname = st[i].getClassName();
            String cnShort = classname.substring(classname.lastIndexOf(".") + 1);
            if (Constants.IS_CVS_VERSION) {
                if (STOP_AT_INITIALIZER && st[i].getClassName().equals("com.aelitis.azureus.ui.swt.Initializer")) {
                    sbStackTrace.append("Initializer");
                    break;
                }
                sbStackTrace.append(st[i].getMethodName());
                sbStackTrace.append(" (");
                sbStackTrace.append(classname);
                sbStackTrace.append(".java:");
                sbStackTrace.append(st[i].getLineNumber());
                sbStackTrace.append(')');
                continue;
            }
            sbStackTrace.append(cnShort);
            sbStackTrace.append("::");
            sbStackTrace.append(st[i].getMethodName());
            sbStackTrace.append("::");
            sbStackTrace.append(st[i].getLineNumber());
        }
        if ((cause = t.getCause()) != null) {
            sbStackTrace.append("\n\tCaused By: ");
            sbStackTrace.append(Debug.getCompressedStackTrace(cause, 0));
        }
        return sbStackTrace.toString();
    }

    public static String getStackTrace(boolean bCompressed, boolean bIncludeSelf) {
        return Debug.getStackTrace(bCompressed, bIncludeSelf, bIncludeSelf ? 0 : 1, 200);
    }

    public static String getStackTrace(boolean bCompressed, boolean bIncludeSelf, int iNumLinesToSkip, int iMaxLines) {
        if (bCompressed) {
            return Debug.getCompressedStackTrace(bIncludeSelf ? 2 + iNumLinesToSkip : 3 + iNumLinesToSkip, iMaxLines);
        }
        return Debug.getStackTrace(1);
    }

    private static String getCompressedStackTrace(int frames_to_skip, int iMaxLines) {
        String trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            trace_trace_tail = Debug.getCompressedStackTrace(e, frames_to_skip, iMaxLines, false);
            return trace_trace_tail;
        }
    }

    public static String getNestedExceptionMessage(Throwable e) {
        String last_message = "";
        while (e != null) {
            String this_message = e instanceof UnknownHostException ? "Unknown host " + e.getMessage() : (e instanceof FileNotFoundException ? "File not found: " + e.getMessage() : e.getMessage());
            if (this_message == null) {
                this_message = e.getClass().getName();
                int pos = this_message.lastIndexOf(".");
                this_message = this_message.substring(pos + 1).trim();
            }
            if (this_message.length() > 0 && last_message.indexOf(this_message) == -1) {
                last_message = last_message + (last_message.length() == 0 ? "" : ", ") + this_message;
            }
            e = e.getCause();
        }
        return last_message;
    }

    public static String getCompressedStackTrace() {
        return Debug.getCompressedStackTrace(new Throwable(), 1, 200, false);
    }

    public static void printStackTrace(Throwable e) {
        Debug.printStackTrace(e, null);
    }

    public static void printStackTrace(Throwable e, Object context) {
        if (e instanceof ConnectException && e.getMessage().startsWith("No route to host")) {
            Debug.diagLoggerLog(e.toString());
            return;
        }
        if (e instanceof UnknownHostException) {
            Debug.diagLoggerLog(e.toString());
            return;
        }
        String header = "DEBUG::";
        header = header + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String className = "?::";
        String methodName = "?::";
        int lineNumber = -1;
        try {
            throw new Exception();
        }
        catch (Exception f) {
            StackTraceElement[] st = f.getStackTrace();
            for (int i = 1; i < st.length; ++i) {
                StackTraceElement first_line = st[i];
                className = first_line.getClassName() + "::";
                methodName = first_line.getMethodName() + "::";
                lineNumber = first_line.getLineNumber();
                if (className.indexOf(".logging.") == -1 && !className.endsWith(".Debug::")) break;
            }
            Debug.diagLoggerLogAndOut(header + className + methodName + lineNumber + ":", true);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
                if (context != null) {
                    pw.print("  ");
                    pw.println(context);
                }
                pw.print("  ");
                e.printStackTrace(pw);
                pw.close();
                String stack = baos.toString();
                Debug.diagLoggerLogAndOut(stack, true);
            }
            catch (Throwable ignore) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static String getStackTrace(Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            return baos.toString();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    private static void diagLoggerLog(String str) {
        if (diag_logger == null) {
            System.out.println(str);
        } else {
            diag_logger.log(str);
        }
    }

    private static void diagLoggerLogAndOut(String str, boolean stderr) {
        if (diag_logger == null) {
            if (stderr) {
                System.err.println(str);
            } else {
                System.out.println(str);
            }
        } else {
            diag_logger.logAndOut(str, stderr);
        }
    }

    private static void diagLoggerLogAndOut(Throwable e) {
        if (diag_logger == null) {
            e.printStackTrace();
        } else {
            diag_logger.logAndOut(e);
        }
    }

    static {
        try {
            diag_logger = AEDiagnostics.getLogger("debug");
            diag_logger.setForced(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

