/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ILogAlertListener;
import org.gudy.azureus2.core3.util.ILogEventListener;
import org.gudy.azureus2.core3.util.LogAlert;
import org.gudy.azureus2.core3.util.LogEvent;
import org.gudy.azureus2.core3.util.LogIDs;
import org.gudy.azureus2.core3.util.Logger;
import org.gudy.azureus2.core3.util.MessageText;

public class LoggerImpl {
    private static final int MAXHISTORY = 256;
    private static final boolean bLogToStdOut = System.getProperty("azureus.log.stdout") != null;
    private boolean bEventLoggingEnabled = false;
    private PrintStream psOldOut = null;
    private PrintStream psOldErr = null;
    private PrintStream psOut;
    private PrintStream psErr;
    private List logListeners = new ArrayList();
    private AEDiagnosticsLogger alertLogger;
    private List alertListeners = new ArrayList();
    private List alertHistory = new ArrayList();
    private boolean logToStdErrAllowed = true;

    public LoggerImpl() {
        this.doRedirects();
    }

    public void init() {
        boolean overrideLog;
        this.bEventLoggingEnabled = true;
        this.bEventLoggingEnabled = overrideLog = System.getProperty("azureus.overridelog") != null;
    }

    public void doRedirects() {
        try {
            if (System.out != this.psOut) {
                if (this.psOldOut == null) {
                    this.psOldOut = System.out;
                }
                this.psOut = new PrintStream(new RedirectorStream(this.psOldOut, LogIDs.STDOUT, 0));
                System.setOut(this.psOut);
            }
            if (System.err != this.psErr) {
                if (this.psOldErr == null) {
                    this.psOldErr = System.err;
                }
                this.psErr = new PrintStream(new RedirectorStream(this.psOldErr, LogIDs.STDERR, 3));
                System.setErr(this.psErr);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean isEnabled() {
        return this.bEventLoggingEnabled;
    }

    public void log(LogEvent event) {
        if (bLogToStdOut && this.psOldOut != null) {
            this.psOldOut.println(event.text);
        }
        if (event.entryType == 3) {
            if (AEDiagnostics.isStartupComplete()) {
                try {
                    Debug.outDiagLoggerOnly("[" + event.logID + "] " + event.text);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.logToStdErrAllowed && this.psOldErr != null && event.logID != LogIDs.STDERR) {
                this.psOldErr.println("[" + event.logID + "] " + event.text);
            }
        }
        if (this.bEventLoggingEnabled) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                try {
                    Object listener = this.logListeners.get(i);
                    if (!(listener instanceof ILogEventListener)) continue;
                    ((ILogEventListener)listener).log(event);
                    continue;
                }
                catch (Throwable e) {
                    if (!this.logToStdErrAllowed || this.psOldErr == null) continue;
                    this.psOldErr.println("Error while logging: " + e.getMessage());
                    e.printStackTrace(this.psOldErr);
                }
            }
        }
        if (event.err != null && event.entryType == 3) {
            Debug.printStackTrace(event.err);
        }
    }

    public void logTextResource(LogEvent event) {
        event.text = MessageText.getString(event.text);
        this.log(event);
    }

    public void logTextResource(LogEvent event, String[] params) {
        event.text = MessageText.getString(event.text, params);
        this.log(event);
    }

    public void addListener(ILogEventListener aListener) {
        this.logListeners.add(aListener);
    }

    public void removeListener(ILogEventListener aListener) {
        this.logListeners.remove(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogAlert alert2) {
        String logText = "Alert:" + alert2.entryType + ":" + alert2.text;
        LogEvent alertEvent = new LogEvent(LogIDs.ALERT, alert2.entryType, logText);
        alertEvent.err = alert2.err;
        Logger.log(alertEvent);
        LoggerImpl loggerImpl = this;
        synchronized (loggerImpl) {
            if (this.alertLogger == null) {
                this.alertLogger = AEDiagnostics.getLogger("alerts");
            }
        }
        Throwable error = alert2.getError();
        if (error != null) {
            logText = logText + " (" + Debug.getNestedExceptionMessage(error) + ")";
        }
        this.alertLogger.log(logText);
        this.alertHistory.add(alert2);
        if (this.alertHistory.size() > 256) {
            this.alertHistory.remove(0);
        }
        for (int i = 0; i < this.alertListeners.size(); ++i) {
            try {
                Object listener = this.alertListeners.get(i);
                if (!(listener instanceof ILogAlertListener)) continue;
                ((ILogAlertListener)listener).alertRaised(alert2);
                continue;
            }
            catch (Throwable f) {
                if (this.psOldErr == null) continue;
                this.psOldErr.println("Error while alerting: " + f.getMessage());
                f.printStackTrace(this.psOldErr);
            }
        }
    }

    public void logTextResource(LogAlert alert2) {
        alert2.text = MessageText.getString(alert2.text);
        this.log(alert2);
    }

    public void logTextResource(LogAlert alert2, String[] params) {
        alert2.text = MessageText.getString(alert2.text, params);
        this.log(alert2);
    }

    public void addListener(ILogAlertListener l) {
        this.alertListeners.add(l);
        for (int i = 0; i < this.alertHistory.size(); ++i) {
            LogAlert alert2 = (LogAlert)this.alertHistory.get(i);
            l.alertRaised(alert2);
        }
    }

    public void removeListener(ILogAlertListener l) {
        this.alertListeners.remove(l);
    }

    public PrintStream getOldStdErr() {
        return this.psOldErr;
    }

    public void allowLoggingToStdErr(boolean allowed) {
        this.logToStdErrAllowed = allowed;
    }

    private class RedirectorStream
    extends OutputStream {
        protected PrintStream ps;
        protected StringBuffer buffer = new StringBuffer(1024);
        protected LogIDs logID;
        protected int logType;

        protected RedirectorStream(PrintStream _ps, LogIDs _logID, int _logType) {
            this.ps = _ps;
            this.logType = _logType;
            this.logID = _logID;
        }

        @Override
        public void write(int data) {
            char c = (char)data;
            if (c == '\n') {
                if (!bLogToStdOut) {
                    this.ps.println(this.buffer);
                }
                LoggerImpl.this.log(new LogEvent(this.logID, this.logType, this.buffer.toString()));
                this.buffer.setLength(0);
            } else if (c != '\r') {
                this.buffer.append(c);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            for (int i = off; i < off + len; ++i) {
                int d = b[i];
                if (d < 0) {
                    d += 256;
                }
                this.write(d);
            }
        }
    }
}

