/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Subquery
extends Expression {
    private final Query query;
    private Expression expression;

    public Subquery(Query query) {
        this.query = query;
    }

    @Override
    public Value getValue(Session session2) {
        this.query.setSession(session2);
        try (LocalResult localResult = this.query.query(2);){
            Value[] valueArray;
            Object object;
            int n = localResult.getRowCount();
            if (n > 1) {
                throw DbException.get(90053);
            }
            if (n <= 0) {
                object = ValueNull.INSTANCE;
            } else {
                localResult.next();
                valueArray = localResult.currentRow();
                object = localResult.getVisibleColumnCount() == 1 ? valueArray[0] : ValueArray.get(valueArray);
            }
            valueArray = object;
            return valueArray;
        }
    }

    @Override
    public int getType() {
        return this.getExpression().getType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.query.mapColumns(columnResolver, n + 1);
    }

    @Override
    public Expression optimize(Session session2) {
        session2.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.query.setEvaluatable(tableFilter, bl);
    }

    @Override
    public int getScale() {
        return this.getExpression().getScale();
    }

    @Override
    public long getPrecision() {
        return this.getExpression().getPrecision();
    }

    @Override
    public int getDisplaySize() {
        return this.getExpression().getDisplaySize();
    }

    @Override
    public String getSQL() {
        return "(" + this.query.getPlanSQL() + ")";
    }

    @Override
    public void updateAggregate(Session session2) {
        this.query.updateAggregate(session2);
    }

    private Expression getExpression() {
        if (this.expression == null) {
            ArrayList<Expression> arrayList = this.query.getExpressions();
            int n = this.query.getColumnCount();
            if (n == 1) {
                this.expression = arrayList.get(0);
            } else {
                Expression[] expressionArray = new Expression[n];
                for (int i = 0; i < n; ++i) {
                    expressionArray[i] = arrayList.get(i);
                }
                this.expression = new ExpressionList(expressionArray);
            }
        }
        return this.expression;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.query.isEverything(expressionVisitor);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }

    @Override
    public Expression[] getExpressionColumns(Session session2) {
        return this.getExpression().getExpressionColumns(session2);
    }
}

