/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public class Variable
extends Expression {
    private final String name;
    private Value lastValue;

    public Variable(Session session2, String string) {
        this.name = string;
        this.lastValue = session2.getVariable(string);
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int getDisplaySize() {
        return this.lastValue.getDisplaySize();
    }

    @Override
    public long getPrecision() {
        return this.lastValue.getPrecision();
    }

    @Override
    public String getSQL() {
        return "@" + Parser.quoteIdentifier(this.name);
    }

    @Override
    public int getScale() {
        return this.lastValue.getScale();
    }

    @Override
    public int getType() {
        return this.lastValue.getType();
    }

    @Override
    public Value getValue(Session session2) {
        this.lastValue = session2.getVariable(this.name);
        return this.lastValue;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    @Override
    public Expression optimize(Session session2) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public void updateAggregate(Session session2) {
    }

    public String getName() {
        return this.name;
    }
}

