/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Iterator;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataLeaf;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;

class PageDataCursor
implements Cursor {
    private PageDataLeaf current;
    private int idx;
    private final long maxKey;
    private Row row;
    private final boolean multiVersion;
    private final Session session;
    private Iterator<Row> delta;

    PageDataCursor(Session session2, PageDataLeaf pageDataLeaf, int n, long l, boolean bl) {
        this.current = pageDataLeaf;
        this.idx = n;
        this.maxKey = l;
        this.multiVersion = bl;
        this.session = session2;
        if (bl) {
            this.delta = pageDataLeaf.index.getDelta();
        }
    }

    @Override
    public Row get() {
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        if (!this.multiVersion) {
            this.nextRow();
            return this.checkMax();
        }
        while (true) {
            if (this.delta != null) {
                if (!this.delta.hasNext()) {
                    this.delta = null;
                    this.row = null;
                    continue;
                }
                this.row = this.delta.next();
                if (this.row.isDeleted() && this.row.getSessionId() != this.session.getId()) break;
                continue;
            }
            this.nextRow();
            if (this.row == null || this.row.getSessionId() == 0 || this.row.getSessionId() == this.session.getId()) break;
        }
        return this.checkMax();
    }

    private boolean checkMax() {
        if (this.row != null) {
            long l;
            if (this.maxKey != Long.MAX_VALUE && (l = this.current.index.getKey(this.row, Long.MAX_VALUE, Long.MAX_VALUE)) > this.maxKey) {
                this.row = null;
                return false;
            }
            return true;
        }
        return false;
    }

    private void nextRow() {
        if (this.idx >= this.current.getEntryCount()) {
            this.current = this.current.getNextPage();
            this.idx = 0;
            if (this.current == null) {
                this.row = null;
                return;
            }
        }
        this.row = this.current.getRowAt(this.idx);
        ++this.idx;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError();
    }
}

