/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.db.MVDelegateIndex;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.mvstore.db.MVSecondaryIndex;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.mvstore.db.TransactionStore;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.util.DebuggingThreadLocal;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.DataType;

public class MVTable
extends TableBase {
    public static final DebuggingThreadLocal<String> WAITING_FOR_LOCK;
    public static final DebuggingThreadLocal<ArrayList<String>> EXCLUSIVE_LOCKS;
    public static final DebuggingThreadLocal<ArrayList<String>> SHARED_LOCKS;
    private MVPrimaryIndex primaryIndex;
    private final ArrayList<Index> indexes = New.arrayList();
    private long lastModificationId;
    private volatile Session lockExclusiveSession;
    private final ConcurrentHashMap<Session, Session> lockSharedSessions = new ConcurrentHashMap();
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private int changesSinceAnalyze;
    private int nextAnalyze;
    private boolean containsLargeObject;
    private Column rowIdColumn;
    private final MVTableEngine.Store store;
    private final TransactionStore transactionStore;

    public MVTable(CreateTableData createTableData, MVTableEngine.Store store) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.store = store;
        this.transactionStore = store.getTransactionStore();
        this.isHidden = createTableData.isHidden;
        for (Column column : this.getColumns()) {
            if (!DataType.isLargeObject(column.getType())) continue;
            this.containsLargeObject = true;
        }
        this.traceLock = this.database.getTrace(7);
    }

    void init(Session session2) {
        this.primaryIndex = new MVPrimaryIndex(session2.getDatabase(), this, this.getId(), IndexColumn.wrap(this.getColumns()), IndexType.createScan(true));
        this.indexes.add(this.primaryIndex);
    }

    public String getMapName() {
        return this.primaryIndex.getMapName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session2, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return false;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusiveSession == null) {
                return false;
            }
        }
        if (this.lockExclusiveSession == session2) {
            return true;
        }
        if (!bl && this.lockSharedSessions.containsKey(session2)) {
            return true;
        }
        Object object = this.getLockSyncObject();
        synchronized (object) {
            if (!bl && this.lockSharedSessions.containsKey(session2)) {
                return true;
            }
            session2.setWaitForLock(this, Thread.currentThread());
            if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                WAITING_FOR_LOCK.set(this.getName());
            }
            this.waitingSessions.addLast(session2);
            try {
                this.doLock1(session2, n, bl);
            }
            finally {
                session2.setWaitForLock(null, null);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    WAITING_FOR_LOCK.remove();
                }
                this.waitingSessions.remove(session2);
            }
        }
        return false;
    }

    private Object getLockSyncObject() {
        if (this.database.isMultiThreaded()) {
            return this;
        }
        return this.database;
    }

    private void doLock1(Session session2, int n, boolean bl) {
        this.traceLock(session2, bl, "requesting for");
        long l = 0L;
        boolean bl2 = false;
        while (this.waitingSessions.getFirst() != session2 || !this.doLock2(session2, n, bl)) {
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session2, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, MVTable.getDeadlockDetails(arrayList, bl));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.currentTimeMillis();
            if (l == 0L) {
                l = l2 + (long)session2.getLockTimeout();
            } else if (l2 >= l) {
                this.traceLock(session2, bl, "timeout after " + session2.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session2, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, l - l2)) == 0L) {
                    l3 = 1L;
                }
                this.getLockSyncObject().wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session2, int n, boolean bl) {
        if (bl) {
            if (this.lockExclusiveSession == null) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session2, bl, "added for");
                    session2.addLock(this);
                    this.lockExclusiveSession = session2;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session2)) {
                    this.traceLock(session2, bl, "add (upgraded) for ");
                    this.lockExclusiveSession = session2;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
            }
        } else if (this.lockExclusiveSession == null) {
            if (n == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                return true;
            }
            if (!this.lockSharedSessions.containsKey(session2)) {
                this.traceLock(session2, bl, "ok");
                session2.addLock(this);
                this.lockSharedSessions.put(session2, session2);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    if (SHARED_LOCKS.get() == null) {
                        SHARED_LOCKS.set(new ArrayList());
                    }
                    SHARED_LOCKS.get().add(this.getName());
                }
            }
            return true;
        }
        return false;
    }

    private static String getDeadlockDetails(ArrayList<Session> arrayList, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session2 : arrayList) {
            Table table = session2.getWaitForLock();
            Thread thread = session2.getWaitForLockThread();
            stringBuilder.append("\nSession ").append(session2.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(table.toString()).append(bl ? " (exclusive)" : " (shared)").append(" while locking ");
            int n = 0;
            for (Table table2 : session2.getLocks()) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof MVTable)) continue;
                if (((MVTable)table2).lockExclusiveSession == session2) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session2, Session session3, Set<Session> set) {
        Class<MVTable> clazz = MVTable.class;
        synchronized (MVTable.class) {
            Object object2;
            if (session3 == null) {
                session3 = session2;
                set = New.hashSet();
            } else {
                if (session3 == session2) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (set.contains(session2)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session2);
            ArrayList<Session> arrayList = null;
            for (Object object2 : this.lockSharedSessions.keySet()) {
                Table table;
                if (object2 == session2 || (table = ((Session)object2).getWaitForLock()) == null || (arrayList = table.checkDeadlock((Session)object2, session3, set)) == null) continue;
                arrayList.add(session2);
                break;
            }
            Session session4 = this.lockExclusiveSession;
            if (arrayList == null && session4 != null && (object2 = session4.getWaitForLock()) != null && (arrayList = ((Table)object2).checkDeadlock(session4, session3, set)) != null) {
                arrayList.add(session2);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayList;
        }
    }

    private void traceLock(Session session2, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session2.getId(), bl ? "exclusive write lock" : "shared read lock", string, this.getName());
        }
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusiveSession != null;
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session2) {
        return this.lockExclusiveSession == session2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session2) {
        if (this.database != null) {
            this.traceLock(session2, this.lockExclusiveSession == session2, "unlock");
            if (this.lockExclusiveSession == session2) {
                this.lockExclusiveSession = null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && EXCLUSIVE_LOCKS.get() != null) {
                    EXCLUSIVE_LOCKS.get().remove(this.getName());
                }
            }
            Object object = this.getLockSyncObject();
            synchronized (object) {
                if (this.lockSharedSessions.size() > 0) {
                    this.lockSharedSessions.remove(session2);
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR && SHARED_LOCKS.get() != null) {
                        SHARED_LOCKS.get().remove(this.getName());
                    }
                }
                if (!this.waitingSessions.isEmpty()) {
                    this.getLockSyncObject().notifyAll();
                }
            }
        }
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> arrayList;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (arrayList = this.getConstraints()) != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ConstraintReferential constraintReferential;
                Constraint constraint = arrayList.get(i);
                if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void close(Session session2) {
    }

    @Override
    public Row getRow(Session session2, long l) {
        return this.primaryIndex.getRow(session2, l);
    }

    @Override
    public Index addIndex(Session session2, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        BaseIndex baseIndex;
        boolean bl2;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session2);
        }
        int n2 = this.getMainIndexColumn(indexType, indexColumnArray);
        if (this.database.isStarting()) {
            if (this.transactionStore.store.hasMap("index." + n)) {
                n2 = -1;
            }
        } else if (this.primaryIndex.getRowCountMax() != 0L) {
            n2 = -1;
        }
        if (n2 != -1) {
            this.primaryIndex.setMainIndexColumn(n2);
            baseIndex = new MVDelegateIndex(this, n, string, this.primaryIndex, indexType);
        } else {
            baseIndex = indexType.isSpatial() ? new MVSpatialIndex(session2.getDatabase(), this, n, string, indexColumnArray, indexType) : new MVSecondaryIndex(session2.getDatabase(), this, n, string, indexColumnArray, indexType);
        }
        if (baseIndex.needRebuild()) {
            this.rebuildIndex(session2, (MVIndex)((Object)baseIndex), string);
        }
        baseIndex.setTemporary(this.isTemporary());
        if (baseIndex.getCreateSQL() != null) {
            baseIndex.setComment(string2);
            if (bl2) {
                session2.addLocalTempTableIndex(baseIndex);
            } else {
                this.database.addSchemaObject(session2, baseIndex);
            }
        }
        this.indexes.add(baseIndex);
        this.setModified();
        return baseIndex;
    }

    private void rebuildIndex(Session session2, MVIndex mVIndex, String string) {
        try {
            if (session2.getDatabase().getMvStore() == null || mVIndex instanceof MVSpatialIndex) {
                this.rebuildIndexBuffered(session2, mVIndex);
            } else {
                this.rebuildIndexBlockMerge(session2, mVIndex);
            }
        }
        catch (DbException dbException) {
            this.getSchema().freeUniqueName(string);
            try {
                mVIndex.remove(session2);
            }
            catch (DbException dbException2) {
                this.trace.error(dbException2, "could not remove index");
                throw dbException2;
            }
            throw dbException;
        }
    }

    private void rebuildIndexBlockMerge(Session session2, MVIndex mVIndex) {
        Object object;
        long l;
        if (mVIndex instanceof MVSpatialIndex) {
            this.rebuildIndexBuffered(session2, mVIndex);
        }
        Index index = this.getScanIndex(session2);
        long l2 = l = index.getRowCount(session2);
        Cursor cursor = index.find(session2, null, null);
        long l3 = 0L;
        MVTableEngine.Store store = session2.getDatabase().getMvStore();
        int n = this.database.getMaxMemoryRows() / 2;
        ArrayList<Row> arrayList = New.arrayList(n);
        String string = this.getName() + ":" + mVIndex.getName();
        int n2 = MathUtils.convertLongToInt(l2);
        ArrayList<String> arrayList2 = New.arrayList();
        while (cursor.next()) {
            object = cursor.get();
            arrayList.add((Row)object);
            this.database.setProgress(1, string, MathUtils.convertLongToInt(l3++), n2);
            if (arrayList.size() >= n) {
                MVTable.sortRows(arrayList, mVIndex);
                String string2 = store.nextTemporaryMapName();
                mVIndex.addRowsToBuffer(arrayList, string2);
                arrayList2.add(string2);
                arrayList.clear();
            }
            --l;
        }
        MVTable.sortRows(arrayList, mVIndex);
        if (arrayList2.size() > 0) {
            object = store.nextTemporaryMapName();
            mVIndex.addRowsToBuffer(arrayList, (String)object);
            arrayList2.add((String)object);
            arrayList.clear();
            mVIndex.addBufferedRows(arrayList2);
        } else {
            MVTable.addRowsToIndex(session2, arrayList, mVIndex);
        }
        if (SysProperties.CHECK && l != 0L) {
            DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
        }
    }

    private void rebuildIndexBuffered(Session session2, Index index) {
        long l;
        Index index2 = this.getScanIndex(session2);
        long l2 = l = index2.getRowCount(session2);
        Cursor cursor = index2.find(session2, null, null);
        long l3 = 0L;
        int n = (int)Math.min(l2, (long)this.database.getMaxMemoryRows());
        ArrayList<Row> arrayList = New.arrayList(n);
        String string = this.getName() + ":" + index.getName();
        int n2 = MathUtils.convertLongToInt(l2);
        while (cursor.next()) {
            Row row = cursor.get();
            arrayList.add(row);
            this.database.setProgress(1, string, MathUtils.convertLongToInt(l3++), n2);
            if (arrayList.size() >= n) {
                MVTable.addRowsToIndex(session2, arrayList, index);
            }
            --l;
        }
        MVTable.addRowsToIndex(session2, arrayList, index);
        if (SysProperties.CHECK && l != 0L) {
            DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
        }
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.primaryIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    private static void addRowsToIndex(Session session2, ArrayList<Row> arrayList, Index index) {
        MVTable.sortRows(arrayList, index);
        for (Row row : arrayList) {
            index.add(session2, row);
        }
        arrayList.clear();
    }

    private static void sortRows(ArrayList<Row> arrayList, final Index index) {
        Collections.sort(arrayList, new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return index.compareRows(row, row2);
            }
        });
    }

    @Override
    public void removeRow(Session session2, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        TransactionStore.Transaction transaction = this.getTransaction(session2);
        long l = transaction.setSavepoint();
        try {
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session2, row);
            }
        }
        catch (Throwable throwable) {
            transaction.rollbackToSavepoint(l);
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session2);
    }

    @Override
    public void truncate(Session session2) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session2);
        }
        this.changesSinceAnalyze = 0;
    }

    @Override
    public void addRow(Session session2, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        TransactionStore.Transaction transaction = this.getTransaction(session2);
        long l = transaction.setSavepoint();
        try {
            int n = this.indexes.size();
            for (int i = 0; i < n; ++i) {
                Index index = this.indexes.get(i);
                index.add(session2, row);
            }
        }
        catch (Throwable throwable) {
            transaction.rollbackToSavepoint(l);
            DbException dbException = DbException.convert(throwable);
            if (dbException.getErrorCode() == 23505) {
                for (int i = 0; i < this.indexes.size(); ++i) {
                    MultiVersionIndex multiVersionIndex;
                    Index index = this.indexes.get(i);
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(multiVersionIndex = (MultiVersionIndex)index).isUncommittedFromOtherSession(session2, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw dbException;
        }
        this.analyzeIfRequired(session2);
    }

    private void analyzeIfRequired(Session session2) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        int n2 = session2.getDatabase().getSettings().analyzeSample / 10;
        Analyze.analyzeTable(session2, this, n2, false);
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    @Override
    public Index getScanIndex(Session session2) {
        return this.primaryIndex;
    }

    @Override
    public Index getUniqueIndex() {
        return this.primaryIndex;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public void removeChildrenAndResources(Session session2) {
        if (this.containsLargeObject) {
            this.truncate(session2);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session2);
        }
        this.database.getMvStore().removeTable(this);
        super.removeChildrenAndResources(session2);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session2, index);
            }
            this.indexes.remove(index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.primaryIndex.remove(session2);
        this.database.removeMeta(session2, this.getId());
        this.close(session2);
        this.invalidate();
    }

    @Override
    public long getRowCount(Session session2) {
        return this.primaryIndex.getRowCount(session2);
    }

    @Override
    public long getRowCountApproximation() {
        return this.primaryIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.primaryIndex.getDiskSpaceUsed();
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.Transaction getTransaction(Session session2) {
        if (session2 == null) {
            return this.transactionStore.begin();
        }
        return session2.getTransaction();
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
        }
        return this.rowIdColumn;
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public boolean isMVStore() {
        return true;
    }

    public void commit() {
        if (this.database != null) {
            this.lastModificationId = this.database.getNextModificationDataId();
        }
    }

    DbException convertException(IllegalStateException illegalStateException) {
        if (DataUtils.getErrorCode(illegalStateException.getMessage()) == 101) {
            throw DbException.get(90131, illegalStateException, this.getName());
        }
        return this.store.convertIllegalStateException(illegalStateException);
    }

    static {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            WAITING_FOR_LOCK = new DebuggingThreadLocal();
            EXCLUSIVE_LOCKS = new DebuggingThreadLocal();
            SHARED_LOCKS = new DebuggingThreadLocal();
        } else {
            WAITING_FOR_LOCK = null;
            EXCLUSIVE_LOCKS = null;
            SHARED_LOCKS = null;
        }
    }
}

