/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.FunctionCall;
import org.h2.expression.TableFunction;
import org.h2.index.FunctionIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class FunctionTable
extends Table {
    private final FunctionCall function;
    private final long rowCount;
    private Expression functionExpr;
    private LocalResult cachedResult;
    private Value cachedValue;

    public FunctionTable(Schema schema, Session session2, Expression expression, FunctionCall functionCall) {
        super(schema, 0, functionCall.getName(), false, true);
        this.functionExpr = expression;
        this.function = functionCall;
        this.rowCount = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session2);
        int n = functionCall.getType();
        if (n != 18) {
            throw DbException.get(90000, functionCall.getName());
        }
        Expression[] expressionArray = functionCall.getArgs();
        int n2 = expressionArray.length;
        Expression[] expressionArray2 = new Expression[n2];
        for (int i = 0; i < n2; ++i) {
            expressionArray[i] = expressionArray[i].optimize(session2);
            expressionArray2[i] = expressionArray[i];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session2, expressionArray2);
        if (valueResultSet == null) {
            throw DbException.get(90000, functionCall.getName());
        }
        ResultSet resultSet = valueResultSet.getResultSet();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            Column[] columnArray = new Column[n3];
            for (int i = 0; i < n3; ++i) {
                columnArray[i] = new Column(resultSetMetaData.getColumnName(i + 1), DataType.getValueTypeFromResultSet(resultSetMetaData, i + 1), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1), resultSetMetaData.getColumnDisplaySize(i + 1));
            }
            this.setColumns(columnArray);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    public boolean lock(Session session2, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void close(Session session2) {
    }

    @Override
    public void unlock(Session session2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session2, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void removeRow(Session session2, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void truncate(Session session2) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean canDrop() {
        throw DbException.throwInternalError();
    }

    @Override
    public void addRow(Session session2, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public String getTableType() {
        return null;
    }

    @Override
    public Index getScanIndex(Session session2) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session session2) {
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public ResultInterface getResult(Session session2) {
        ValueResultSet valueResultSet = this.getValueResultSet(session2);
        if (valueResultSet == null) {
            return null;
        }
        if (this.cachedResult != null && this.cachedValue == valueResultSet) {
            this.cachedResult.reset();
            return this.cachedResult;
        }
        LocalResult localResult = LocalResult.read(session2, valueResultSet.getResultSet(), 0);
        if (this.function.isDeterministic()) {
            this.cachedResult = localResult;
            this.cachedValue = valueResultSet;
        }
        return localResult;
    }

    public ResultSet getResultSet(Session session2) {
        ValueResultSet valueResultSet = this.getValueResultSet(session2);
        return valueResultSet == null ? null : valueResultSet.getResultSet();
    }

    private ValueResultSet getValueResultSet(Session session2) {
        this.functionExpr = this.functionExpr.optimize(session2);
        Value value = this.functionExpr.getValue(session2);
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        return (ValueResultSet)value;
    }

    public boolean isBufferResultSetToLocalTemp() {
        return this.function.isBufferResultSetToLocalTemp();
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public String getSQL() {
        return this.function.getSQL();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

