/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.NonUniqueHashIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDelegateIndex;
import org.h2.index.ScanIndex;
import org.h2.index.SpatialTreeIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.DataType;

public class RegularTable
extends TableBase {
    private Index scanIndex;
    private long rowCount;
    private volatile Session lockExclusiveSession;
    private HashSet<Session> lockSharedSessions = New.hashSet();
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final ArrayList<Index> indexes = New.arrayList();
    private long lastModificationId;
    private boolean containsLargeObject;
    private final PageDataIndex mainIndex;
    private int changesSinceAnalyze;
    private int nextAnalyze;
    private Column rowIdColumn;

    public RegularTable(CreateTableData createTableData) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.isHidden = createTableData.isHidden;
        for (Column column : this.getColumns()) {
            if (!DataType.isLargeObject(column.getType())) continue;
            this.containsLargeObject = true;
        }
        if (createTableData.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData), createTableData.create, createTableData.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.mainIndex = null;
            this.scanIndex = new ScanIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData));
        }
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace(7);
    }

    @Override
    public void close(Session session2) {
        for (Index index : this.indexes) {
            index.close(session2);
        }
    }

    @Override
    public Row getRow(Session session2, long l) {
        return this.scanIndex.getRow(session2, l);
    }

    @Override
    public void addRow(Session session2, Row row) {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session2.getId());
        }
        try {
            int n2 = this.indexes.size();
            for (n = 0; n < n2; ++n) {
                Index index = this.indexes.get(n);
                index.add(session2, row);
                this.checkRowCount(session2, index, 1);
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            Object object;
            try {
                while (--n >= 0) {
                    object = this.indexes.get(n);
                    object.remove(session2, row);
                    this.checkRowCount(session2, (Index)object, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            object = DbException.convert(throwable);
            if (((DbException)object).getErrorCode() == 23505) {
                for (int i = 0; i < this.indexes.size(); ++i) {
                    MultiVersionIndex multiVersionIndex;
                    Index index = this.indexes.get(i);
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(multiVersionIndex = (MultiVersionIndex)index).isUncommittedFromOtherSession(session2, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw object;
        }
        this.analyzeIfRequired(session2);
    }

    @Override
    public void commit(short s, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        int n = this.indexes.size();
        for (int i = 0; i < n; ++i) {
            Index index = this.indexes.get(i);
            index.commit(s, row);
        }
    }

    private void checkRowCount(Session session2, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && !(index instanceof PageDelegateIndex) && (l = index.getRowCount(session2)) != this.rowCount + (long)n) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session2) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session2, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        Index index;
        boolean bl2;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session2);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int n2 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session2) != 0L ? -1 : this.getMainIndexColumn(indexType, indexColumnArray));
            if (n2 != -1) {
                this.mainIndex.setMainIndexColumn(n2);
                index = new PageDelegateIndex(this, n, string, indexType, this.mainIndex, bl, session2);
            } else {
                index = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string, indexColumnArray, indexType, true, bl, session2) : new PageBtreeIndex(this, n, string, indexColumnArray, indexType, bl, session2);
            }
        } else if (indexType.isHash()) {
            if (indexColumnArray.length != 1) {
                throw DbException.getUnsupportedException("hash indexes may index only one column");
            }
            index = indexType.isUnique() ? new HashIndex(this, n, string, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n, string, indexColumnArray, indexType);
        } else {
            index = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string, indexColumnArray, indexType, false, true, session2) : new TreeIndex(this, n, string, indexColumnArray, indexType);
        }
        if (this.database.isMultiVersion()) {
            index = new MultiVersionIndex(index, this);
        }
        if (index.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                Index index2 = this.getScanIndex(session2);
                long l2 = l = index2.getRowCount(session2);
                Cursor cursor = index2.find(session2, null, null);
                long l3 = 0L;
                int n3 = (int)Math.min(this.rowCount, (long)this.database.getMaxMemoryRows());
                ArrayList<Row> arrayList = New.arrayList(n3);
                String string3 = this.getName() + ":" + index.getName();
                int n4 = MathUtils.convertLongToInt(l2);
                while (cursor.next()) {
                    this.database.setProgress(1, string3, MathUtils.convertLongToInt(l3++), n4);
                    Row row = cursor.get();
                    arrayList.add(row);
                    if (arrayList.size() >= n3) {
                        RegularTable.addRowsToIndex(session2, arrayList, index);
                    }
                    --l;
                }
                RegularTable.addRowsToIndex(session2, arrayList, index);
                if (SysProperties.CHECK && l != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (DbException dbException) {
                this.getSchema().freeUniqueName(string);
                try {
                    index.remove(session2);
                }
                catch (DbException dbException2) {
                    this.trace.error(dbException2, "could not remove index");
                    throw dbException2;
                }
                throw dbException;
            }
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(string2);
            if (bl2) {
                session2.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session2, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.mainIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    private static void addRowsToIndex(Session session2, ArrayList<Row> arrayList, Index index) {
        final Index index2 = index;
        Collections.sort(arrayList, new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return index2.compareRows(row, row2);
            }
        });
        for (Row row : arrayList) {
            index.add(session2, row);
        }
        arrayList.clear();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session session2) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session2).getRowCount(session2);
        }
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session2, Row row) {
        int n;
        if (this.database.isMultiVersion()) {
            if (row.isDeleted()) {
                throw DbException.get(90131, this.getName());
            }
            n = row.getSessionId();
            int n2 = session2.getId();
            if (n == 0) {
                row.setSessionId(n2);
            } else if (n != n2) {
                throw DbException.get(90131, this.getName());
            }
        }
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = this.indexes.get(n);
                index.remove(session2, row);
                this.checkRowCount(session2, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (++n < this.indexes.size()) {
                    Index index = this.indexes.get(n);
                    index.add(session2, row);
                    this.checkRowCount(session2, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session2);
    }

    @Override
    public void truncate(Session session2) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session2);
        }
        this.rowCount = 0L;
        this.changesSinceAnalyze = 0;
    }

    private void analyzeIfRequired(Session session2) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        int n2 = session2.getDatabase().getSettings().analyzeSample / 10;
        Analyze.analyzeTable(session2, this, n2, false);
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session2) {
        return this.lockExclusiveSession == session2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session2, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return this.lockExclusiveSession != null;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusiveSession == null) {
                return false;
            }
        }
        if (this.lockExclusiveSession == session2) {
            return true;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.lockExclusiveSession == session2) {
                return true;
            }
            if (!bl && this.lockSharedSessions.contains(session2)) {
                return true;
            }
            session2.setWaitForLock(this, Thread.currentThread());
            this.waitingSessions.addLast(session2);
            try {
                this.doLock1(session2, n, bl);
            }
            finally {
                session2.setWaitForLock(null, null);
                this.waitingSessions.remove(session2);
            }
        }
        return false;
    }

    private void doLock1(Session session2, int n, boolean bl) {
        this.traceLock(session2, bl, "requesting for");
        long l = 0L;
        boolean bl2 = false;
        while (this.waitingSessions.getFirst() != session2 || !this.doLock2(session2, n, bl)) {
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session2, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, RegularTable.getDeadlockDetails(arrayList, bl));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.currentTimeMillis();
            if (l == 0L) {
                l = l2 + (long)session2.getLockTimeout();
            } else if (l2 >= l) {
                this.traceLock(session2, bl, "timeout after " + session2.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session2, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, l - l2)) == 0L) {
                    l3 = 1L;
                }
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session2, int n, boolean bl) {
        if (bl) {
            if (this.lockExclusiveSession == null) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session2, bl, "added for");
                    session2.addLock(this);
                    this.lockExclusiveSession = session2;
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.contains(session2)) {
                    this.traceLock(session2, bl, "add (upgraded) for ");
                    this.lockExclusiveSession = session2;
                    return true;
                }
            }
        } else if (this.lockExclusiveSession == null) {
            if (n == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                return true;
            }
            if (!this.lockSharedSessions.contains(session2)) {
                this.traceLock(session2, bl, "ok");
                session2.addLock(this);
                this.lockSharedSessions.add(session2);
            }
            return true;
        }
        return false;
    }

    private static String getDeadlockDetails(ArrayList<Session> arrayList, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session2 : arrayList) {
            Table table = session2.getWaitForLock();
            Thread thread = session2.getWaitForLockThread();
            stringBuilder.append("\nSession ").append(session2.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(table.toString()).append(bl ? " (exclusive)" : " (shared)").append(" while locking ");
            int n = 0;
            for (Table table2 : session2.getLocks()) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof RegularTable)) continue;
                if (((RegularTable)table2).lockExclusiveSession == session2) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session2, Session session3, Set<Session> set) {
        Class<RegularTable> clazz = RegularTable.class;
        synchronized (RegularTable.class) {
            if (session3 == null) {
                session3 = session2;
                set = New.hashSet();
            } else {
                if (session3 == session2) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (set.contains(session2)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session2);
            ArrayList<Session> arrayList = null;
            Object object = this.lockSharedSessions.iterator();
            while (object.hasNext()) {
                Table table;
                Session session4 = object.next();
                if (session4 == session2 || (table = session4.getWaitForLock()) == null || (arrayList = table.checkDeadlock(session4, session3, set)) == null) continue;
                arrayList.add(session2);
                break;
            }
            if (arrayList == null && this.lockExclusiveSession != null && (object = this.lockExclusiveSession.getWaitForLock()) != null && (arrayList = ((Table)object).checkDeadlock(this.lockExclusiveSession, session3, set)) != null) {
                arrayList.add(session2);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayList;
        }
    }

    private void traceLock(Session session2, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session2.getId(), bl ? "exclusive write lock" : "shared read lock", string, this.getName());
        }
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusiveSession != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session2) {
        if (this.database != null) {
            this.traceLock(session2, this.lockExclusiveSession == session2, "unlock");
            if (this.lockExclusiveSession == session2) {
                this.lockExclusiveSession = null;
            }
            Database database = this.database;
            synchronized (database) {
                if (this.lockSharedSessions.size() > 0) {
                    this.lockSharedSessions.remove(session2);
                }
                if (!this.waitingSessions.isEmpty()) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public void setRowCount(long l) {
        this.rowCount = l;
    }

    @Override
    public void removeChildrenAndResources(Session session2) {
        if (this.containsLargeObject) {
            this.truncate(session2);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session2);
        }
        super.removeChildrenAndResources(session2);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session2, index);
            }
            this.indexes.remove(index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session2);
        this.database.removeMeta(session2, this.getId());
        this.scanIndex = null;
        this.lockExclusiveSession = null;
        this.lockSharedSessions = null;
        this.invalidate();
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> arrayList;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (arrayList = this.getConstraints()) != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ConstraintReferential constraintReferential;
                Constraint constraint = arrayList.get(i);
                if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.scanIndex.getDiskSpaceUsed();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
        }
        return this.rowIdColumn;
    }
}

