/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FixedsizeForgetfulHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -519304540549432803L;
    private final int MAXIMUM_SIZE;

    public FixedsizeForgetfulHashMap(int size) {
        this(size, size * 4 / 3 + 10, 0.75f);
    }

    public FixedsizeForgetfulHashMap(int size, int initialCapacity) {
        this(size, initialCapacity, 0.75f);
    }

    public FixedsizeForgetfulHashMap(int size, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        if (size < 1) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.MAXIMUM_SIZE = size;
    }

    public boolean isFull() {
        return this.size() >= this.MAXIMUM_SIZE;
    }

    public Map.Entry<K, V> removeLRUEntry() {
        if (this.isEmpty()) {
            return null;
        }
        Iterator i = this.entrySet().iterator();
        Map.Entry value = i.next();
        i.remove();
        return value;
    }

    @Override
    public FixedsizeForgetfulHashMap<K, V> clone() {
        return (FixedsizeForgetfulHashMap)super.clone();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.MAXIMUM_SIZE;
    }

    @Override
    public V put(K key, V value) {
        V ret = null;
        if (this.containsKey(key)) {
            ret = this.remove(key);
        }
        super.put(key, value);
        return ret;
    }
}

