/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static byte[] getBytes(SocketAddress addr) throws UnknownHostException {
        InetSocketAddress iaddr = (InetSocketAddress)addr;
        if (iaddr.isUnresolved()) {
            throw new UnknownHostException(iaddr.toString());
        }
        return NetworkUtils.getBytes(iaddr.getAddress(), iaddr.getPort());
    }

    public static byte[] getBytes(InetAddress addr, int port) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        byte[] address2 = addr.getAddress();
        byte[] dst = new byte[address2.length + 2];
        System.arraycopy(address2, 0, dst, 0, address2.length);
        dst[dst.length - 2] = (byte)(port >> 8 & 0xFF);
        dst[dst.length - 1] = (byte)(port & 0xFF);
        return dst;
    }
}

