/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Locale;
import org.limewire.util.UnameReader;

public class OSUtils {
    private static boolean _isWindows;
    private static boolean _isWindowsNT;
    private static boolean _isWindowsXP;
    private static boolean _isWindows95;
    private static boolean _isWindows98;
    private static boolean _isWindowsMe;
    private static boolean _isWindowsVista;
    private static boolean _isWindows7;
    private static boolean _isWindows8;
    private static boolean _isWindows10;
    private static boolean _supportsTray;
    private static boolean _isMacOSX;
    private static boolean _isMacOSX105;
    private static boolean _isMacOSX106;
    private static boolean _isMacOSX107;
    private static boolean _isLinux;
    private static boolean _isUbuntu;
    private static boolean _isFedora;
    private static boolean _isSolaris;
    private static boolean _isOS2;

    public static void setOperatingSystems() {
        _isWindows = false;
        _isWindows8 = false;
        _isWindows7 = false;
        _isWindowsVista = false;
        _isWindowsXP = false;
        _isWindowsMe = false;
        _isWindowsNT = false;
        _isWindows98 = false;
        _isWindows95 = false;
        _isLinux = false;
        _isUbuntu = false;
        _isFedora = false;
        _isMacOSX = false;
        _isMacOSX105 = false;
        _isMacOSX106 = false;
        _isSolaris = false;
        _isOS2 = false;
        String os = System.getProperty("os.name");
        System.out.println("os.name=\"" + os + "\"");
        os = os.toLowerCase(Locale.US);
        _isWindows = os.indexOf("windows") != -1;
        _isSolaris = os.indexOf("solaris") != -1;
        _isLinux = os.indexOf("linux") != -1;
        boolean bl = _isOS2 = os.indexOf("os/2") != -1;
        if (_isWindows) {
            _isWindows10 = os.indexOf("windows 10") != -1;
            _isWindows8 = os.indexOf("windows 8") != -1;
            _isWindows7 = os.indexOf("windows 7") != -1;
            _isWindowsVista = os.indexOf("windows vista") != -1;
            _isWindowsXP = os.indexOf("windows xp") != -1;
            _isWindowsNT = os.indexOf("windows nt") != -1;
            _isWindowsMe = os.indexOf("windows me") != -1;
            _isWindows98 = os.indexOf("windows 98") != -1;
            boolean bl2 = _isWindows95 = os.indexOf("windows 95") != -1;
        }
        if (_isLinux) {
            String unameStr = UnameReader.read();
            _isUbuntu = unameStr.contains("buntu") || unameStr.contains("ebian");
            boolean bl3 = _isFedora = unameStr.contains("edora") || unameStr.contains("ed Hat");
        }
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (os.startsWith("mac os") && os.endsWith("x")) {
            _isMacOSX = true;
            _isMacOSX105 = System.getProperty("os.version").startsWith("10.5");
            _isMacOSX106 = System.getProperty("os.version").startsWith("10.6");
            _isMacOSX107 = System.getProperty("os.version").startsWith("10.7");
        }
    }

    public static String getOS() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getFullOS() {
        return OSUtils.getOS() + "-" + OSUtils.getOSVersion() + "-" + OSUtils.getArchitecture();
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsNT() {
        return _isWindowsNT;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindowsMe() {
        return _isWindowsMe;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isWindows7() {
        return _isWindows7;
    }

    public static boolean isWindows8() {
        return _isWindows8;
    }

    public static boolean isWindows10() {
        return _isWindows10;
    }

    public static boolean isNativeThemeWindows() {
        return OSUtils.isWindowsVista() || OSUtils.isWindowsXP();
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isMacOSX105() {
        return _isMacOSX105;
    }

    public static boolean isMacOSX106() {
        return _isMacOSX106;
    }

    public static boolean isMacOSX107() {
        return _isMacOSX107;
    }

    public static boolean isAnyMac() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUbuntu() {
        return _isUbuntu;
    }

    public static boolean isFedora() {
        return _isFedora;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isHighLoadOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isGoodWindows() {
        return OSUtils.isWindows() && OSUtils.isHighLoadOS();
    }

    public static boolean isModernWindows() {
        return OSUtils.isWindows() && !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT && !_isWindowsXP;
    }

    public static boolean supportsTrash() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    public static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    public static boolean isMachineX64() {
        String value = System.getProperty("sun.arch.data.model");
        return value != null && value.equals("64");
    }

    static {
        OSUtils.setOperatingSystems();
    }
}

