This document explains how to analyze core-dumps obtained from regression
machines, with examples.  
1) Download the core-tarball and extract it.  
2) 'cd' into the root of extracted tarball.
~~~
[root@atalur Downloads]# pwd
/home/atalur/Downloads
[root@atalur Downloads]# ls
build  build-install-20150625_05_42_39.tar.bz2  lib64  usr
~~~
3) Determine the core file you need to examine. There can be more than one core file.  
You can list them from './build/install/cores' directory.
~~~
[root@atalur Downloads]# ls build/install/cores/
core.9341  liblist.txt  liblist.txt.tmp
~~~
In case you are unsure which binary generated the core-file, executing 'file' command on it will help.
~~~
[root@atalur Downloads]# file ./build/install/cores/core.9341 
./build/install/cores/core.9341: ELF 64-bit LSB core file x86-64, version 1 (SYSV), SVR4-style, from '/build/install/sbin/glusterfsd -s slave26.cloud.gluster.org --volfile-id patchy'
~~~
As seen, the core file was generated by glusterfsd binary, and path to it is provide (/build/install/sbin/glusterfsd).  
4) Now, run the following command on the core:
~~~
gdb -ex 'set sysroot ./' -ex 'core-file ./build/install/cores/core.xxx' <target, say ./build/install/sbin/glusterd>
In this case,
gdb -ex 'set sysroot ./' -ex 'core-file ./build/install/cores/core.9341' ./build/install/sbin/glusterfsd
~~~
5) You can cross check if all shared libraries are available and loaded by using 'info sharedlibrary' command from
inside gdb.  
6) Once verified, usual gdb commands based on requirement can be used to debug the core.
