# Release notes for Gluster 3.12.3

This is a bugfix release. The release notes for [3.12.0](3.12.0.md), [3.12.1](3.12.1.md),
[3.12.2](3.12.2.md), [3.12.3](3.12.3.md) contain a listing of all the new features that
were added and bugs fixed in the GlusterFS 3.12 stable release.

## Major changes, features and limitations addressed in this release
1. The two regression related to with subdir mount got fixed
        - gluster volume restart failure (#1465123)
        - mounting gluster snapshot via fuse (#1501378)

2. Improvements for "help" command with in gluster cli (#1509786)

3. Introduction of new api glfs_fd_set_lkowner() to set lock owner


## Major issues
1. Expanding a gluster volume that is sharded may cause file corruption
    - Sharded volumes are typically used for VM images, if such volumes are
  expanded or possibly contracted (i.e add/remove bricks and rebalance) there
  are reports of VM images getting corrupted.
    - The last known cause for corruption #1465123 is still pending, and not yet
    part of this release.

## Bugs addressed

     A total of 25 patches have been merged, addressing 25 bugs

- [#1484489](https://bugzilla.redhat.com/1484489): File-level WORM allows mv over read-only files
- [#1494527](https://bugzilla.redhat.com/1494527): glusterfs fails to build twice in a row
- [#1499889](https://bugzilla.redhat.com/1499889): md-cache uses incorrect xattr keynames for GF_POSIX_ACL keys
- [#1499892](https://bugzilla.redhat.com/1499892): md-cache: xattr values should not be checked with string functions
- [#1501238](https://bugzilla.redhat.com/1501238): [SNAPSHOT] Unable to mount a snapshot on client
- [#1501315](https://bugzilla.redhat.com/1501315): Gluster Volume restart fail after exporting fuse sub-dir
- [#1501864](https://bugzilla.redhat.com/1501864): Add generated HMAC token in header for webhook calls
- [#1501956](https://bugzilla.redhat.com/1501956): gfapi: API needed to set lk_owner
- [#1502104](https://bugzilla.redhat.com/1502104): [geo-rep]: RSYNC throwing internal errors
- [#1503239](https://bugzilla.redhat.com/1503239): [Glusterd] Volume operations fail on a (tiered) volume because of a stale lock held by one of the nodes
- [#1505221](https://bugzilla.redhat.com/1505221): glusterfs client crash when removing directories
- [#1505323](https://bugzilla.redhat.com/1505323): When sub-dir is mounted on Fuse client,adding bricks to the same volume unmounts the subdir from fuse client
- [#1505370](https://bugzilla.redhat.com/1505370): Mishandling null check at send_brick_req of glusterfsd/src/gf_attach.c
- [#1505373](https://bugzilla.redhat.com/1505373): server.allow-insecure should be visible in "gluster volume set help"
- [#1505527](https://bugzilla.redhat.com/1505527): Posix compliance rename test fails on fuse subdir mount
- [#1505846](https://bugzilla.redhat.com/1505846): [GSS] gluster volume status command is missing in man page
- [#1505856](https://bugzilla.redhat.com/1505856): Potential use of NULL `this` variable before it gets initialized
- [#1507747](https://bugzilla.redhat.com/1507747): clean up port map on brick disconnect
- [#1507748](https://bugzilla.redhat.com/1507748): Brick port mismatch
- [#1507877](https://bugzilla.redhat.com/1507877): reset-brick commit force failed with glusterd_volume_brickinfo_get Returning -1
- [#1508283](https://bugzilla.redhat.com/1508283): stale brick processes getting created and volume status shows brick as down(pkill glusterfsd glusterfs ,glusterd restart)
- [#1509200](https://bugzilla.redhat.com/1509200): Event webhook should work with HTTPS urls
- [#1509786](https://bugzilla.redhat.com/1509786): The output of the "gluster help" command is difficult to read
- [#1511271](https://bugzilla.redhat.com/1511271): Rebalance estimate(ETA) shows wrong details(as intial message of 10min wait reappears) when still in progress
- [#1511301](https://bugzilla.redhat.com/1511301): In distribute volume after glusterd restart, brick goes offline
