#!/bin/sh
export PATH='/chakra/bin:/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.3
id: HTTP-4000.3.3-81wlCO2OtSq8qX4gk8VIro
key: 81wlCO2OtSq8qX4gk8VIro
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
exposed-modules:
    Network.BufferType Network.Stream Network.StreamDebugger
    Network.StreamSocket Network.TCP Network.HTTP Network.HTTP.Headers
    Network.HTTP.Base Network.HTTP.Stream Network.HTTP.Auth
    Network.HTTP.Cookie Network.HTTP.Proxy Network.HTTP.HandleStream
    Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
abi: 297ff6741d2781b988b2c2c0567f43dc
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/HTTP-4000.3.3
library-dirs: /usr/lib/ghc-7.10.3/site-local/HTTP-4000.3.3
data-dir: /usr/share/x86_64-linux-ghc-7.10.3/HTTP-4000.3.3
hs-libraries: HSHTTP-4000.3.3-81wlCO2OtSq8qX4gk8VIro
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-0d6d1084fbc041e1cded9228e80e264d
    bytestring-0.10.6.0-c60f4c543b22c7f7293a06ae48820437
    mtl-2.2.1-3af90341e75ee52dfc4e3143b4e5d219
    network-2.6.2.1-b9017957b1e5d0d1d9d4782a2ba4fcb5
    network-uri-2.6.1.0-ebfb6246973c95770c4c896a8a618864
    parsec-3.1.11-9fbeb486b9422a628611bfda22e15367
    time-1.5.0.1-edbd1a50e7922b396ada189ab8e8523b
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
