/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.cache.Resource;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ResourceUrlCreator {
    protected final Resource resource;
    protected final DownloadOptions downloadOptions;

    public ResourceUrlCreator(Resource resource, DownloadOptions downloadOptions) {
        this.resource = resource;
        this.downloadOptions = downloadOptions;
    }

    public List<URL> getUrls() {
        URL url;
        LinkedList<URL> urls = new LinkedList<URL>();
        if (this.downloadOptions.useExplicitPack() && this.downloadOptions.useExplicitVersion()) {
            url = ResourceUrlCreator.getUrl(this.resource, true, true);
            if (url != null) {
                urls.add(url);
            }
            if ((url = ResourceUrlCreator.getUrl(this.resource, false, true)) != null) {
                urls.add(url);
            }
            if ((url = ResourceUrlCreator.getUrl(this.resource, true, false)) != null) {
                urls.add(url);
            }
        } else if (this.downloadOptions.useExplicitPack()) {
            url = ResourceUrlCreator.getUrl(this.resource, true, false);
            if (url != null) {
                urls.add(url);
            }
        } else if (this.downloadOptions.useExplicitVersion() && (url = ResourceUrlCreator.getUrl(this.resource, false, true)) != null) {
            urls.add(url);
        }
        url = this.getVersionedUrl();
        urls.add(url);
        urls.add(this.resource.getLocation());
        boolean noHttpsPreffered = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.https.noenforce"));
        if (!noHttpsPreffered) {
            LinkedList<URL> urlsCopy = new LinkedList<URL>(urls);
            for (URL u : urlsCopy) {
                if (!u.getProtocol().equals("http")) continue;
                try {
                    urls.add(0, this.copyUrltoHttps(u));
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        }
        return urls;
    }

    static URL getUrl(Resource resource, boolean usePack, boolean useVersion) {
        if (!usePack && !useVersion) {
            throw new IllegalArgumentException("either pack200 or version required");
        }
        String location = resource.getLocation().toString();
        int lastSlash = resource.getLocation().toString().lastIndexOf(47);
        if (lastSlash == -1) {
            return resource.getLocation();
        }
        String filename = location.substring(lastSlash + 1);
        if (useVersion && resource.getRequestVersion() != null) {
            String[] parts = filename.split("\\.", -1);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                sb.append(parts[i]);
                if (i == parts.length - 2) {
                    sb.append("__V").append(resource.getRequestVersion());
                }
                sb.append('.');
            }
            sb.setLength(sb.length() - 1);
            filename = sb.toString();
        }
        if (usePack) {
            filename = filename + ".pack.gz";
        }
        location = location.substring(0, lastSlash + 1) + filename;
        try {
            URL newUrl = new URL(location);
            return newUrl;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected URL getVersionedUrl() {
        URL resourceUrl = this.resource.getLocation();
        String protocol = ResourceUrlCreator.uriPartToString(resourceUrl.getProtocol()) + "://";
        String userInfo = ResourceUrlCreator.uriPartToString(resourceUrl.getUserInfo());
        if (!userInfo.isEmpty()) {
            userInfo = userInfo + "@";
        }
        String host = ResourceUrlCreator.uriPartToString(resourceUrl.getHost());
        String port = resourceUrl.getPort() == -1 ? "" : ":" + String.valueOf(resourceUrl.getPort());
        String path = ResourceUrlCreator.uriPartToString(resourceUrl.getPath());
        String query = ResourceUrlCreator.uriPartToString(resourceUrl.getQuery());
        if (!query.isEmpty()) {
            query = "?" + query;
        }
        if (this.resource.getRequestVersion() != null && this.resource.getRequestVersion().isVersionId()) {
            query = !query.isEmpty() ? query + "&" : "?" + query;
            query = query + "version-id=" + this.resource.getRequestVersion();
        }
        try {
            URL url = new URL(protocol + userInfo + host + port + path + query);
            return url;
        }
        catch (MalformedURLException e) {
            return resourceUrl;
        }
    }

    private static String uriPartToString(String part) {
        if (part == null) {
            return "";
        }
        return part;
    }

    private URL copyUrltoHttps(URL u) throws MalformedURLException {
        if (u.getPort() < 0) {
            return new URL("https", u.getHost(), u.getFile());
        }
        return new URL("https", u.getHost(), u.getPort(), u.getFile(), null);
    }
}

