/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ImageDisplay
extends JComponent
implements Destroyable,
PreferenceChangedListener {
    private ImageEntry entry;
    private transient Image image;
    private boolean errorLoading;
    private VisRect visibleRect;
    private VisRect selectedRect;
    private final MediaTracker tracker = new MediaTracker(this);
    private final ImgDisplayMouseListener imgMouseListener = new ImgDisplayMouseListener();
    private String emptyText;
    private String osdText;
    private static final BooleanProperty AGPIFO_STYLE = new BooleanProperty("geoimage.agpifo-style-drag-and-zoom", false);
    private static int dragButton;
    private static int zoomButton;
    private static final BooleanProperty ZOOM_ON_CLICK;
    private static final DoubleProperty ZOOM_STEP;
    private static final DoubleProperty MAX_ZOOM;
    private static final BooleanProperty BILIN_DOWNSAMP;
    private static final BooleanProperty BILIN_UPSAMP;
    private static double bilinUpper;
    private static double bilinLower;

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e == null || e.getKey().equals(AGPIFO_STYLE.getKey())) {
            dragButton = AGPIFO_STYLE.get() != false ? 1 : 3;
            int n = zoomButton = dragButton == 1 ? 3 : 1;
        }
        if (e == null || e.getKey().equals(MAX_ZOOM.getKey()) || e.getKey().equals(BILIN_DOWNSAMP.getKey()) || e.getKey().equals(BILIN_UPSAMP.getKey())) {
            bilinUpper = BILIN_UPSAMP.get() != false ? 2.0 * MAX_ZOOM.get() : (BILIN_DOWNSAMP.get() != false ? 0.5 : 0.0);
            bilinLower = BILIN_DOWNSAMP.get() == false ? 1 : 0;
        }
    }

    public ImageDisplay() {
        this.addMouseListener(this.imgMouseListener);
        this.addMouseWheelListener(this.imgMouseListener);
        this.addMouseMotionListener(this.imgMouseListener);
        Config.getPref().addPreferenceChangeListener(this);
        this.preferenceChanged(null);
    }

    @Override
    public void destroy() {
        this.removeMouseListener(this.imgMouseListener);
        this.removeMouseWheelListener(this.imgMouseListener);
        this.removeMouseMotionListener(this.imgMouseListener);
        Config.getPref().removePreferenceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(ImageEntry entry) {
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            this.entry = entry;
            this.image = null;
            this.errorLoading = false;
        }
        this.repaint();
        if (entry != null) {
            new Thread((Runnable)new LoadImageRunnable(entry), LoadImageRunnable.class.getName()).start();
        }
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public void setOsdText(String text) {
        if (!text.equals(this.osdText)) {
            this.osdText = text;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        boolean errorLoading;
        VisRect visibleRect;
        ImageEntry entry;
        Image image;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            image = this.image;
            entry = this.entry;
            visibleRect = this.visibleRect;
            errorLoading = this.errorLoading;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Dimension size = this.getSize();
        if (entry == null) {
            g.setColor(Color.black);
            if (this.emptyText == null) {
                this.emptyText = I18n.tr("No image", new Object[0]);
            }
            String noImageStr = this.emptyText;
            Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(noImageStr, g);
            g.drawString(noImageStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
        } else if (image == null) {
            g.setColor(Color.black);
            String loadingStr = !errorLoading ? I18n.tr("Loading {0}", entry.getFile().getName()) : I18n.tr("Error on file {0}", entry.getFile().getName());
            Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(loadingStr, g);
            g.drawString(loadingStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
        } else {
            Rectangle r = new Rectangle(visibleRect);
            VisRect target = ImageDisplay.calculateDrawImageRectangle(visibleRect, size);
            double scale = (double)target.width / (double)r.width;
            if (this.selectedRect == null && !visibleRect.isDragUpdate && bilinLower < scale && scale < bilinUpper) {
                try {
                    BufferedImage bi = ImageProvider.toBufferedImage(image, r);
                    if (bi != null) {
                        r.y = 0;
                        r.x = 0;
                        bi = ImageProvider.createScaledImage(bi, target.width, target.height, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        r.width = target.width;
                        r.height = target.height;
                        image = bi;
                    }
                }
                catch (OutOfMemoryError oom) {
                    Logging.trace(oom);
                    r.x = visibleRect.x;
                    r.y = visibleRect.y;
                }
            } else if (scale * (double)(r.x + r.width) > 32767.0 || scale * (double)(r.y + r.height) > 32767.0) {
                image = ImageProvider.toBufferedImage(image, r);
                r.y = 0;
                r.x = 0;
            }
            g.drawImage(image, target.x, target.y, target.x + target.width, target.y + target.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
            if (this.selectedRect != null) {
                Point topLeft = ImageDisplay.img2compCoord(visibleRect, this.selectedRect.x, this.selectedRect.y, size);
                Point bottomRight = ImageDisplay.img2compCoord(visibleRect, this.selectedRect.x + this.selectedRect.width, this.selectedRect.y + this.selectedRect.height, size);
                g.setColor(new Color(128, 128, 128, 180));
                g.fillRect(target.x, target.y, target.width, topLeft.y - target.y);
                g.fillRect(target.x, target.y, topLeft.x - target.x, target.height);
                g.fillRect(bottomRight.x, target.y, target.x + target.width - bottomRight.x, target.height);
                g.fillRect(target.x, bottomRight.y, target.width, target.y + target.height - bottomRight.y);
                g.setColor(Color.black);
                g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
            }
            if (errorLoading) {
                String loadingStr = I18n.tr("Error on file {0}", entry.getFile().getName());
                Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(loadingStr, g);
                g.drawString(loadingStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
            }
            if (this.osdText != null) {
                Rectangle2D lineSize;
                String line;
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                int ascent = metrics.getAscent();
                Color bkground = new Color(255, 255, 255, 128);
                int lastPos = 0;
                int pos = this.osdText.indexOf(10);
                int x = 3;
                int y = 3;
                while (pos > 0) {
                    line = this.osdText.substring(lastPos, pos);
                    lineSize = metrics.getStringBounds(line, g);
                    g.setColor(bkground);
                    g.fillRect(x, y, (int)lineSize.getWidth(), (int)lineSize.getHeight());
                    g.setColor(Color.black);
                    g.drawString(line, x, y + ascent);
                    y += (int)lineSize.getHeight();
                    lastPos = pos + 1;
                    pos = this.osdText.indexOf(10, lastPos);
                }
                line = this.osdText.substring(lastPos);
                lineSize = g.getFontMetrics(g.getFont()).getStringBounds(line, g);
                g.setColor(bkground);
                g.fillRect(x, y, (int)lineSize.getWidth(), (int)lineSize.getHeight());
                g.setColor(Color.black);
                g.drawString(line, x, y + ascent);
            }
        }
    }

    static Point img2compCoord(VisRect visibleRect, int xImg, int yImg, Dimension compSize) {
        VisRect drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, compSize);
        return new Point(drawRect.x + (xImg - visibleRect.x) * drawRect.width / visibleRect.width, drawRect.y + (yImg - visibleRect.y) * drawRect.height / visibleRect.height);
    }

    static Point comp2imgCoord(VisRect visibleRect, int xComp, int yComp, Dimension compSize) {
        VisRect drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, compSize);
        Point p = new Point((xComp - drawRect.x) * visibleRect.width, (yComp - drawRect.y) * visibleRect.height);
        p.x = p.x + (p.x % drawRect.width << 1 >= drawRect.width ? drawRect.width : 0);
        p.y = p.y + (p.y % drawRect.height << 1 >= drawRect.height ? drawRect.height : 0);
        p.x = visibleRect.x + p.x / drawRect.width;
        p.y = visibleRect.y + p.y / drawRect.height;
        return p;
    }

    static Point getCenterImgCoord(Rectangle visibleRect) {
        return new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
    }

    static VisRect calculateDrawImageRectangle(VisRect visibleRect, Dimension compSize) {
        return ImageDisplay.calculateDrawImageRectangle(visibleRect, new Rectangle(0, 0, compSize.width, compSize.height));
    }

    static VisRect calculateDrawImageRectangle(VisRect imgRect, Rectangle compRect) {
        int x = 0;
        int y = 0;
        int w = compRect.width;
        int wFact = w * imgRect.height;
        int h = compRect.height;
        int hFact = h * imgRect.width;
        if (wFact != hFact) {
            if (wFact > hFact) {
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            } else {
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            }
        }
        if (w > imgRect.width && h > imgRect.height && !imgRect.isFullView1D() && wFact != hFact) {
            if (wFact > hFact) {
                w = compRect.width;
                x = 0;
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            } else {
                h = compRect.height;
                y = 0;
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            }
        }
        return new VisRect(x + compRect.x, y + compRect.y, w, h, imgRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomBestFitOrOne() {
        VisRect visibleRect;
        Image image;
        ImageEntry entry;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            entry = this.entry;
            image = this.image;
            visibleRect = this.visibleRect;
        }
        if (image == null) {
            return;
        }
        if (visibleRect.width != image.getWidth(null) || visibleRect.height != image.getHeight(null)) {
            visibleRect.reset();
        } else {
            Point center = ImageDisplay.getCenterImgCoord(visibleRect);
            visibleRect.setBounds(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2, this.getWidth(), this.getHeight());
            visibleRect.checkRectSize();
            visibleRect.checkRectPos();
        }
        imageDisplay = this;
        synchronized (imageDisplay) {
            if (this.entry == entry) {
                this.visibleRect = visibleRect;
            }
        }
        this.repaint();
    }

    static {
        ZOOM_ON_CLICK = new BooleanProperty("geoimage.use-mouse-clicks-to-zoom", true);
        ZOOM_STEP = new DoubleProperty("geoimage.zoom-step-factor", 1.5);
        MAX_ZOOM = new DoubleProperty("geoimage.maximum-zoom-scale", 2.0);
        BILIN_DOWNSAMP = new BooleanProperty("geoimage.bilinear-downsampling-progressive", true);
        BILIN_UPSAMP = new BooleanProperty("geoimage.bilinear-upsampling", false);
    }

    private class ImgDisplayMouseListener
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        private MouseEvent lastMouseEvent;
        private Point mousePointInImg;

        private ImgDisplayMouseListener() {
        }

        private boolean mouseIsDragging(MouseEvent e) {
            return dragButton == 1 && SwingUtilities.isLeftMouseButton(e) || dragButton == 2 && SwingUtilities.isMiddleMouseButton(e) || dragButton == 3 && SwingUtilities.isRightMouseButton(e);
        }

        private boolean mouseIsZoomSelecting(MouseEvent e) {
            return zoomButton == 1 && SwingUtilities.isLeftMouseButton(e) || zoomButton == 2 && SwingUtilities.isMiddleMouseButton(e) || zoomButton == 3 && SwingUtilities.isRightMouseButton(e);
        }

        private boolean isAtMaxZoom(Rectangle visibleRect) {
            return visibleRect.width == (int)((double)ImageDisplay.this.getSize().width / MAX_ZOOM.get()) || visibleRect.height == (int)((double)ImageDisplay.this.getSize().height / MAX_ZOOM.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mouseWheelMovedImpl(int x, int y, int rotation, boolean refreshMousePointInImg) {
            int wFact;
            int hFact;
            VisRect visibleRect;
            Image image;
            ImageEntry entry;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                entry = ImageDisplay.this.entry;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            ImageDisplay.this.selectedRect = null;
            if (image == null) {
                return;
            }
            if (refreshMousePointInImg) {
                this.mousePointInImg = ImageDisplay.comp2imgCoord(visibleRect, x, y, ImageDisplay.this.getSize());
            }
            if (rotation > 0) {
                visibleRect.width = (int)((double)visibleRect.width * ZOOM_STEP.get());
                visibleRect.height = (int)((double)visibleRect.height * ZOOM_STEP.get());
            } else {
                visibleRect.width = (int)((double)visibleRect.width / ZOOM_STEP.get());
                visibleRect.height = (int)((double)visibleRect.height / ZOOM_STEP.get());
            }
            if ((double)visibleRect.width < (double)ImageDisplay.this.getSize().width / MAX_ZOOM.get()) {
                visibleRect.width = (int)((double)ImageDisplay.this.getSize().width / MAX_ZOOM.get());
            }
            if ((double)visibleRect.height < (double)ImageDisplay.this.getSize().height / MAX_ZOOM.get()) {
                visibleRect.height = (int)((double)ImageDisplay.this.getSize().height / MAX_ZOOM.get());
            }
            if ((hFact = visibleRect.height * ImageDisplay.this.getSize().width) > (wFact = visibleRect.width * ImageDisplay.this.getSize().height)) {
                visibleRect.width = hFact / ImageDisplay.this.getSize().height;
            } else {
                visibleRect.height = wFact / ImageDisplay.this.getSize().width;
            }
            visibleRect.checkRectSize();
            VisRect drawRect = ImageDisplay.calculateDrawImageRectangle(visibleRect, ImageDisplay.this.getSize());
            visibleRect.x = this.mousePointInImg.x + (drawRect.x - x) * visibleRect.width / drawRect.width;
            visibleRect.y = this.mousePointInImg.y + (drawRect.y - y) * visibleRect.height / drawRect.height;
            visibleRect.checkRectPos();
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.entry == entry) {
                    ImageDisplay.this.visibleRect = visibleRect;
                }
            }
            ImageDisplay.this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean refreshMousePointInImg = false;
            if (this.lastMouseEvent == null || this.mousePointInImg == null || (this.lastMouseEvent.getX() - e.getX()) * (this.lastMouseEvent.getX() - e.getX()) + (this.lastMouseEvent.getY() - e.getY()) * (this.lastMouseEvent.getY() - e.getY()) > 16) {
                this.lastMouseEvent = e;
                refreshMousePointInImg = true;
            }
            this.mouseWheelMovedImpl(e.getX(), e.getY(), e.getWheelRotation(), refreshMousePointInImg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            VisRect visibleRect;
            Image image;
            ImageEntry entry;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                entry = ImageDisplay.this.entry;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (ZOOM_ON_CLICK.get().booleanValue()) {
                this.lastMouseEvent = null;
                if (this.mouseIsZoomSelecting(e) && !this.isAtMaxZoom(visibleRect)) {
                    this.mouseWheelMovedImpl(e.getX(), e.getY(), -1, true);
                    return;
                }
                if (this.mouseIsDragging(e)) {
                    this.mouseWheelMovedImpl(e.getX(), e.getY(), 1, true);
                    return;
                }
            }
            Point click = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
            Point center = ImageDisplay.getCenterImgCoord(visibleRect);
            visibleRect.x += click.x - center.x;
            visibleRect.y += click.y - center.y;
            visibleRect.checkRectPos();
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (ImageDisplay.this.entry == entry) {
                    ImageDisplay.this.visibleRect = visibleRect;
                }
            }
            ImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            VisRect visibleRect;
            Image image;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            ImageDisplay.this.selectedRect = null;
            if (this.mouseIsDragging(e) || this.mouseIsZoomSelecting(e)) {
                this.mousePointInImg = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Point p;
            VisRect visibleRect;
            Image image;
            ImageEntry entry;
            if (!this.mouseIsDragging(e) && !this.mouseIsZoomSelecting(e)) {
                return;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                entry = ImageDisplay.this.entry;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (this.mouseIsDragging(e) && this.mousePointInImg != null) {
                p = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                visibleRect.isDragUpdate = true;
                visibleRect.x += this.mousePointInImg.x - p.x;
                visibleRect.y += this.mousePointInImg.y - p.y;
                visibleRect.checkRectPos();
                ImageDisplay imageDisplay2 = ImageDisplay.this;
                synchronized (imageDisplay2) {
                    if (ImageDisplay.this.entry == entry) {
                        ImageDisplay.this.visibleRect = visibleRect;
                    }
                }
                ImageDisplay.this.repaint();
            }
            if (this.mouseIsZoomSelecting(e) && this.mousePointInImg != null) {
                p = ImageDisplay.comp2imgCoord(visibleRect, e.getX(), e.getY(), ImageDisplay.this.getSize());
                visibleRect.checkPointInside(p);
                VisRect selectedRect = new VisRect(p.x < this.mousePointInImg.x ? p.x : this.mousePointInImg.x, p.y < this.mousePointInImg.y ? p.y : this.mousePointInImg.y, p.x < this.mousePointInImg.x ? this.mousePointInImg.x - p.x : p.x - this.mousePointInImg.x, p.y < this.mousePointInImg.y ? this.mousePointInImg.y - p.y : p.y - this.mousePointInImg.y, visibleRect);
                selectedRect.checkRectSize();
                selectedRect.checkRectPos();
                ImageDisplay.this.selectedRect = selectedRect;
                ImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            VisRect visibleRect;
            Image image;
            ImageEntry entry;
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                entry = ImageDisplay.this.entry;
                image = ImageDisplay.this.image;
                visibleRect = ImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (this.mouseIsDragging(e)) {
                visibleRect.isDragUpdate = false;
            }
            if (this.mouseIsZoomSelecting(e) && ImageDisplay.this.selectedRect != null) {
                int wFact;
                int hFact;
                int oldWidth = ((ImageDisplay)ImageDisplay.this).selectedRect.width;
                int oldHeight = ((ImageDisplay)ImageDisplay.this).selectedRect.height;
                if ((double)((ImageDisplay)ImageDisplay.this).selectedRect.width < (double)ImageDisplay.this.getSize().width / MAX_ZOOM.get()) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.width = (int)((double)ImageDisplay.this.getSize().width / MAX_ZOOM.get());
                }
                if ((double)((ImageDisplay)ImageDisplay.this).selectedRect.height < (double)ImageDisplay.this.getSize().height / MAX_ZOOM.get()) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.height = (int)((double)ImageDisplay.this.getSize().height / MAX_ZOOM.get());
                }
                if ((hFact = ((ImageDisplay)ImageDisplay.this).selectedRect.height * ImageDisplay.this.getSize().width) > (wFact = ((ImageDisplay)ImageDisplay.this).selectedRect.width * ImageDisplay.this.getSize().height)) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.width = hFact / ImageDisplay.this.getSize().height;
                } else {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.height = wFact / ImageDisplay.this.getSize().width;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.width != oldWidth) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.x -= (((ImageDisplay)ImageDisplay.this).selectedRect.width - oldWidth) / 2;
                }
                if (((ImageDisplay)ImageDisplay.this).selectedRect.height != oldHeight) {
                    ((ImageDisplay)ImageDisplay.this).selectedRect.y -= (((ImageDisplay)ImageDisplay.this).selectedRect.height - oldHeight) / 2;
                }
                ImageDisplay.this.selectedRect.checkRectSize();
                ImageDisplay.this.selectedRect.checkRectPos();
            }
            ImageDisplay imageDisplay2 = ImageDisplay.this;
            synchronized (imageDisplay2) {
                if (entry == ImageDisplay.this.entry) {
                    if (ImageDisplay.this.selectedRect == null) {
                        ImageDisplay.this.visibleRect = visibleRect;
                    } else {
                        ImageDisplay.this.visibleRect.setBounds(ImageDisplay.this.selectedRect);
                        ImageDisplay.this.selectedRect = null;
                    }
                }
            }
            ImageDisplay.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class LoadImageRunnable
    implements Runnable,
    ImageObserver {
        private final ImageEntry entry;
        private final File file;

        LoadImageRunnable(ImageEntry entry) {
            this.entry = entry;
            this.file = entry.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 1) == 1 && (infoflags & 2) == 2) {
                ImageEntry imageEntry = this.entry;
                synchronized (imageEntry) {
                    this.entry.setWidth(width);
                    this.entry.setHeight(height);
                    this.entry.notifyAll();
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateImageEntry(Image img) {
            if (this.entry.getWidth() <= 0 || this.entry.getHeight() <= 0) {
                ImageEntry imageEntry = this.entry;
                synchronized (imageEntry) {
                    img.getWidth(this);
                    img.getHeight(this);
                    long now = System.currentTimeMillis();
                    while (this.entry.getWidth() <= 0 || this.entry.getHeight() <= 0) {
                        try {
                            this.entry.wait(1000L);
                            if (this.entry != ImageDisplay.this.entry) {
                                return false;
                            }
                            if (System.currentTimeMillis() - now <= 10000L) continue;
                            ImageDisplay imageDisplay = ImageDisplay.this;
                            synchronized (imageDisplay) {
                                ImageDisplay.this.errorLoading = true;
                                ImageDisplay.this.repaint();
                                return false;
                            }
                        }
                        catch (InterruptedException e) {
                            Logging.trace(e);
                            Logging.warn("InterruptedException in {0} while getting properties of image {1}", this.getClass().getSimpleName(), this.file.getPath());
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            return true;
        }

        private boolean mayFitMemory(long amountWanted) {
            return amountWanted < Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int height;
            Image img = Toolkit.getDefaultToolkit().createImage(this.file.getPath());
            if (!this.updateImageEntry(img)) {
                return;
            }
            int width = this.entry.getWidth();
            if (this.mayFitMemory((long)width * (long)(height = this.entry.getHeight()) * 4L * 2L)) {
                Logging.info("Loading {0} using default toolkit", this.file.getPath());
                ImageDisplay.this.tracker.addImage(img, 1);
                while (!ImageDisplay.this.tracker.checkID(1, true)) {
                    if (this.entry != ImageDisplay.this.entry) {
                        ImageDisplay.this.tracker.removeImage(img);
                        return;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        Logging.trace(e);
                        Logging.warn("InterruptedException in {0} while loading image {1}", this.getClass().getSimpleName(), this.file.getPath());
                        Thread.currentThread().interrupt();
                    }
                }
                if (ImageDisplay.this.tracker.isErrorID(1)) {
                    ImageDisplay.this.tracker.removeImage(img);
                    img = null;
                } else {
                    ImageDisplay.this.tracker.removeImage(img);
                }
            } else {
                img = null;
            }
            ImageDisplay imageDisplay = ImageDisplay.this;
            synchronized (imageDisplay) {
                if (this.entry != ImageDisplay.this.entry) {
                    return;
                }
                if (img != null) {
                    boolean switchedDim = false;
                    if (ExifReader.orientationNeedsCorrection(this.entry.getExifOrientation())) {
                        if (ExifReader.orientationSwitchesDimensions(this.entry.getExifOrientation())) {
                            width = img.getHeight(null);
                            height = img.getWidth(null);
                            switchedDim = true;
                        }
                        BufferedImage rot = new BufferedImage(width, height, 1);
                        AffineTransform xform = ExifReader.getRestoreOrientationTransform(this.entry.getExifOrientation(), img.getWidth(null), img.getHeight(null));
                        Graphics2D g = rot.createGraphics();
                        g.drawImage(img, xform, null);
                        g.dispose();
                        img = rot;
                    }
                    ImageDisplay.this.image = img;
                    ImageDisplay.this.visibleRect = new VisRect(0, 0, width, height);
                    Logging.info("Loaded {0} with dimensions {1}x{2} memoryTaken={3}m exifOrientationSwitchedDimension={4}", this.file.getPath(), width, height, width * height * 4 / 1024 / 1024, switchedDim);
                }
                ImageDisplay.this.selectedRect = null;
                ImageDisplay.this.errorLoading = img == null;
            }
            ImageDisplay.this.repaint();
        }
    }

    public static class VisRect
    extends Rectangle {
        private final Rectangle init;
        public boolean isDragUpdate;

        public VisRect(int x, int y, int width, int height) {
            super(x, y, width, height);
            this.init = new Rectangle(this);
        }

        public VisRect(int x, int y, int width, int height, VisRect peer) {
            super(x, y, width, height);
            this.init = peer.init;
        }

        public VisRect(VisRect v) {
            super(v);
            this.init = v.init;
        }

        public VisRect() {
            this(0, 0, 0, 0);
        }

        public boolean isFullView() {
            return this.init.equals(this);
        }

        public boolean isFullView1D() {
            return this.init.x == this.x && this.init.width == this.width || this.init.y == this.y && this.init.height == this.height;
        }

        public void reset() {
            this.setBounds(this.init);
        }

        public void checkRectPos() {
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.init.width) {
                this.x = this.init.width - this.width;
            }
            if (this.y + this.height > this.init.height) {
                this.y = this.init.height - this.height;
            }
        }

        public void checkRectSize() {
            if (this.width > this.init.width) {
                this.width = this.init.width;
            }
            if (this.height > this.init.height) {
                this.height = this.init.height;
            }
        }

        public void checkPointInside(Point p) {
            if (p.x < this.x) {
                p.x = this.x;
            }
            if (p.x > this.x + this.width) {
                p.x = this.x + this.width;
            }
            if (p.y < this.y) {
                p.y = this.y;
            }
            if (p.y > this.y + this.height) {
                p.y = this.y + this.height;
            }
        }
    }
}

