/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ValidatorErrorWriter
extends XmlWriter {
    public ValidatorErrorWriter(PrintWriter out) {
        super(out);
    }

    public ValidatorErrorWriter(OutputStream out) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8))));
    }

    public void write(Collection<TestError> validationErrors) {
        Set analysers = validationErrors.stream().map(TestError::getTester).collect(Collectors.toCollection(TreeSet::new));
        String timestamp = DateUtils.fromDate(new Date());
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.println("<analysers generator='JOSM' timestamp='" + timestamp + "'>");
        OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(this.out, true, "0.6");
        String lang = LanguageInfo.getJOSMLocaleCode();
        for (Test test : analysers) {
            this.out.println("  <analyser timestamp='" + timestamp + "' name='" + XmlWriter.encode(test.getName()) + "'>");
            HashMap map = new HashMap();
            for (Map.Entry<Severity, Map<String, Map<String, List<TestError>>>> entry : OsmValidator.getErrorsBySeverityMessageDescription(validationErrors, e -> e.getTester() == test).entrySet()) {
                for (Map.Entry<String, Map<String, List<TestError>>> e2 : entry.getValue().entrySet()) {
                    ErrorClass errorClass = new ErrorClass(entry.getKey(), e2.getKey());
                    ArrayList list = (ArrayList)map.get(errorClass);
                    if (list == null) {
                        list = new ArrayList();
                        map.put(errorClass, list);
                    }
                    e2.getValue().values().forEach(list::addAll);
                }
            }
            for (ErrorClass errorClass : map.keySet()) {
                this.out.println("    <class id='" + errorClass.id + "' level='" + errorClass.severity.getLevel() + "'>");
                this.out.println("      <classtext lang='" + XmlWriter.encode(lang) + "' title='" + XmlWriter.encode(errorClass.message) + "'/>");
                this.out.println("    </class>");
            }
            for (Map.Entry<Severity, Map<String, Map<String, List<TestError>>>> entry : map.entrySet()) {
                for (TestError error : (List)((Object)entry.getValue())) {
                    LatLon ll = error.getPrimitives().iterator().next().getBBox().getCenter();
                    this.out.println("    <error class='" + ((ErrorClass)((Object)entry.getKey())).id + "'>");
                    this.out.print("      <location");
                    osmWriter.writeLatLon(ll);
                    this.out.println("/>");
                    for (OsmPrimitive osmPrimitive : error.getPrimitives()) {
                        osmPrimitive.accept(osmWriter);
                    }
                    this.out.println("      <text lang='" + XmlWriter.encode(lang) + "' value='" + XmlWriter.encode(error.getDescription()) + "'/>");
                    if (error.isFixable()) {
                        this.out.println("      <fixes>");
                        Command fix = error.getFix();
                        if (fix instanceof AddPrimitivesCommand) {
                            Logging.info("TODO: {0}", fix);
                        } else if (fix instanceof DeleteCommand) {
                            Logging.info("TODO: {0}", fix);
                        } else if (fix instanceof ChangePropertyCommand) {
                            Logging.info("TODO: {0}", fix);
                        } else if (fix instanceof ChangePropertyKeyCommand) {
                            Logging.info("TODO: {0}", fix);
                        } else {
                            Logging.warn("Unsupported command type: {0}", fix);
                        }
                        this.out.println("      </fixes>");
                    }
                    this.out.println("    </error>");
                }
            }
            this.out.println("  </analyser>");
        }
        this.out.println("</analysers>");
        this.out.flush();
    }

    private static class ErrorClass {
        static int idCounter;
        final Severity severity;
        final String message;
        final int id;

        ErrorClass(Severity severity, String message) {
            this.severity = severity;
            this.message = message;
            this.id = ++idCounter;
        }
    }
}

