/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.IWithAttributes;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.xml.sax.Attributes;

public class GpxExtension
extends WithAttributes {
    private final String qualifiedName;
    private final String prefix;
    private final String key;
    private IWithAttributes parent;
    private String value;
    private boolean visible = true;

    public GpxExtension(String prefix, String key, String value) {
        this.prefix = Optional.ofNullable(prefix).orElse("");
        this.key = key;
        this.value = value;
        this.qualifiedName = (this.prefix.isEmpty() ? "" : this.prefix + ":") + key;
    }

    public GpxExtension(String namespaceURI, String qName, Attributes atts) {
        this.qualifiedName = qName;
        int dot = qName.indexOf(58);
        String p = GpxExtension.findPrefix(namespaceURI);
        this.prefix = p == null ? (dot != -1 ? qName.substring(0, dot) : "") : p;
        this.key = qName.substring(dot + 1);
        for (int i = 0; i < atts.getLength(); ++i) {
            this.attr.put(atts.getLocalName(i), atts.getValue(i));
        }
    }

    public static String findPrefix(String namespaceURI) {
        if (XML_URI_EXTENSIONS_DRAWING.equals(namespaceURI)) {
            return "gpxd";
        }
        if ("http://www.garmin.com/xmlschemas/GpxExtensions/v3".equals(namespaceURI)) {
            return "gpxx";
        }
        if (XML_URI_EXTENSIONS_JOSM.equals(namespaceURI)) {
            return "josm";
        }
        return null;
    }

    public static GpxData.XMLNamespace findNamespace(String prefix) {
        switch (prefix) {
            case "gpxx": {
                return new GpxData.XMLNamespace("gpxx", "http://www.garmin.com/xmlschemas/GpxExtensions/v3", "http://www.garmin.com/xmlschemas/GpxExtensionsv3.xsd");
            }
            case "gpxd": {
                return new GpxData.XMLNamespace("gpxd", XML_URI_EXTENSIONS_DRAWING, XML_XSD_EXTENSIONS_DRAWING);
            }
            case "josm": {
                return new GpxData.XMLNamespace("josm", XML_URI_EXTENSIONS_JOSM, XML_XSD_EXTENSIONS_JOSM);
            }
        }
        return null;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getKey() {
        return this.key;
    }

    public String getFlatKey() {
        String ret = "";
        if (this.parent != null && this.parent instanceof GpxExtension) {
            GpxExtension ext = (GpxExtension)this.parent;
            ret = ext.getFlatKey() + ":";
        }
        return ret + this.getKey();
    }

    public GpxExtension findExtension(String sPrefix, String sKey) {
        if (this.prefix.equalsIgnoreCase(sPrefix) && this.key.equalsIgnoreCase(sKey)) {
            return this;
        }
        return this.getExtensions().stream().map(child -> child.findExtension(sPrefix, sKey)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void remove() {
        GpxExtension gpx;
        if (this.parent == null) {
            throw new IllegalStateException("Extension " + this.qualifiedName + " has no parent, can't remove it.");
        }
        this.parent.getExtensions().remove(this);
        if (this.parent instanceof GpxExtension && ((gpx = (GpxExtension)this.parent).getValue() == null || gpx.getValue().trim().isEmpty()) && gpx.getAttributes().isEmpty() && gpx.getExtensions().isEmpty()) {
            gpx.remove();
        }
    }

    public void hide() {
        GpxExtension gpx;
        this.visible = false;
        if (this.parent != null && this.parent instanceof GpxExtension && ((gpx = (GpxExtension)this.parent).getValue() == null || gpx.getValue().trim().isEmpty()) && gpx.getAttributes().isEmpty() && !gpx.getExtensions().isVisible()) {
            gpx.hide();
        }
    }

    public void show() {
        this.visible = true;
        if (this.parent != null && this.parent instanceof GpxExtension) {
            ((GpxExtension)this.parent).show();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public IWithAttributes getParent() {
        return this.parent;
    }

    public void setParent(IWithAttributes parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Parent of extension " + this.qualifiedName + " is already set");
        }
        this.parent = parent;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.prefix, this.key, this.value, this.attr, this.visible, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GpxExtension)) {
            return false;
        }
        GpxExtension other = (GpxExtension)obj;
        if (this.visible != other.visible) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.attr == null ? other.attr != null : !this.attr.equals(other.attr));
    }
}

