/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePair;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Pair;

public class NodeGraph {
    private final Set<NodePair> edges;
    private int numUndirectedEges;
    private int addedEdges;
    private final Map<Node, List<NodePair>> successors = new LinkedHashMap<Node, List<NodePair>>();
    private final Map<Node, List<NodePair>> predecessors = new LinkedHashMap<Node, List<NodePair>>();

    public static List<NodePair> buildNodePairs(Way way, boolean directed) {
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        for (Pair<Node, Node> pair : way.getNodePairs(false)) {
            pairs.add(new NodePair(pair));
            if (directed) continue;
            pairs.add(new NodePair(pair).swap());
        }
        return pairs;
    }

    public static List<NodePair> buildNodePairs(List<Way> ways, boolean directed) {
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        for (Way w : ways) {
            pairs.addAll(NodeGraph.buildNodePairs(w, directed));
        }
        return pairs;
    }

    public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> pairs) {
        ArrayList<NodePair> cleaned = new ArrayList<NodePair>();
        for (NodePair p : pairs) {
            if (cleaned.contains(p) || cleaned.contains(p.swap())) continue;
            cleaned.add(p);
        }
        return cleaned;
    }

    public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> pairs) {
        NodeGraph graph = new NodeGraph();
        for (NodePair pair : pairs) {
            graph.add(pair);
        }
        return graph;
    }

    public static NodeGraph createDirectedGraphFromWays(Collection<Way> ways) {
        NodeGraph graph = new NodeGraph();
        for (Way w : ways) {
            graph.add(NodeGraph.buildNodePairs(w, true));
        }
        return graph;
    }

    public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> pairs) {
        NodeGraph graph = new NodeGraph();
        for (NodePair pair : pairs) {
            graph.add(pair);
            graph.add(pair.swap());
        }
        return graph;
    }

    public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> ways) {
        NodeGraph graph = new NodeGraph();
        for (Way w : ways) {
            graph.add(NodeGraph.buildNodePairs(w, false));
        }
        return graph;
    }

    public static NodeGraph createNearlyUndirectedGraphFromNodeWays(Collection<Way> ways) {
        boolean dir = true;
        NodeGraph graph = new NodeGraph();
        for (Way w : ways) {
            if (!w.isNew()) {
                graph.add(NodeGraph.buildNodePairs(w, dir));
                dir = false;
                continue;
            }
            graph.add(NodeGraph.buildNodePairs(w, false));
        }
        return graph;
    }

    protected void rememberSuccessor(NodePair pair) {
        List l = this.successors.computeIfAbsent(pair.getA(), k -> new ArrayList());
        if (!l.contains(pair)) {
            l.add(pair);
        }
    }

    protected void rememberPredecessors(NodePair pair) {
        List l = this.predecessors.computeIfAbsent(pair.getB(), k -> new ArrayList());
        if (!l.contains(pair)) {
            l.add(pair);
        }
    }

    protected boolean isTerminalNode(Node n) {
        if (this.successors.get(n) == null) {
            return false;
        }
        if (this.successors.get(n).size() != 1) {
            return false;
        }
        if (this.predecessors.get(n) == null) {
            return true;
        }
        if (this.predecessors.get(n).size() == 1) {
            NodePair p1 = this.successors.get(n).get(0);
            NodePair p2 = this.predecessors.get(n).get(0);
            return p1.equals(p2.swap());
        }
        return false;
    }

    protected void prepare() {
        LinkedHashSet<NodePair> undirectedEdges = new LinkedHashSet<NodePair>();
        this.successors.clear();
        this.predecessors.clear();
        for (NodePair pair : this.edges) {
            if (!undirectedEdges.contains(pair) && !undirectedEdges.contains(pair.swap())) {
                undirectedEdges.add(pair);
            }
            this.rememberSuccessor(pair);
            this.rememberPredecessors(pair);
        }
        this.numUndirectedEges = undirectedEdges.size();
    }

    public NodeGraph() {
        this.edges = new LinkedHashSet<NodePair>();
    }

    public void add(NodePair pair) {
        ++this.addedEdges;
        this.edges.add(pair);
    }

    public void add(Collection<NodePair> pairs) {
        for (NodePair pair : pairs) {
            this.add(pair);
        }
    }

    protected Set<Node> getTerminalNodes() {
        return this.getNodes().stream().filter(this::isTerminalNode).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<NodePair> getConnectedPairs(Node node) {
        ArrayList<NodePair> connected = new ArrayList<NodePair>();
        connected.addAll(Optional.ofNullable(this.successors.get(node)).orElseGet(Collections::emptyList));
        connected.addAll(Optional.ofNullable(this.predecessors.get(node)).orElseGet(Collections::emptyList));
        return connected;
    }

    protected List<NodePair> getOutboundPairs(NodePair pair) {
        return this.getOutboundPairs(pair.getB());
    }

    protected List<NodePair> getOutboundPairs(Node node) {
        return Optional.ofNullable(this.successors.get(node)).orElseGet(Collections::emptyList);
    }

    protected Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(2 * this.edges.size());
        for (NodePair pair : this.edges) {
            nodes.add(pair.getA());
            nodes.add(pair.getB());
        }
        return nodes;
    }

    protected boolean isSpanningWay(Collection<NodePair> way) {
        return this.numUndirectedEges == way.size();
    }

    protected List<Node> buildPathFromNodePairs(Deque<NodePair> path) {
        return Stream.concat(path.stream().map(NodePair::getA), Stream.of(path.peekLast().getB())).collect(Collectors.toList());
    }

    protected List<Node> buildSpanningPath(Node startNode) {
        if (startNode != null) {
            ArrayDeque<NodePair> path = new ArrayDeque<NodePair>();
            HashSet<NodePair> dupCheck = new HashSet<NodePair>();
            ArrayDeque<NodePair> nextPairs = new ArrayDeque<NodePair>();
            nextPairs.addAll(this.getOutboundPairs(startNode));
            while (!nextPairs.isEmpty()) {
                NodePair cur = (NodePair)nextPairs.removeLast();
                if (dupCheck.contains(cur) || dupCheck.contains(cur.swap())) continue;
                while (!path.isEmpty() && !((NodePair)path.peekLast()).isPredecessorOf(cur)) {
                    dupCheck.remove(path.removeLast());
                }
                path.addLast(cur);
                dupCheck.add(cur);
                if (this.isSpanningWay(path)) {
                    return this.buildPathFromNodePairs(path);
                }
                nextPairs.addAll(this.getOutboundPairs((NodePair)path.peekLast()));
            }
        }
        return Collections.emptyList();
    }

    public List<Node> buildSpanningPath() {
        this.prepare();
        if (this.numUndirectedEges > 0 && this.isConnected()) {
            Set<Node> nodes = this.getTerminalNodes();
            nodes = nodes.isEmpty() ? this.getMostFrequentVisitedNodesFirst() : nodes;
            return nodes.stream().map(this::buildSpanningPath).filter(path -> !path.isEmpty()).findFirst().orElse(null);
        }
        return null;
    }

    public List<Node> buildSpanningPathNoRemove() {
        List<Node> path = null;
        if (this.edges.size() == this.addedEdges) {
            path = this.buildSpanningPath();
        }
        return path == null ? Collections.emptyList() : path;
    }

    private boolean isConnected() {
        Set<Node> nodes = this.getNodes();
        if (nodes.isEmpty()) {
            return false;
        }
        ArrayDeque<Node> toVisit = new ArrayDeque<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        toVisit.add(nodes.iterator().next());
        while (!toVisit.isEmpty()) {
            Node n = (Node)toVisit.pop();
            if (visited.contains(n)) continue;
            for (NodePair pair : this.getConnectedPairs(n)) {
                if (n != pair.getA()) {
                    toVisit.addLast(pair.getA());
                }
                if (n == pair.getB()) continue;
                toVisit.addLast(pair.getB());
            }
            visited.add(n);
        }
        return nodes.size() == visited.size();
    }

    private Set<Node> getMostFrequentVisitedNodesFirst() {
        if (this.edges.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<Node, Integer> counters = new HashMap<Node, Integer>();
        for (NodePair nodePair : this.edges) {
            Integer n = (Integer)counters.get(nodePair.getA());
            counters.put(nodePair.getA(), n == null ? 1 : n + 1);
            Integer n2 = (Integer)counters.get(nodePair.getB());
            counters.put(nodePair.getB(), n2 == null ? 1 : n2 + 1);
        }
        TreeMap sortedMap = new TreeMap(Comparator.reverseOrder());
        for (Map.Entry entry : counters.entrySet()) {
            sortedMap.computeIfAbsent((Integer)entry.getValue(), LinkedHashSet::new).add((Node)entry.getKey());
        }
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        for (Map.Entry e : sortedMap.entrySet()) {
            if ((Integer)e.getKey() <= 4 && !linkedHashSet.isEmpty()) continue;
            linkedHashSet.addAll((Collection)e.getValue());
        }
        return linkedHashSet;
    }
}

