/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.tools.I18n;

public abstract class FileExporter
implements MainLayerManager.ActiveLayerChangeListener {
    public final ExtensionFileFilter filter;
    private boolean enabled;
    private boolean canceled;

    public FileExporter(ExtensionFileFilter filter) {
        this.filter = filter;
        this.enabled = true;
    }

    public boolean acceptFile(File pathname, Layer layer) {
        return this.filter.acceptName(pathname.getName());
    }

    public void exportData(File file, Layer layer) throws IOException {
        throw new IOException(I18n.tr("Could not export ''{0}''.", file.getName()));
    }

    public void exportDataQuiet(File file, Layer layer) throws IOException {
        this.exportData(file, layer);
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

