/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class RelationMemberConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = RelationMemberConflictResolverModel.class.getName() + ".numConflicts";
    protected final transient List<RelationMemberConflictDecision> decisions = new ArrayList<RelationMemberConflictDecision>();
    protected transient Collection<Relation> relations;
    protected transient Collection<? extends OsmPrimitive> primitives;
    private int numConflicts;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    protected void updateNumConflicts() {
        int oldValue = this.numConflicts;
        this.numConflicts = (int)this.decisions.stream().filter(decision -> !decision.isDecided()).count();
        if (this.numConflicts != oldValue) {
            this.support.firePropertyChange(this.getProperty(), oldValue, this.numConflicts);
        }
    }

    protected String getProperty() {
        return NUM_CONFLICTS_PROP;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public int getRowCount() {
        return this.getNumDecisions();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.decisions == null) {
            return null;
        }
        RelationMemberConflictDecision d = this.decisions.get(row);
        switch (column) {
            case 0: {
                return d.getRelation();
            }
            case 1: {
                return Integer.toString(d.getPos() + 1);
            }
            case 2: {
                return d.getRole();
            }
            case 3: {
                return d.getOriginalPrimitive();
            }
            case 4: {
                return RelationMemberConflictDecisionType.KEEP.equals((Object)d.getDecision());
            }
            case 5: {
                return RelationMemberConflictDecisionType.REMOVE.equals((Object)d.getDecision());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        RelationMemberConflictDecision d = this.decisions.get(row);
        switch (column) {
            case 2: {
                d.setRole((String)value);
                break;
            }
            case 4: {
                if (!Boolean.TRUE.equals(value)) break;
                d.decide(RelationMemberConflictDecisionType.KEEP);
                this.refresh(false);
                break;
            }
            case 5: {
                if (!Boolean.TRUE.equals(value)) break;
                d.decide(RelationMemberConflictDecisionType.REMOVE);
                this.refresh(false);
                break;
            }
        }
        this.fireTableDataChanged();
    }

    protected void populate(Relation relation, OsmPrimitive primitive) {
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (!relation.getMember(i).refersTo(primitive)) continue;
            this.decisions.add(new RelationMemberConflictDecision(relation, i));
        }
    }

    public void populate(Collection<Relation> relations, Collection<? extends OsmPrimitive> memberPrimitives) {
        this.populate(relations, memberPrimitives, true);
    }

    void populate(Collection<Relation> relations, Collection<? extends OsmPrimitive> memberPrimitives, boolean fireEvent) {
        this.decisions.clear();
        relations = relations == null ? Collections.emptyList() : relations;
        memberPrimitives = memberPrimitives == null ? new LinkedList<OsmPrimitive>() : memberPrimitives;
        for (Relation r : relations) {
            for (OsmPrimitive osmPrimitive : memberPrimitives) {
                this.populate(r, osmPrimitive);
            }
        }
        this.relations = relations;
        this.primitives = memberPrimitives;
        this.refresh(fireEvent);
    }

    public void populate(Collection<RelationToChildReference> references) {
        references = references == null ? new LinkedList() : references;
        this.decisions.clear();
        this.relations = new HashSet<Relation>(references.size());
        HashSet<? extends OsmPrimitive> primitives = new HashSet<OsmPrimitive>();
        for (RelationToChildReference reference : references) {
            this.decisions.add(new RelationMemberConflictDecision(reference.getParent(), reference.getPosition()));
            this.relations.add(reference.getParent());
            primitives.add(reference.getChild());
        }
        this.primitives = primitives;
        this.refresh();
    }

    public void prepareDefaultRelationDecisions() {
        this.prepareDefaultRelationDecisions(true);
    }

    void prepareDefaultRelationDecisions(boolean fireEvent) {
        Collection primitivesInDecisions;
        if (this.primitives.stream().allMatch(Node.class::isInstance) && (primitivesInDecisions = (Collection)this.decisions.stream().map(RelationMemberConflictDecision::getOriginalPrimitive).collect(Collectors.toSet())).size() == 1) {
            for (RelationMemberConflictDecision i : this.decisions) {
                i.decide(RelationMemberConflictDecisionType.KEEP);
            }
            this.refresh();
            return;
        }
        for (Relation relation : this.relations) {
            LinkedHashMap decisionsByPrimitive = new LinkedHashMap(this.primitives.size(), 1.0f);
            for (RelationMemberConflictDecision decision : this.decisions) {
                if (decision.getRelation() != relation) continue;
                OsmPrimitive primitive = decision.getOriginalPrimitive();
                if (!decisionsByPrimitive.containsKey(primitive)) {
                    decisionsByPrimitive.put(primitive, new ArrayList());
                }
                ((List)decisionsByPrimitive.get(primitive)).add(decision);
            }
            if (!decisionsByPrimitive.keySet().containsAll(this.primitives)) continue;
            Collection iterators = decisionsByPrimitive.values().stream().map(List::iterator).collect(Collectors.toList());
            while (iterators.stream().allMatch(Iterator::hasNext)) {
                ArrayList<RelationMemberConflictDecision> decisions = new ArrayList<RelationMemberConflictDecision>();
                HashSet<String> roles = new HashSet<String>();
                TreeSet<Integer> indices = new TreeSet<Integer>();
                for (Iterator it : iterators) {
                    RelationMemberConflictDecision decision = (RelationMemberConflictDecision)it.next();
                    decisions.add(decision);
                    roles.add(decision.getRole());
                    indices.add(decision.getPos());
                }
                if (roles.size() != 1 || !RelationMemberConflictResolverModel.isCollectionOfConsecutiveNumbers(indices)) continue;
                ((RelationMemberConflictDecision)decisions.get(0)).decide(RelationMemberConflictDecisionType.KEEP);
                for (RelationMemberConflictDecision decision : decisions.subList(1, decisions.size())) {
                    decision.decide(RelationMemberConflictDecisionType.REMOVE);
                }
            }
        }
        this.refresh(fireEvent);
    }

    static boolean isCollectionOfConsecutiveNumbers(Collection<Integer> numbers) {
        if (numbers.isEmpty()) {
            return true;
        }
        Iterator<Integer> it = numbers.iterator();
        Integer previousValue = it.next();
        while (it.hasNext()) {
            Integer i = it.next();
            if (previousValue + 1 != i) {
                return false;
            }
            previousValue = i;
        }
        return true;
    }

    public RelationMemberConflictDecision getDecision(int row) {
        return this.decisions.get(row);
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public void refresh() {
        this.refresh(true);
    }

    void refresh(boolean fireEvent) {
        this.updateNumConflicts();
        if (fireEvent) {
            GuiHelper.runInEDTAndWait(this::fireTableDataChanged);
        }
    }

    public void applyRole(String role) {
        role = role == null ? "" : role;
        for (RelationMemberConflictDecision decision : this.decisions) {
            decision.setRole(role);
        }
        this.refresh();
    }

    protected RelationMemberConflictDecision getDecision(Relation relation, int pos) {
        return this.decisions.stream().filter(decision -> decision.matches(relation, pos)).findFirst().orElse(null);
    }

    protected Command buildResolveCommand(Relation relation, OsmPrimitive newPrimitive) {
        Relation modifiedRelation = new Relation(relation);
        modifiedRelation.setMembers((List<RelationMember>)null);
        boolean isChanged = false;
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMember member = relation.getMember(i);
            RelationMemberConflictDecision decision = this.getDecision(relation, i);
            if (decision == null) {
                modifiedRelation.addMember(member);
                continue;
            }
            switch (decision.getDecision()) {
                case KEEP: {
                    RelationMember newMember = new RelationMember(decision.getRole(), newPrimitive);
                    modifiedRelation.addMember(newMember);
                    isChanged |= !member.equals(newMember);
                    continue block4;
                }
                case REMOVE: {
                    isChanged = true;
                    continue block4;
                }
            }
        }
        if (isChanged) {
            return new ChangeCommand(relation, modifiedRelation);
        }
        return null;
    }

    public List<Command> buildResolutionCommands(OsmPrimitive newPrimitive) {
        return this.relations.stream().map(relation -> this.buildResolveCommand((Relation)relation, newPrimitive)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected boolean isChanged(Relation relation, OsmPrimitive newPrimitive) {
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMemberConflictDecision decision = this.getDecision(relation, i);
            if (decision == null) continue;
            switch (decision.getDecision()) {
                case REMOVE: {
                    return true;
                }
                case KEEP: {
                    if (!relation.getMember(i).getRole().equals(decision.getRole())) {
                        return true;
                    }
                    if (relation.getMember(i).getMember() == newPrimitive) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Relation> getModifiedRelations(OsmPrimitive newPrimitive) {
        return this.relations.stream().filter(relation -> this.isChanged((Relation)relation, newPrimitive)).collect(Collectors.toSet());
    }
}

