/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.util.Objects;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PresetListEntry
implements Comparable<PresetListEntry> {
    public String value;
    public String value_context;
    public String display_value;
    public String short_description;
    public String icon;
    public short icon_size;
    public String locale_display_value;
    public String locale_short_description;
    public short preferredWidth = (short)-1;
    public short preferredHeight = (short)-1;

    public PresetListEntry() {
    }

    public PresetListEntry(String value) {
        this.value = value;
    }

    public String getListDisplay() {
        if (this.value.equals(KeyedItem.DIFFERENT)) {
            return "<b>" + Utils.escapeReservedCharactersHTML(KeyedItem.DIFFERENT) + "</b>";
        }
        String displayValue = Utils.escapeReservedCharactersHTML(this.getDisplayValue());
        String shortDescription = this.getShortDescription(true);
        if (displayValue.isEmpty() && (shortDescription == null || shortDescription.isEmpty())) {
            return "&nbsp;";
        }
        StringBuilder res = new StringBuilder("<b>").append(displayValue).append("</b>");
        if (shortDescription != null) {
            res.append("<div style=\"width:300px; padding:0 0 5px 5px\">").append(shortDescription).append("</div>");
        }
        return res.toString();
    }

    public ImageIcon getIcon() {
        return this.icon == null ? null : TaggingPresetItem.loadImageIcon(this.icon, TaggingPresetReader.getZipIcons(), Integer.valueOf(this.icon_size));
    }

    public String getDisplayValue() {
        return Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value));
    }

    public String getShortDescription(boolean translated) {
        return translated ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
    }

    public String toString() {
        if (KeyedItem.DIFFERENT.equals(this.value)) {
            return KeyedItem.DIFFERENT;
        }
        String displayValue = this.getDisplayValue();
        return displayValue != null ? displayValue.replaceAll("<.*>", "") : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresetListEntry that = (PresetListEntry)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int compareTo(PresetListEntry o) {
        return AlphanumComparator.getInstance().compare(this.getDisplayValue(), o.getDisplayValue());
    }
}

