/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Argument;

public class Args {
    public static final ValueCreator FROM_STRING_CONSTRUCTOR = new ValueCreator(){

        @Override
        public Object createValue(Class<?> type2, String value) {
            Object v = null;
            try {
                Constructor<?> init = type2.getDeclaredConstructor(String.class);
                v = init.newInstance(value);
            }
            catch (NoSuchMethodException init) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to convert " + value + " to type " + type2.getName(), e);
            }
            return v;
        }
    };
    public static final ValueCreator ENUM_CREATOR = new ValueCreator(){

        public Object createValue(Class type2, String value) {
            if (Enum.class.isAssignableFrom(type2)) {
                return Enum.valueOf(type2, value);
            }
            return null;
        }
    };
    private static final List<ValueCreator> DEFAULT_VALUE_CREATORS = Arrays.asList(FROM_STRING_CONSTRUCTOR, ENUM_CREATOR);
    private static List<ValueCreator> valueCreators = new ArrayList<ValueCreator>(DEFAULT_VALUE_CREATORS);

    public static List<String> parseOrExit(Object target, String[] args) {
        try {
            return Args.parse(target, args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage(target);
            System.exit(1);
            throw e;
        }
    }

    public static List<String> parse(Object target, String[] args) {
        return Args.parse(target, args, true);
    }

    public static List<String> parse(Object target, String[] args, boolean failOnExtraFlags) {
        Class<?> clazz;
        ArrayList<String> arguments2 = new ArrayList<String>();
        arguments2.addAll(Arrays.asList(args));
        if (target instanceof Class) {
            clazz = (Class<?>)target;
        } else {
            clazz = target.getClass();
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Args.processProperty(target, pd, arguments2);
                }
            }
            catch (IntrospectionException info) {
                // empty catch block
            }
        }
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                Args.processField(target, field, arguments2);
            }
        }
        if (failOnExtraFlags) {
            for (String argument : arguments2) {
                if (!argument.startsWith("-")) continue;
                throw new IllegalArgumentException("Invalid argument: " + argument);
            }
        }
        return arguments2;
    }

    private static void processField(Object target, Field field, List<String> arguments2) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, field);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type2 = field.getType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value = Args.consumeArgumentValue(type2, argument, i);
                    if (!set) {
                        Args.setField(type2, field, target, value, delimiter);
                    } else {
                        Args.addArgument(type2, field, target, value, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, field);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void addArgument(Class type2, Field field, Object target, Object value, String delimiter) {
        try {
            Object[] os = (Object[])field.get(target);
            Object[] vs = (Object[])Args.getValue(type2, value, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            field.set(target, s);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static void addPropertyArgument(Class type2, PropertyDescriptor property, Object target, Object value, String delimiter) {
        try {
            Object[] os = (Object[])property.getReadMethod().invoke(target, new Object[0]);
            Object[] vs = (Object[])Args.getValue(type2, value, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            property.getWriteMethod().invoke(target, new Object[]{s});
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property);
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property, List<String> arguments2) {
        Argument argument;
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, property);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type2 = property.getPropertyType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value = Args.consumeArgumentValue(type2, argument, i);
                    if (!set) {
                        Args.setProperty(type2, property, target, value, delimiter);
                    } else {
                        Args.addPropertyArgument(type2, property, target, value, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, property);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    public static void usage(Object target) {
        Args.usage(System.err, target);
    }

    public static void usage(PrintStream errStream, Object target) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        errStream.println("Usage: " + clazz.getName());
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                Args.fieldUsage(errStream, target, field);
            }
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Args.propertyUsage(errStream, target, pd);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void fieldUsage(PrintStream errStream, Object target, Field field) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            String prefix = argument.prefix();
            String delimiter = argument.delimiter();
            String description = argument.description();
            Args.makeAccessible(field);
            try {
                Object defaultValue = field.get(target);
                Class<?> type2 = field.getType();
                Args.propertyUsage(errStream, prefix, name, alias, type2, delimiter, description, defaultValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use thie field " + field + " as an argument field", e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, Object target, PropertyDescriptor field) {
        Argument argument;
        Method writeMethod = field.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            String prefix = argument.prefix();
            String delimiter = argument.delimiter();
            String description = argument.description();
            try {
                Method readMethod = field.getReadMethod();
                Object defaultValue = readMethod == null ? null : readMethod.invoke(target, (Object[])null);
                Class<?> type2 = field.getPropertyType();
                Args.propertyUsage(errStream, prefix, name, alias, type2, delimiter, description, defaultValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use thie field " + field + " as an argument field", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not get default value for " + field, e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, String prefix, String name, String alias, Class<?> type2, String delimiter, String description, Object defaultValue) {
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        sb.append(name);
        if (alias != null) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(alias);
            sb.append(")");
        }
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            sb.append(" [flag] ");
            sb.append(description);
        } else {
            String typeName;
            sb.append(" [");
            if (type2.isArray()) {
                typeName = Args.getTypeName(type2.getComponentType());
                sb.append(typeName);
                sb.append("[");
                sb.append(delimiter);
                sb.append("]");
            } else {
                typeName = Args.getTypeName(type2);
                sb.append(typeName);
            }
            sb.append("] ");
            sb.append(description);
            if (defaultValue != null) {
                sb.append(" (");
                if (type2.isArray()) {
                    ArrayList<Object> list2 = new ArrayList<Object>();
                    int len = Array.getLength(defaultValue);
                    for (int i = 0; i < len; ++i) {
                        list2.add(Array.get(defaultValue, i));
                    }
                    sb.append(list2);
                } else {
                    sb.append(defaultValue);
                }
                sb.append(")");
            }
        }
        errStream.println(sb);
    }

    private static String getTypeName(Class<?> type2) {
        String typeName = type2.getName();
        int beginIndex = typeName.lastIndexOf(".");
        typeName = typeName.substring(beginIndex + 1);
        return typeName;
    }

    static String getName(Argument argument, PropertyDescriptor property) {
        String name = argument.value();
        if (name.equals("")) {
            name = property.getName();
        }
        return name;
    }

    private static Object consumeArgumentValue(Class<?> type2, Argument argument, Iterator<String> i) {
        Object value;
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            value = true;
        } else if (i.hasNext()) {
            value = i.next();
            i.remove();
        } else {
            throw new IllegalArgumentException("Must have a value for non-boolean argument " + argument.value());
        }
        return value;
    }

    static void setProperty(Class<?> type2, PropertyDescriptor property, Object target, Object value, String delimiter) {
        try {
            value = Args.getValue(type2, value, delimiter);
            property.getWriteMethod().invoke(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property);
        }
    }

    static String getAlias(Argument argument) {
        String alias = argument.alias();
        if (alias.equals("")) {
            alias = null;
        }
        return alias;
    }

    static String getName(Argument argument, Field field) {
        String name = argument.value();
        if (name.equals("")) {
            name = field.getName();
        }
        return name;
    }

    static void setField(Class<?> type2, Field field, Object target, Object value, String delimiter) {
        Args.makeAccessible(field);
        try {
            value = Args.getValue(type2, value, delimiter);
            field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static Object getValue(Class<?> type2, Object value, String delimiter) throws NoSuchMethodException {
        if (type2 != String.class && type2 != Boolean.class && type2 != Boolean.TYPE) {
            String string = (String)value;
            if (type2.isArray()) {
                String[] strings = string.split(delimiter);
                if ((type2 = type2.getComponentType()) == String.class) {
                    value = strings;
                } else {
                    Object[] array = (Object[])Array.newInstance(type2, strings.length);
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = Args.createValue(type2, strings[i]);
                    }
                    value = array;
                }
            } else {
                value = Args.createValue(type2, string);
            }
        }
        return value;
    }

    private static Object createValue(Class<?> type2, String valueAsString2) throws NoSuchMethodException {
        for (ValueCreator valueCreator : valueCreators) {
            Object createdValue = valueCreator.createValue(type2, valueAsString2);
            if (createdValue == null) continue;
            return createdValue;
        }
        throw new IllegalArgumentException(String.format("cannot instanciate any %s object using %s value", type2.toString(), valueAsString2));
    }

    private static void makeAccessible(AccessibleObject ao) {
        Member member;
        if (ao instanceof Member && !Modifier.isPublic((member = (Member)((Object)ao)).getModifiers())) {
            ao.setAccessible(true);
        }
    }

    public static ValueCreator byStaticMethodInvocation(final Class<?> compatibleType, final String methodName) {
        return new ValueCreator(){

            @Override
            public Object createValue(Class<?> type2, String value) {
                Object v = null;
                if (compatibleType.isAssignableFrom(type2)) {
                    try {
                        Method m = type2.getMethod(methodName, String.class);
                        return m.invoke(null, value);
                    }
                    catch (NoSuchMethodException m) {
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("could not invoke %s#%s to create an obejct from %s", type2.toString(), methodName, value));
                    }
                }
                return v;
            }
        };
    }

    public static void registerValueCreator(ValueCreator vc) {
        valueCreators.add(vc);
    }

    public static void resetValueCreators() {
        valueCreators.clear();
        valueCreators.addAll(DEFAULT_VALUE_CREATORS);
    }

    public static interface ValueCreator {
        public Object createValue(Class<?> var1, String var2);
    }
}

