// This file generated by libqtelegram-code-generator.
// You can download it from: https://github.com/Aseman-Land/libqtelegram-code-generator
// DO NOT EDIT THIS FILE BY HAND -- YOUR CHANGES WILL BE OVERWRITTEN

#ifndef TELEGRAMAPI_H
#define TELEGRAMAPI_H

#include "core/abstractapi.h"
#include "core/session.h"
#include "telegram/types/types.h"
#include "secret/secretchat.h"
#include "libqtelegram_global.h"

class LIBQTELEGRAMSHARED_EXPORT TelegramApi : public AbstractApi
{
    Q_OBJECT
    friend class FileHandler;

public:
    explicit TelegramApi(Session *session, Settings *settings, CryptoUtils *crypto, QObject *parent = 0);
    virtual ~TelegramApi();

    qint64 accountRegisterDevice(qint32 token_type, const QString &token, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUnregisterDevice(qint32 token_type, const QString &token, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUpdateNotifySettings(const InputNotifyPeer &peer, const InputPeerNotifySettings &settings, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetNotifySettings(const InputNotifyPeer &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountResetNotifySettings(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUpdateProfile(const QString &first_name, const QString &last_name, const QString &about, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUpdateStatus(bool offline, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetWallPapers(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountReportPeer(const InputPeer &peer, const ReportReason &reason, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountCheckUsername(const QString &username, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUpdateUsername(const QString &username, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetPrivacy(const InputPrivacyKey &key, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountSetPrivacy(const InputPrivacyKey &key, const QList<InputPrivacyRule> &rules, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountDeleteAccount(const QString &reason, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetAccountTTL(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountSetAccountTTL(const AccountDaysTTL &ttl, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountSendChangePhoneCode(bool allow_flashcall, const QString &phone_number, bool current_number, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountChangePhone(const QString &phone_number, const QString &phone_code_hash, const QString &phone_code, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUpdateDeviceLocked(qint32 period, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetAuthorizations(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountResetAuthorization(qint64 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetPassword(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetPasswordSettings(const QByteArray &current_password_hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountUpdatePasswordSettings(const QByteArray &current_password_hash, const AccountPasswordInputSettings &new_settings, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountSendConfirmPhoneCode(bool allow_flashcall, const QString &hash, bool current_number, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountConfirmPhone(const QString &phone_code_hash, const QString &phone_code, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 accountGetTmpPassword(const QByteArray &password_hash, qint32 period, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 authCheckPhone(const QString &phone_number, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authSendCode(bool allow_flashcall, const QString &phone_number, bool current_number, qint32 api_id, const QString &api_hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authSignUp(const QString &phone_number, const QString &phone_code_hash, const QString &phone_code, const QString &first_name, const QString &last_name, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authSignIn(const QString &phone_number, const QString &phone_code_hash, const QString &phone_code, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authLogOut(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authResetAuthorizations(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authSendInvites(const QList<QString> &phone_numbers, const QString &message, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authExportAuthorization(qint32 dc_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authImportAuthorization(qint32 id, const QByteArray &bytes, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authBindTempAuthKey(qint64 perm_auth_key_id, qint64 nonce, qint32 expires_at, const QByteArray &encrypted_message, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authImportBotAuthorization(qint32 flags, qint32 api_id, const QString &api_hash, const QString &bot_auth_token, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authCheckPassword(const QByteArray &password_hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authRequestPasswordRecovery(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authRecoverPassword(const QString &code, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authResendCode(const QString &phone_number, const QString &phone_code_hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authCancelCode(const QString &phone_number, const QString &phone_code_hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 authDropTempAuthKeys(const QList<qint64> &except_auth_keys, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 botsSendCustomRequest(const QString &custom_method, const DataJSON &params, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 botsAnswerWebhookJSONQuery(qint64 query_id, const DataJSON &data, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 channelsReadHistory(const InputChannel &channel, qint32 max_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsDeleteMessages(const InputChannel &channel, const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsDeleteUserHistory(const InputChannel &channel, const InputUser &user_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsReportSpam(const InputChannel &channel, const InputUser &user_id, const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetMessages(const InputChannel &channel, const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetParticipants(const InputChannel &channel, const ChannelParticipantsFilter &filter, qint32 offset, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetParticipant(const InputChannel &channel, const InputUser &user_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetChannels(const QList<InputChannel> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetFullChannel(const InputChannel &channel, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsCreateChannel(bool broadcast, bool megagroup, const QString &title, const QString &about, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsEditAbout(const InputChannel &channel, const QString &about, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsEditAdmin(const InputChannel &channel, const InputUser &user_id, const ChannelAdminRights &admin_rights, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsEditTitle(const InputChannel &channel, const QString &title, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsEditPhoto(const InputChannel &channel, const InputChatPhoto &photo, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsCheckUsername(const InputChannel &channel, const QString &username, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsUpdateUsername(const InputChannel &channel, const QString &username, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsJoinChannel(const InputChannel &channel, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsLeaveChannel(const InputChannel &channel, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsInviteToChannel(const InputChannel &channel, const QList<InputUser> &users, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsExportInvite(const InputChannel &channel, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsDeleteChannel(const InputChannel &channel, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsToggleInvites(const InputChannel &channel, bool enabled, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsExportMessageLink(const InputChannel &channel, qint32 id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsToggleSignatures(const InputChannel &channel, bool enabled, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsUpdatePinnedMessage(bool silent, const InputChannel &channel, qint32 id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetAdminedPublicChannels(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsEditBanned(const InputChannel &channel, const InputUser &user_id, const ChannelBannedRights &banned_rights, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 channelsGetAdminLog(const InputChannel &channel, const QString &q, const ChannelAdminLogEventsFilter &events_filter, const QList<InputUser> &admins, qint64 max_id, qint64 min_id, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 contactsGetStatuses(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsGetContacts(const QString &hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsImportContacts(const QList<InputContact> &contacts, bool replace, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsDeleteContact(const InputUser &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsDeleteContacts(const QList<InputUser> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsBlock(const InputUser &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsUnblock(const InputUser &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsGetBlocked(qint32 offset, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsExportCard(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsImportCard(const QList<qint32> &export_card, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsSearch(const QString &q, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsResolveUsername(const QString &username, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsGetTopPeers(bool correspondents, bool bots_pm, bool bots_inline, bool phone_calls, bool groups, bool channels, qint32 offset, qint32 limit, qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 contactsResetTopPeerRating(const TopPeerCategory &category, const InputPeer &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 helpGetConfig(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetNearestDc(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetAppUpdate(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpSaveAppLog(const QList<InputAppEvent> &events, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetInviteText(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetSupport(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetAppChangelog(const QString &prev_app_version, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetTermsOfService(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpSetBotUpdatesStatus(qint32 pending_updates_count, const QString &message, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 helpGetCdnConfig(const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 langpackGetLangPack(const QString &lang_code, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 langpackGetStrings(const QString &lang_code, const QList<QString> &keys, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 langpackGetDifference(qint32 from_version, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 langpackGetLanguages(const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 messagesGetMessages(const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetDialogs(bool exclude_pinned, qint32 offset_date, qint32 offset_id, const InputPeer &offset_peer, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetHistory(const InputPeer &peer, qint32 offset_id, qint32 offset_date, qint32 add_offset, qint32 limit, qint32 max_id, qint32 min_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSearch(const InputPeer &peer, const QString &q, const InputUser &from_id, const MessagesFilter &filter, qint32 min_date, qint32 max_date, qint32 offset, qint32 max_id, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReadHistory(const InputPeer &peer, qint32 max_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesDeleteHistory(bool just_clear, const InputPeer &peer, qint32 max_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesDeleteMessages(bool revoke, const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReceivedMessages(qint32 max_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetTyping(const InputPeer &peer, const SendMessageAction &action, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSendMessage(bool no_webpage, bool silent, bool background, bool clear_draft, const InputPeer &peer, qint32 reply_to_msg_id, const QString &message, qint64 random_id, const ReplyMarkup &reply_markup, const QList<MessageEntity> &entities, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSendMedia(bool silent, bool background, bool clear_draft, const InputPeer &peer, qint32 reply_to_msg_id, const InputMedia &media, qint64 random_id, const ReplyMarkup &reply_markup, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesForwardMessages(bool silent, bool background, bool with_my_score, const InputPeer &from_peer, const QList<qint32> &id, const QList<qint64> &random_id, const InputPeer &to_peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReportSpam(const InputPeer &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesHideReportSpam(const InputPeer &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetPeerSettings(const InputPeer &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetChats(const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetFullChat(qint32 chat_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesEditChatTitle(qint32 chat_id, const QString &title, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesEditChatPhoto(qint32 chat_id, const InputChatPhoto &photo, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesAddChatUser(qint32 chat_id, const InputUser &user_id, qint32 fwd_limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesDeleteChatUser(qint32 chat_id, const InputUser &user_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesCreateChat(const QList<InputUser> &users, const QString &title, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesForwardMessage(const InputPeer &peer, qint32 id, qint64 random_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetDhConfig(qint32 version, qint32 random_length, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesRequestEncryption(const InputUser &user_id, qint32 random_id, const QByteArray &g_a, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesAcceptEncryption(const InputEncryptedChat &peer, const QByteArray &g_b, qint64 key_fingerprint, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesDiscardEncryption(qint32 chat_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetEncryptedTyping(const InputEncryptedChat &peer, bool typing, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReadEncryptedHistory(const InputEncryptedChat &peer, qint32 max_date, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSendEncrypted(const InputEncryptedChat &peer, qint64 random_id, const QByteArray &data, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSendEncryptedFile(const InputEncryptedChat &peer, qint64 random_id, const QByteArray &data, const InputEncryptedFile &file, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSendEncryptedService(const InputEncryptedChat &peer, qint64 random_id, const QByteArray &data, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReceivedQueue(qint32 max_qts, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReportEncryptedSpam(const InputEncryptedChat &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReadMessageContents(const QList<qint32> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetAllStickers(qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetWebPagePreview(const QString &message, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesExportChatInvite(qint32 chat_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesCheckChatInvite(const QString &hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesImportChatInvite(const QString &hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetStickerSet(const InputStickerSet &stickerset, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesInstallStickerSet(const InputStickerSet &stickerset, bool archived, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesUninstallStickerSet(const InputStickerSet &stickerset, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesStartBot(const InputUser &bot, const InputPeer &peer, qint64 random_id, const QString &start_param, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetMessagesViews(const InputPeer &peer, const QList<qint32> &id, bool increment, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesToggleChatAdmins(qint32 chat_id, bool enabled, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesEditChatAdmin(qint32 chat_id, const InputUser &user_id, bool is_admin, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesMigrateChat(qint32 chat_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSearchGlobal(const QString &q, qint32 offset_date, const InputPeer &offset_peer, qint32 offset_id, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReorderStickerSets(bool masks, const QList<qint64> &order, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetDocumentByHash(const QByteArray &sha256, qint32 size, const QString &mime_type, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSearchGifs(const QString &q, qint32 offset, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetSavedGifs(qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSaveGif(const InputDocument &id, bool unsave, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetInlineBotResults(const InputUser &bot, const InputPeer &peer, const InputGeoPoint &geo_point, const QString &query, const QString &offset, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetInlineBotResults(bool gallery, bool privateValue, qint64 query_id, const QList<InputBotInlineResult> &results, qint32 cache_time, const QString &next_offset, const InlineBotSwitchPM &switch_pm, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSendInlineBotResult(bool silent, bool background, bool clear_draft, const InputPeer &peer, qint32 reply_to_msg_id, qint64 random_id, qint64 query_id, const QString &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetMessageEditData(const InputPeer &peer, qint32 id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesEditMessage(bool no_webpage, const InputPeer &peer, qint32 id, const QString &message, const ReplyMarkup &reply_markup, const QList<MessageEntity> &entities, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesEditInlineBotMessage(bool no_webpage, const InputBotInlineMessageID &id, const QString &message, const ReplyMarkup &reply_markup, const QList<MessageEntity> &entities, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetBotCallbackAnswer(bool game, const InputPeer &peer, qint32 msg_id, const QByteArray &data, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetBotCallbackAnswer(bool alert, qint64 query_id, const QString &message, const QString &url, qint32 cache_time, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetPeerDialogs(const QList<InputPeer> &peers, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSaveDraft(bool no_webpage, qint32 reply_to_msg_id, const InputPeer &peer, const QString &message, const QList<MessageEntity> &entities, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetAllDrafts(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetFeaturedStickers(qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReadFeaturedStickers(const QList<qint64> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetRecentStickers(bool attached, qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSaveRecentSticker(bool attached, const InputDocument &id, bool unsave, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesClearRecentStickers(bool attached, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetArchivedStickers(bool masks, qint64 offset_id, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetMaskStickers(qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetAttachedStickers(const InputStickeredMedia &media, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetGameScore(bool edit_message, bool force, const InputPeer &peer, qint32 id, const InputUser &user_id, qint32 score, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetInlineGameScore(bool edit_message, bool force, const InputBotInlineMessageID &id, const InputUser &user_id, qint32 score, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetGameHighScores(const InputPeer &peer, qint32 id, const InputUser &user_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetInlineGameHighScores(const InputBotInlineMessageID &id, const InputUser &user_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetCommonChats(const InputUser &user_id, qint32 max_id, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetAllChats(const QList<qint32> &except_ids, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetWebPage(const QString &url, qint32 hash, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesToggleDialogPin(bool pinned, const InputPeer &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesReorderPinnedDialogs(bool force, const QList<InputPeer> &order, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesGetPinnedDialogs(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetBotShippingResults(qint64 query_id, const QString &error, const QList<ShippingOption> &shipping_options, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesSetBotPrecheckoutResults(bool success, qint64 query_id, const QString &error, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 messagesUploadMedia(const InputPeer &peer, const InputMedia &media, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 paymentsGetPaymentForm(qint32 msg_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 paymentsGetPaymentReceipt(qint32 msg_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 paymentsValidateRequestedInfo(bool save, qint32 msg_id, const PaymentRequestedInfo &info, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 paymentsSendPaymentForm(qint32 msg_id, const QString &requested_info_id, const QString &shipping_option_id, const InputPaymentCredentials &credentials, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 paymentsGetSavedInfo(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 paymentsClearSavedInfo(bool credentials, bool info, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 phoneGetCallConfig(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneRequestCall(const InputUser &user_id, qint32 random_id, const QByteArray &g_a_hash, const PhoneCallProtocol &protocol, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneAcceptCall(const InputPhoneCall &peer, const QByteArray &g_b, const PhoneCallProtocol &protocol, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneConfirmCall(const InputPhoneCall &peer, const QByteArray &g_a, qint64 key_fingerprint, const PhoneCallProtocol &protocol, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneReceivedCall(const InputPhoneCall &peer, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneDiscardCall(const InputPhoneCall &peer, qint32 duration, const PhoneCallDiscardReason &reason, qint64 connection_id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneSetCallRating(const InputPhoneCall &peer, qint32 rating, const QString &comment, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 phoneSaveCallDebug(const InputPhoneCall &peer, const DataJSON &debug, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 photosUpdateProfilePhoto(const InputPhoto &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 photosUploadProfilePhoto(const InputFile &file, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 photosDeletePhotos(const QList<InputPhoto> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 photosGetUserPhotos(const InputUser &user_id, qint32 offset, qint64 max_id, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 stickersCreateStickerSet(bool masks, const InputUser &user_id, const QString &title, const QString &short_name, const QList<InputStickerSetItem> &stickers, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 stickersRemoveStickerFromSet(const InputDocument &sticker, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 stickersChangeStickerPosition(const InputDocument &sticker, qint32 position, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 stickersAddStickerToSet(const InputStickerSet &stickerset, const InputStickerSetItem &sticker, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 updatesGetState(const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 updatesGetDifference(qint32 pts, qint32 pts_total_limit, qint32 date, qint32 qts, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 updatesGetChannelDifference(bool force, const InputChannel &channel, const ChannelMessagesFilter &filter, qint32 pts, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 uploadSaveFilePart(qint64 file_id, qint32 file_part, const QByteArray &bytes, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 uploadGetFile(const InputFileLocation &location, qint32 offset, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 uploadSaveBigFilePart(qint64 file_id, qint32 file_part, qint32 file_total_parts, const QByteArray &bytes, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 uploadGetWebFile(const InputWebFileLocation &location, qint32 offset, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 uploadGetCdnFile(const QByteArray &file_token, qint32 offset, qint32 limit, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 uploadReuploadCdnFile(const QByteArray &file_token, const QByteArray &request_token, const QVariant &attachedData = QVariant(), Session *session = 0);
    
    qint64 usersGetUsers(const QList<InputUser> &id, const QVariant &attachedData = QVariant(), Session *session = 0);
    qint64 usersGetFullUser(const InputUser &id, const QVariant &attachedData = QVariant(), Session *session = 0);

Q_SIGNALS:
    void accountRegisterDeviceAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountUnregisterDeviceAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountUpdateNotifySettingsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountGetNotifySettingsAnswer(qint64 msgId, const PeerNotifySettings &result, const QVariant &attachedData);
    void accountResetNotifySettingsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountUpdateProfileAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    void accountUpdateStatusAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountGetWallPapersAnswer(qint64 msgId, const QList<WallPaper> &result, const QVariant &attachedData);
    void accountReportPeerAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountCheckUsernameAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountUpdateUsernameAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    void accountGetPrivacyAnswer(qint64 msgId, const AccountPrivacyRules &result, const QVariant &attachedData);
    void accountSetPrivacyAnswer(qint64 msgId, const AccountPrivacyRules &result, const QVariant &attachedData);
    void accountDeleteAccountAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountGetAccountTTLAnswer(qint64 msgId, const AccountDaysTTL &result, const QVariant &attachedData);
    void accountSetAccountTTLAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountSendChangePhoneCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    void accountChangePhoneAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    void accountUpdateDeviceLockedAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountGetAuthorizationsAnswer(qint64 msgId, const AccountAuthorizations &result, const QVariant &attachedData);
    void accountResetAuthorizationAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountGetPasswordAnswer(qint64 msgId, const AccountPassword &result, const QVariant &attachedData);
    void accountGetPasswordSettingsAnswer(qint64 msgId, const AccountPasswordSettings &result, const QVariant &attachedData);
    void accountUpdatePasswordSettingsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountSendConfirmPhoneCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    void accountConfirmPhoneAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void accountGetTmpPasswordAnswer(qint64 msgId, const AccountTmpPassword &result, const QVariant &attachedData);
    
    void authCheckPhoneAnswer(qint64 msgId, const AuthCheckedPhone &result, const QVariant &attachedData);
    void authSendCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    void authSignUpAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    void authSignInAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    void authLogOutAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void authResetAuthorizationsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void authSendInvitesAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void authExportAuthorizationAnswer(qint64 msgId, const AuthExportedAuthorization &result, const QVariant &attachedData);
    void authImportAuthorizationAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    void authBindTempAuthKeyAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void authImportBotAuthorizationAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    void authCheckPasswordAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    void authRequestPasswordRecoveryAnswer(qint64 msgId, const AuthPasswordRecovery &result, const QVariant &attachedData);
    void authRecoverPasswordAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    void authResendCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    void authCancelCodeAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void authDropTempAuthKeysAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    void botsSendCustomRequestAnswer(qint64 msgId, const DataJSON &result, const QVariant &attachedData);
    void botsAnswerWebhookJSONQueryAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    void channelsReadHistoryAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void channelsDeleteMessagesAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    void channelsDeleteUserHistoryAnswer(qint64 msgId, const MessagesAffectedHistory &result, const QVariant &attachedData);
    void channelsReportSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void channelsGetMessagesAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    void channelsGetParticipantsAnswer(qint64 msgId, const ChannelsChannelParticipants &result, const QVariant &attachedData);
    void channelsGetParticipantAnswer(qint64 msgId, const ChannelsChannelParticipant &result, const QVariant &attachedData);
    void channelsGetChannelsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    void channelsGetFullChannelAnswer(qint64 msgId, const MessagesChatFull &result, const QVariant &attachedData);
    void channelsCreateChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsEditAboutAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void channelsEditAdminAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsEditTitleAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsEditPhotoAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsCheckUsernameAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void channelsUpdateUsernameAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void channelsJoinChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsLeaveChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsInviteToChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsExportInviteAnswer(qint64 msgId, const ExportedChatInvite &result, const QVariant &attachedData);
    void channelsDeleteChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsToggleInvitesAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsExportMessageLinkAnswer(qint64 msgId, const ExportedMessageLink &result, const QVariant &attachedData);
    void channelsToggleSignaturesAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsUpdatePinnedMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsGetAdminedPublicChannelsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    void channelsEditBannedAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void channelsGetAdminLogAnswer(qint64 msgId, const ChannelsAdminLogResults &result, const QVariant &attachedData);
    
    void contactsGetStatusesAnswer(qint64 msgId, const QList<ContactStatus> &result, const QVariant &attachedData);
    void contactsGetContactsAnswer(qint64 msgId, const ContactsContacts &result, const QVariant &attachedData);
    void contactsImportContactsAnswer(qint64 msgId, const ContactsImportedContacts &result, const QVariant &attachedData);
    void contactsDeleteContactAnswer(qint64 msgId, const ContactsLink &result, const QVariant &attachedData);
    void contactsDeleteContactsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void contactsBlockAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void contactsUnblockAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void contactsGetBlockedAnswer(qint64 msgId, const ContactsBlocked &result, const QVariant &attachedData);
    void contactsExportCardAnswer(qint64 msgId, const QList<qint32> &result, const QVariant &attachedData);
    void contactsImportCardAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    void contactsSearchAnswer(qint64 msgId, const ContactsFound &result, const QVariant &attachedData);
    void contactsResolveUsernameAnswer(qint64 msgId, const ContactsResolvedPeer &result, const QVariant &attachedData);
    void contactsGetTopPeersAnswer(qint64 msgId, const ContactsTopPeers &result, const QVariant &attachedData);
    void contactsResetTopPeerRatingAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    void helpGetConfigAnswer(qint64 msgId, const Config &result, const QVariant &attachedData);
    void helpGetNearestDcAnswer(qint64 msgId, const NearestDc &result, const QVariant &attachedData);
    void helpGetAppUpdateAnswer(qint64 msgId, const HelpAppUpdate &result, const QVariant &attachedData);
    void helpSaveAppLogAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void helpGetInviteTextAnswer(qint64 msgId, const HelpInviteText &result, const QVariant &attachedData);
    void helpGetSupportAnswer(qint64 msgId, const HelpSupport &result, const QVariant &attachedData);
    void helpGetAppChangelogAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void helpGetTermsOfServiceAnswer(qint64 msgId, const HelpTermsOfService &result, const QVariant &attachedData);
    void helpSetBotUpdatesStatusAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void helpGetCdnConfigAnswer(qint64 msgId, const CdnConfig &result, const QVariant &attachedData);
    
    void langpackGetLangPackAnswer(qint64 msgId, const LangPackDifference &result, const QVariant &attachedData);
    void langpackGetStringsAnswer(qint64 msgId, const QList<LangPackString> &result, const QVariant &attachedData);
    void langpackGetDifferenceAnswer(qint64 msgId, const LangPackDifference &result, const QVariant &attachedData);
    void langpackGetLanguagesAnswer(qint64 msgId, const QList<LangPackLanguage> &result, const QVariant &attachedData);
    
    void messagesGetMessagesAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    void messagesGetDialogsAnswer(qint64 msgId, const MessagesDialogs &result, const QVariant &attachedData);
    void messagesGetHistoryAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    void messagesSearchAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    void messagesReadHistoryAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    void messagesDeleteHistoryAnswer(qint64 msgId, const MessagesAffectedHistory &result, const QVariant &attachedData);
    void messagesDeleteMessagesAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    void messagesReceivedMessagesAnswer(qint64 msgId, const QList<ReceivedNotifyMessage> &result, const QVariant &attachedData);
    void messagesSetTypingAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesSendMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesSendMediaAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesForwardMessagesAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesReportSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesHideReportSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetPeerSettingsAnswer(qint64 msgId, const PeerSettings &result, const QVariant &attachedData);
    void messagesGetChatsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    void messagesGetFullChatAnswer(qint64 msgId, const MessagesChatFull &result, const QVariant &attachedData);
    void messagesEditChatTitleAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesEditChatPhotoAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesAddChatUserAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesDeleteChatUserAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesCreateChatAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesForwardMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesGetDhConfigAnswer(qint64 msgId, const MessagesDhConfig &result, const QVariant &attachedData);
    void messagesRequestEncryptionAnswer(qint64 msgId, const EncryptedChat &result, const QVariant &attachedData);
    void messagesAcceptEncryptionAnswer(qint64 msgId, const EncryptedChat &result, const QVariant &attachedData);
    void messagesDiscardEncryptionAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesSetEncryptedTypingAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesReadEncryptedHistoryAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesSendEncryptedAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result, const QVariant &attachedData);
    void messagesSendEncryptedFileAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result, const QVariant &attachedData);
    void messagesSendEncryptedServiceAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result, const QVariant &attachedData);
    void messagesReceivedQueueAnswer(qint64 msgId, const QList<qint64> &result, const QVariant &attachedData);
    void messagesReportEncryptedSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesReadMessageContentsAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    void messagesGetAllStickersAnswer(qint64 msgId, const MessagesAllStickers &result, const QVariant &attachedData);
    void messagesGetWebPagePreviewAnswer(qint64 msgId, const MessageMedia &result, const QVariant &attachedData);
    void messagesExportChatInviteAnswer(qint64 msgId, const ExportedChatInvite &result, const QVariant &attachedData);
    void messagesCheckChatInviteAnswer(qint64 msgId, const ChatInvite &result, const QVariant &attachedData);
    void messagesImportChatInviteAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesGetStickerSetAnswer(qint64 msgId, const MessagesStickerSet &result, const QVariant &attachedData);
    void messagesInstallStickerSetAnswer(qint64 msgId, const MessagesStickerSetInstallResult &result, const QVariant &attachedData);
    void messagesUninstallStickerSetAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesStartBotAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesGetMessagesViewsAnswer(qint64 msgId, const QList<qint32> &result, const QVariant &attachedData);
    void messagesToggleChatAdminsAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesEditChatAdminAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesMigrateChatAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesSearchGlobalAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    void messagesReorderStickerSetsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetDocumentByHashAnswer(qint64 msgId, const Document &result, const QVariant &attachedData);
    void messagesSearchGifsAnswer(qint64 msgId, const MessagesFoundGifs &result, const QVariant &attachedData);
    void messagesGetSavedGifsAnswer(qint64 msgId, const MessagesSavedGifs &result, const QVariant &attachedData);
    void messagesSaveGifAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetInlineBotResultsAnswer(qint64 msgId, const MessagesBotResults &result, const QVariant &attachedData);
    void messagesSetInlineBotResultsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesSendInlineBotResultAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesGetMessageEditDataAnswer(qint64 msgId, const MessagesMessageEditData &result, const QVariant &attachedData);
    void messagesEditMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesEditInlineBotMessageAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetBotCallbackAnswerAnswer(qint64 msgId, const MessagesBotCallbackAnswer &result, const QVariant &attachedData);
    void messagesSetBotCallbackAnswerAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetPeerDialogsAnswer(qint64 msgId, const MessagesPeerDialogs &result, const QVariant &attachedData);
    void messagesSaveDraftAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetAllDraftsAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesGetFeaturedStickersAnswer(qint64 msgId, const MessagesFeaturedStickers &result, const QVariant &attachedData);
    void messagesReadFeaturedStickersAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetRecentStickersAnswer(qint64 msgId, const MessagesRecentStickers &result, const QVariant &attachedData);
    void messagesSaveRecentStickerAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesClearRecentStickersAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetArchivedStickersAnswer(qint64 msgId, const MessagesArchivedStickers &result, const QVariant &attachedData);
    void messagesGetMaskStickersAnswer(qint64 msgId, const MessagesAllStickers &result, const QVariant &attachedData);
    void messagesGetAttachedStickersAnswer(qint64 msgId, const QList<StickerSetCovered> &result, const QVariant &attachedData);
    void messagesSetGameScoreAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void messagesSetInlineGameScoreAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetGameHighScoresAnswer(qint64 msgId, const MessagesHighScores &result, const QVariant &attachedData);
    void messagesGetInlineGameHighScoresAnswer(qint64 msgId, const MessagesHighScores &result, const QVariant &attachedData);
    void messagesGetCommonChatsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    void messagesGetAllChatsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    void messagesGetWebPageAnswer(qint64 msgId, const WebPage &result, const QVariant &attachedData);
    void messagesToggleDialogPinAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesReorderPinnedDialogsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesGetPinnedDialogsAnswer(qint64 msgId, const MessagesPeerDialogs &result, const QVariant &attachedData);
    void messagesSetBotShippingResultsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesSetBotPrecheckoutResultsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void messagesUploadMediaAnswer(qint64 msgId, const MessageMedia &result, const QVariant &attachedData);
    
    void paymentsGetPaymentFormAnswer(qint64 msgId, const PaymentsPaymentForm &result, const QVariant &attachedData);
    void paymentsGetPaymentReceiptAnswer(qint64 msgId, const PaymentsPaymentReceipt &result, const QVariant &attachedData);
    void paymentsValidateRequestedInfoAnswer(qint64 msgId, const PaymentsValidatedRequestedInfo &result, const QVariant &attachedData);
    void paymentsSendPaymentFormAnswer(qint64 msgId, const PaymentsPaymentResult &result, const QVariant &attachedData);
    void paymentsGetSavedInfoAnswer(qint64 msgId, const PaymentsSavedInfo &result, const QVariant &attachedData);
    void paymentsClearSavedInfoAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    void phoneGetCallConfigAnswer(qint64 msgId, const DataJSON &result, const QVariant &attachedData);
    void phoneRequestCallAnswer(qint64 msgId, const PhonePhoneCall &result, const QVariant &attachedData);
    void phoneAcceptCallAnswer(qint64 msgId, const PhonePhoneCall &result, const QVariant &attachedData);
    void phoneConfirmCallAnswer(qint64 msgId, const PhonePhoneCall &result, const QVariant &attachedData);
    void phoneReceivedCallAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void phoneDiscardCallAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void phoneSetCallRatingAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    void phoneSaveCallDebugAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    void photosUpdateProfilePhotoAnswer(qint64 msgId, const UserProfilePhoto &result, const QVariant &attachedData);
    void photosUploadProfilePhotoAnswer(qint64 msgId, const PhotosPhoto &result, const QVariant &attachedData);
    void photosDeletePhotosAnswer(qint64 msgId, const QList<qint64> &result, const QVariant &attachedData);
    void photosGetUserPhotosAnswer(qint64 msgId, const PhotosPhotos &result, const QVariant &attachedData);
    
    void stickersCreateStickerSetAnswer(qint64 msgId, const MessagesStickerSet &result, const QVariant &attachedData);
    void stickersRemoveStickerFromSetAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void stickersChangeStickerPositionAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void stickersAddStickerToSetAnswer(qint64 msgId, const MessagesStickerSet &result, const QVariant &attachedData);
    
    void updatesGetStateAnswer(qint64 msgId, const UpdatesState &result, const QVariant &attachedData);
    void updatesGetDifferenceAnswer(qint64 msgId, const UpdatesDifference &result, const QVariant &attachedData);
    void updatesGetChannelDifferenceAnswer(qint64 msgId, const UpdatesChannelDifference &result, const QVariant &attachedData);
    
    void uploadSaveFilePartAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void uploadGetFileAnswer(qint64 msgId, const UploadFile &result, const QVariant &attachedData);
    void uploadSaveBigFilePartAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    void uploadGetWebFileAnswer(qint64 msgId, const UploadWebFile &result, const QVariant &attachedData);
    void uploadGetCdnFileAnswer(qint64 msgId, const UploadCdnFile &result, const QVariant &attachedData);
    void uploadReuploadCdnFileAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    void usersGetUsersAnswer(qint64 msgId, const QList<User> &result, const QVariant &attachedData);
    void usersGetFullUserAnswer(qint64 msgId, const UserFull &result, const QVariant &attachedData);


    void accountRegisterDeviceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUnregisterDeviceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUpdateNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountResetNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUpdateProfileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUpdateStatusError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetWallPapersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountReportPeerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountCheckUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUpdateUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetPrivacyError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountSetPrivacyError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountDeleteAccountError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetAccountTTLError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountSetAccountTTLError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountSendChangePhoneCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountChangePhoneError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUpdateDeviceLockedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetAuthorizationsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountResetAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetPasswordSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountUpdatePasswordSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountSendConfirmPhoneCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountConfirmPhoneError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void accountGetTmpPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void authCheckPhoneError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authSendCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authSignUpError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authSignInError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authLogOutError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authResetAuthorizationsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authSendInvitesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authExportAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authImportAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authBindTempAuthKeyError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authImportBotAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authCheckPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authRequestPasswordRecoveryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authRecoverPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authResendCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authCancelCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void authDropTempAuthKeysError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void botsSendCustomRequestError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void botsAnswerWebhookJSONQueryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void channelsReadHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsDeleteMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsDeleteUserHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetParticipantsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetParticipantError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetChannelsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetFullChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsCreateChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsEditAboutError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsEditAdminError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsEditTitleError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsEditPhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsCheckUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsUpdateUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsJoinChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsLeaveChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsInviteToChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsExportInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsDeleteChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsToggleInvitesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsExportMessageLinkError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsToggleSignaturesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsUpdatePinnedMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetAdminedPublicChannelsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsEditBannedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void channelsGetAdminLogError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void contactsGetStatusesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsGetContactsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsImportContactsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsDeleteContactError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsDeleteContactsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsBlockError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsUnblockError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsGetBlockedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsExportCardError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsImportCardError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsSearchError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsResolveUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsGetTopPeersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void contactsResetTopPeerRatingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void helpGetConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetNearestDcError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetAppUpdateError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpSaveAppLogError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetInviteTextError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetSupportError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetAppChangelogError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetTermsOfServiceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpSetBotUpdatesStatusError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void helpGetCdnConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void langpackGetLangPackError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void langpackGetStringsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void langpackGetDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void langpackGetLanguagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void messagesGetMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSearchError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReadHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesDeleteHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesDeleteMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReceivedMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetTypingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSendMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSendMediaError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesForwardMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesHideReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetPeerSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetChatsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetFullChatError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesEditChatTitleError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesEditChatPhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesAddChatUserError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesDeleteChatUserError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesCreateChatError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesForwardMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetDhConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesRequestEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesAcceptEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesDiscardEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetEncryptedTypingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReadEncryptedHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSendEncryptedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSendEncryptedFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSendEncryptedServiceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReceivedQueueError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReportEncryptedSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReadMessageContentsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetAllStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetWebPagePreviewError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesExportChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesCheckChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesImportChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesInstallStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesUninstallStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesStartBotError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetMessagesViewsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesToggleChatAdminsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesEditChatAdminError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesMigrateChatError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSearchGlobalError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReorderStickerSetsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetDocumentByHashError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSearchGifsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetSavedGifsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSaveGifError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetInlineBotResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetInlineBotResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSendInlineBotResultError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetMessageEditDataError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesEditMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesEditInlineBotMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetBotCallbackAnswerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetBotCallbackAnswerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetPeerDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSaveDraftError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetAllDraftsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetFeaturedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReadFeaturedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetRecentStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSaveRecentStickerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesClearRecentStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetArchivedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetMaskStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetAttachedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetGameScoreError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetInlineGameScoreError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetGameHighScoresError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetInlineGameHighScoresError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetCommonChatsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetAllChatsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetWebPageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesToggleDialogPinError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesReorderPinnedDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesGetPinnedDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetBotShippingResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesSetBotPrecheckoutResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void messagesUploadMediaError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void paymentsGetPaymentFormError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void paymentsGetPaymentReceiptError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void paymentsValidateRequestedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void paymentsSendPaymentFormError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void paymentsGetSavedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void paymentsClearSavedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void phoneGetCallConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneRequestCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneAcceptCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneConfirmCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneReceivedCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneDiscardCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneSetCallRatingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void phoneSaveCallDebugError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void photosUpdateProfilePhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void photosUploadProfilePhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void photosDeletePhotosError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void photosGetUserPhotosError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void stickersCreateStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void stickersRemoveStickerFromSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void stickersChangeStickerPositionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void stickersAddStickerToSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void updatesGetStateError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void updatesGetDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void updatesGetChannelDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void uploadSaveFilePartError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void uploadGetFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void uploadSaveBigFilePartError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void uploadGetWebFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void uploadGetCdnFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void uploadReuploadCdnFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    void usersGetUsersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    void usersGetFullUserError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);

    void error(qint64 msgId, qint32 errorCode, const QString &errorText, const QString &functionName, const QVariant &attachedData, bool &accepted);

private:
    Settings *mSettings;
    CryptoUtils *mCrypto;

    QueryMethods accountRegisterDeviceMethods;
    QueryMethods accountUnregisterDeviceMethods;
    QueryMethods accountUpdateNotifySettingsMethods;
    QueryMethods accountGetNotifySettingsMethods;
    QueryMethods accountResetNotifySettingsMethods;
    QueryMethods accountUpdateProfileMethods;
    QueryMethods accountUpdateStatusMethods;
    QueryMethods accountGetWallPapersMethods;
    QueryMethods accountReportPeerMethods;
    QueryMethods accountCheckUsernameMethods;
    QueryMethods accountUpdateUsernameMethods;
    QueryMethods accountGetPrivacyMethods;
    QueryMethods accountSetPrivacyMethods;
    QueryMethods accountDeleteAccountMethods;
    QueryMethods accountGetAccountTTLMethods;
    QueryMethods accountSetAccountTTLMethods;
    QueryMethods accountSendChangePhoneCodeMethods;
    QueryMethods accountChangePhoneMethods;
    QueryMethods accountUpdateDeviceLockedMethods;
    QueryMethods accountGetAuthorizationsMethods;
    QueryMethods accountResetAuthorizationMethods;
    QueryMethods accountGetPasswordMethods;
    QueryMethods accountGetPasswordSettingsMethods;
    QueryMethods accountUpdatePasswordSettingsMethods;
    QueryMethods accountSendConfirmPhoneCodeMethods;
    QueryMethods accountConfirmPhoneMethods;
    QueryMethods accountGetTmpPasswordMethods;
    
    QueryMethods authCheckPhoneMethods;
    QueryMethods authSendCodeMethods;
    QueryMethods authSignUpMethods;
    QueryMethods authSignInMethods;
    QueryMethods authLogOutMethods;
    QueryMethods authResetAuthorizationsMethods;
    QueryMethods authSendInvitesMethods;
    QueryMethods authExportAuthorizationMethods;
    QueryMethods authImportAuthorizationMethods;
    QueryMethods authBindTempAuthKeyMethods;
    QueryMethods authImportBotAuthorizationMethods;
    QueryMethods authCheckPasswordMethods;
    QueryMethods authRequestPasswordRecoveryMethods;
    QueryMethods authRecoverPasswordMethods;
    QueryMethods authResendCodeMethods;
    QueryMethods authCancelCodeMethods;
    QueryMethods authDropTempAuthKeysMethods;
    
    QueryMethods botsSendCustomRequestMethods;
    QueryMethods botsAnswerWebhookJSONQueryMethods;
    
    QueryMethods channelsReadHistoryMethods;
    QueryMethods channelsDeleteMessagesMethods;
    QueryMethods channelsDeleteUserHistoryMethods;
    QueryMethods channelsReportSpamMethods;
    QueryMethods channelsGetMessagesMethods;
    QueryMethods channelsGetParticipantsMethods;
    QueryMethods channelsGetParticipantMethods;
    QueryMethods channelsGetChannelsMethods;
    QueryMethods channelsGetFullChannelMethods;
    QueryMethods channelsCreateChannelMethods;
    QueryMethods channelsEditAboutMethods;
    QueryMethods channelsEditAdminMethods;
    QueryMethods channelsEditTitleMethods;
    QueryMethods channelsEditPhotoMethods;
    QueryMethods channelsCheckUsernameMethods;
    QueryMethods channelsUpdateUsernameMethods;
    QueryMethods channelsJoinChannelMethods;
    QueryMethods channelsLeaveChannelMethods;
    QueryMethods channelsInviteToChannelMethods;
    QueryMethods channelsExportInviteMethods;
    QueryMethods channelsDeleteChannelMethods;
    QueryMethods channelsToggleInvitesMethods;
    QueryMethods channelsExportMessageLinkMethods;
    QueryMethods channelsToggleSignaturesMethods;
    QueryMethods channelsUpdatePinnedMessageMethods;
    QueryMethods channelsGetAdminedPublicChannelsMethods;
    QueryMethods channelsEditBannedMethods;
    QueryMethods channelsGetAdminLogMethods;
    
    QueryMethods contactsGetStatusesMethods;
    QueryMethods contactsGetContactsMethods;
    QueryMethods contactsImportContactsMethods;
    QueryMethods contactsDeleteContactMethods;
    QueryMethods contactsDeleteContactsMethods;
    QueryMethods contactsBlockMethods;
    QueryMethods contactsUnblockMethods;
    QueryMethods contactsGetBlockedMethods;
    QueryMethods contactsExportCardMethods;
    QueryMethods contactsImportCardMethods;
    QueryMethods contactsSearchMethods;
    QueryMethods contactsResolveUsernameMethods;
    QueryMethods contactsGetTopPeersMethods;
    QueryMethods contactsResetTopPeerRatingMethods;
    
    QueryMethods helpGetConfigMethods;
    QueryMethods helpGetNearestDcMethods;
    QueryMethods helpGetAppUpdateMethods;
    QueryMethods helpSaveAppLogMethods;
    QueryMethods helpGetInviteTextMethods;
    QueryMethods helpGetSupportMethods;
    QueryMethods helpGetAppChangelogMethods;
    QueryMethods helpGetTermsOfServiceMethods;
    QueryMethods helpSetBotUpdatesStatusMethods;
    QueryMethods helpGetCdnConfigMethods;
    
    QueryMethods langpackGetLangPackMethods;
    QueryMethods langpackGetStringsMethods;
    QueryMethods langpackGetDifferenceMethods;
    QueryMethods langpackGetLanguagesMethods;
    
    QueryMethods messagesGetMessagesMethods;
    QueryMethods messagesGetDialogsMethods;
    QueryMethods messagesGetHistoryMethods;
    QueryMethods messagesSearchMethods;
    QueryMethods messagesReadHistoryMethods;
    QueryMethods messagesDeleteHistoryMethods;
    QueryMethods messagesDeleteMessagesMethods;
    QueryMethods messagesReceivedMessagesMethods;
    QueryMethods messagesSetTypingMethods;
    QueryMethods messagesSendMessageMethods;
    QueryMethods messagesSendMediaMethods;
    QueryMethods messagesForwardMessagesMethods;
    QueryMethods messagesReportSpamMethods;
    QueryMethods messagesHideReportSpamMethods;
    QueryMethods messagesGetPeerSettingsMethods;
    QueryMethods messagesGetChatsMethods;
    QueryMethods messagesGetFullChatMethods;
    QueryMethods messagesEditChatTitleMethods;
    QueryMethods messagesEditChatPhotoMethods;
    QueryMethods messagesAddChatUserMethods;
    QueryMethods messagesDeleteChatUserMethods;
    QueryMethods messagesCreateChatMethods;
    QueryMethods messagesForwardMessageMethods;
    QueryMethods messagesGetDhConfigMethods;
    QueryMethods messagesRequestEncryptionMethods;
    QueryMethods messagesAcceptEncryptionMethods;
    QueryMethods messagesDiscardEncryptionMethods;
    QueryMethods messagesSetEncryptedTypingMethods;
    QueryMethods messagesReadEncryptedHistoryMethods;
    QueryMethods messagesSendEncryptedMethods;
    QueryMethods messagesSendEncryptedFileMethods;
    QueryMethods messagesSendEncryptedServiceMethods;
    QueryMethods messagesReceivedQueueMethods;
    QueryMethods messagesReportEncryptedSpamMethods;
    QueryMethods messagesReadMessageContentsMethods;
    QueryMethods messagesGetAllStickersMethods;
    QueryMethods messagesGetWebPagePreviewMethods;
    QueryMethods messagesExportChatInviteMethods;
    QueryMethods messagesCheckChatInviteMethods;
    QueryMethods messagesImportChatInviteMethods;
    QueryMethods messagesGetStickerSetMethods;
    QueryMethods messagesInstallStickerSetMethods;
    QueryMethods messagesUninstallStickerSetMethods;
    QueryMethods messagesStartBotMethods;
    QueryMethods messagesGetMessagesViewsMethods;
    QueryMethods messagesToggleChatAdminsMethods;
    QueryMethods messagesEditChatAdminMethods;
    QueryMethods messagesMigrateChatMethods;
    QueryMethods messagesSearchGlobalMethods;
    QueryMethods messagesReorderStickerSetsMethods;
    QueryMethods messagesGetDocumentByHashMethods;
    QueryMethods messagesSearchGifsMethods;
    QueryMethods messagesGetSavedGifsMethods;
    QueryMethods messagesSaveGifMethods;
    QueryMethods messagesGetInlineBotResultsMethods;
    QueryMethods messagesSetInlineBotResultsMethods;
    QueryMethods messagesSendInlineBotResultMethods;
    QueryMethods messagesGetMessageEditDataMethods;
    QueryMethods messagesEditMessageMethods;
    QueryMethods messagesEditInlineBotMessageMethods;
    QueryMethods messagesGetBotCallbackAnswerMethods;
    QueryMethods messagesSetBotCallbackAnswerMethods;
    QueryMethods messagesGetPeerDialogsMethods;
    QueryMethods messagesSaveDraftMethods;
    QueryMethods messagesGetAllDraftsMethods;
    QueryMethods messagesGetFeaturedStickersMethods;
    QueryMethods messagesReadFeaturedStickersMethods;
    QueryMethods messagesGetRecentStickersMethods;
    QueryMethods messagesSaveRecentStickerMethods;
    QueryMethods messagesClearRecentStickersMethods;
    QueryMethods messagesGetArchivedStickersMethods;
    QueryMethods messagesGetMaskStickersMethods;
    QueryMethods messagesGetAttachedStickersMethods;
    QueryMethods messagesSetGameScoreMethods;
    QueryMethods messagesSetInlineGameScoreMethods;
    QueryMethods messagesGetGameHighScoresMethods;
    QueryMethods messagesGetInlineGameHighScoresMethods;
    QueryMethods messagesGetCommonChatsMethods;
    QueryMethods messagesGetAllChatsMethods;
    QueryMethods messagesGetWebPageMethods;
    QueryMethods messagesToggleDialogPinMethods;
    QueryMethods messagesReorderPinnedDialogsMethods;
    QueryMethods messagesGetPinnedDialogsMethods;
    QueryMethods messagesSetBotShippingResultsMethods;
    QueryMethods messagesSetBotPrecheckoutResultsMethods;
    QueryMethods messagesUploadMediaMethods;
    
    QueryMethods paymentsGetPaymentFormMethods;
    QueryMethods paymentsGetPaymentReceiptMethods;
    QueryMethods paymentsValidateRequestedInfoMethods;
    QueryMethods paymentsSendPaymentFormMethods;
    QueryMethods paymentsGetSavedInfoMethods;
    QueryMethods paymentsClearSavedInfoMethods;
    
    QueryMethods phoneGetCallConfigMethods;
    QueryMethods phoneRequestCallMethods;
    QueryMethods phoneAcceptCallMethods;
    QueryMethods phoneConfirmCallMethods;
    QueryMethods phoneReceivedCallMethods;
    QueryMethods phoneDiscardCallMethods;
    QueryMethods phoneSetCallRatingMethods;
    QueryMethods phoneSaveCallDebugMethods;
    
    QueryMethods photosUpdateProfilePhotoMethods;
    QueryMethods photosUploadProfilePhotoMethods;
    QueryMethods photosDeletePhotosMethods;
    QueryMethods photosGetUserPhotosMethods;
    
    QueryMethods stickersCreateStickerSetMethods;
    QueryMethods stickersRemoveStickerFromSetMethods;
    QueryMethods stickersChangeStickerPositionMethods;
    QueryMethods stickersAddStickerToSetMethods;
    
    QueryMethods updatesGetStateMethods;
    QueryMethods updatesGetDifferenceMethods;
    QueryMethods updatesGetChannelDifferenceMethods;
    
    QueryMethods uploadSaveFilePartMethods;
    QueryMethods uploadGetFileMethods;
    QueryMethods uploadSaveBigFilePartMethods;
    QueryMethods uploadGetWebFileMethods;
    QueryMethods uploadGetCdnFileMethods;
    QueryMethods uploadReuploadCdnFileMethods;
    
    QueryMethods usersGetUsersMethods;
    QueryMethods usersGetFullUserMethods;
    
    
    void onAccountRegisterDeviceAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUnregisterDeviceAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUpdateNotifySettingsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetNotifySettingsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountResetNotifySettingsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUpdateProfileAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUpdateStatusAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetWallPapersAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountReportPeerAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountCheckUsernameAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUpdateUsernameAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetPrivacyAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountSetPrivacyAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountDeleteAccountAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetAccountTTLAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountSetAccountTTLAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountSendChangePhoneCodeAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountChangePhoneAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUpdateDeviceLockedAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetAuthorizationsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountResetAuthorizationAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetPasswordAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetPasswordSettingsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountUpdatePasswordSettingsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountSendConfirmPhoneCodeAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountConfirmPhoneAnswer(Query *q, InboundPkt &inboundPkt);
    void onAccountGetTmpPasswordAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onAuthCheckPhoneAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthSendCodeAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthSignUpAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthSignInAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthLogOutAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthResetAuthorizationsAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthSendInvitesAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthExportAuthorizationAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthImportAuthorizationAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthBindTempAuthKeyAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthImportBotAuthorizationAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthCheckPasswordAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthRequestPasswordRecoveryAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthRecoverPasswordAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthResendCodeAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthCancelCodeAnswer(Query *q, InboundPkt &inboundPkt);
    void onAuthDropTempAuthKeysAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onBotsSendCustomRequestAnswer(Query *q, InboundPkt &inboundPkt);
    void onBotsAnswerWebhookJSONQueryAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onChannelsReadHistoryAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsDeleteMessagesAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsDeleteUserHistoryAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsReportSpamAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetMessagesAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetParticipantsAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetParticipantAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetChannelsAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetFullChannelAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsCreateChannelAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsEditAboutAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsEditAdminAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsEditTitleAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsEditPhotoAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsCheckUsernameAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsUpdateUsernameAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsJoinChannelAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsLeaveChannelAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsInviteToChannelAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsExportInviteAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsDeleteChannelAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsToggleInvitesAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsExportMessageLinkAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsToggleSignaturesAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsUpdatePinnedMessageAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetAdminedPublicChannelsAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsEditBannedAnswer(Query *q, InboundPkt &inboundPkt);
    void onChannelsGetAdminLogAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onContactsGetStatusesAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsGetContactsAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsImportContactsAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsDeleteContactAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsDeleteContactsAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsBlockAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsUnblockAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsGetBlockedAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsExportCardAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsImportCardAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsSearchAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsResolveUsernameAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsGetTopPeersAnswer(Query *q, InboundPkt &inboundPkt);
    void onContactsResetTopPeerRatingAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onHelpGetConfigAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetNearestDcAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetAppUpdateAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpSaveAppLogAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetInviteTextAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetSupportAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetAppChangelogAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetTermsOfServiceAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpSetBotUpdatesStatusAnswer(Query *q, InboundPkt &inboundPkt);
    void onHelpGetCdnConfigAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onLangpackGetLangPackAnswer(Query *q, InboundPkt &inboundPkt);
    void onLangpackGetStringsAnswer(Query *q, InboundPkt &inboundPkt);
    void onLangpackGetDifferenceAnswer(Query *q, InboundPkt &inboundPkt);
    void onLangpackGetLanguagesAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onMessagesGetMessagesAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetDialogsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetHistoryAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSearchAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReadHistoryAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesDeleteHistoryAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesDeleteMessagesAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReceivedMessagesAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetTypingAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSendMessageAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSendMediaAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesForwardMessagesAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReportSpamAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesHideReportSpamAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetPeerSettingsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetChatsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetFullChatAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesEditChatTitleAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesEditChatPhotoAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesAddChatUserAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesDeleteChatUserAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesCreateChatAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesForwardMessageAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetDhConfigAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesRequestEncryptionAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesAcceptEncryptionAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesDiscardEncryptionAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetEncryptedTypingAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReadEncryptedHistoryAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSendEncryptedAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSendEncryptedFileAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSendEncryptedServiceAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReceivedQueueAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReportEncryptedSpamAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReadMessageContentsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetAllStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetWebPagePreviewAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesExportChatInviteAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesCheckChatInviteAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesImportChatInviteAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetStickerSetAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesInstallStickerSetAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesUninstallStickerSetAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesStartBotAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetMessagesViewsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesToggleChatAdminsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesEditChatAdminAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesMigrateChatAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSearchGlobalAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReorderStickerSetsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetDocumentByHashAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSearchGifsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetSavedGifsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSaveGifAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetInlineBotResultsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetInlineBotResultsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSendInlineBotResultAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetMessageEditDataAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesEditMessageAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesEditInlineBotMessageAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetBotCallbackAnswerAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetBotCallbackAnswerAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetPeerDialogsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSaveDraftAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetAllDraftsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetFeaturedStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReadFeaturedStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetRecentStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSaveRecentStickerAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesClearRecentStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetArchivedStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetMaskStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetAttachedStickersAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetGameScoreAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetInlineGameScoreAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetGameHighScoresAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetInlineGameHighScoresAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetCommonChatsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetAllChatsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetWebPageAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesToggleDialogPinAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesReorderPinnedDialogsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesGetPinnedDialogsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetBotShippingResultsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesSetBotPrecheckoutResultsAnswer(Query *q, InboundPkt &inboundPkt);
    void onMessagesUploadMediaAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onPaymentsGetPaymentFormAnswer(Query *q, InboundPkt &inboundPkt);
    void onPaymentsGetPaymentReceiptAnswer(Query *q, InboundPkt &inboundPkt);
    void onPaymentsValidateRequestedInfoAnswer(Query *q, InboundPkt &inboundPkt);
    void onPaymentsSendPaymentFormAnswer(Query *q, InboundPkt &inboundPkt);
    void onPaymentsGetSavedInfoAnswer(Query *q, InboundPkt &inboundPkt);
    void onPaymentsClearSavedInfoAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onPhoneGetCallConfigAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneRequestCallAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneAcceptCallAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneConfirmCallAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneReceivedCallAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneDiscardCallAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneSetCallRatingAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhoneSaveCallDebugAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onPhotosUpdateProfilePhotoAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhotosUploadProfilePhotoAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhotosDeletePhotosAnswer(Query *q, InboundPkt &inboundPkt);
    void onPhotosGetUserPhotosAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onStickersCreateStickerSetAnswer(Query *q, InboundPkt &inboundPkt);
    void onStickersRemoveStickerFromSetAnswer(Query *q, InboundPkt &inboundPkt);
    void onStickersChangeStickerPositionAnswer(Query *q, InboundPkt &inboundPkt);
    void onStickersAddStickerToSetAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onUpdatesGetStateAnswer(Query *q, InboundPkt &inboundPkt);
    void onUpdatesGetDifferenceAnswer(Query *q, InboundPkt &inboundPkt);
    void onUpdatesGetChannelDifferenceAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onUploadSaveFilePartAnswer(Query *q, InboundPkt &inboundPkt);
    void onUploadGetFileAnswer(Query *q, InboundPkt &inboundPkt);
    void onUploadSaveBigFilePartAnswer(Query *q, InboundPkt &inboundPkt);
    void onUploadGetWebFileAnswer(Query *q, InboundPkt &inboundPkt);
    void onUploadGetCdnFileAnswer(Query *q, InboundPkt &inboundPkt);
    void onUploadReuploadCdnFileAnswer(Query *q, InboundPkt &inboundPkt);
    
    void onUsersGetUsersAnswer(Query *q, InboundPkt &inboundPkt);
    void onUsersGetFullUserAnswer(Query *q, InboundPkt &inboundPkt);
    
    
    void onAccountRegisterDeviceError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUnregisterDeviceError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUpdateNotifySettingsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetNotifySettingsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountResetNotifySettingsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUpdateProfileError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUpdateStatusError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetWallPapersError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountReportPeerError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountCheckUsernameError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUpdateUsernameError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetPrivacyError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountSetPrivacyError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountDeleteAccountError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetAccountTTLError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountSetAccountTTLError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountSendChangePhoneCodeError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountChangePhoneError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUpdateDeviceLockedError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetAuthorizationsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountResetAuthorizationError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetPasswordError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetPasswordSettingsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountUpdatePasswordSettingsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountSendConfirmPhoneCodeError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountConfirmPhoneError(Query *q, qint32 errorCode, const QString &errorText);
    void onAccountGetTmpPasswordError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onAuthCheckPhoneError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthSendCodeError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthSignUpError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthSignInError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthLogOutError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthResetAuthorizationsError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthSendInvitesError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthExportAuthorizationError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthImportAuthorizationError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthBindTempAuthKeyError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthImportBotAuthorizationError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthCheckPasswordError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthRequestPasswordRecoveryError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthRecoverPasswordError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthResendCodeError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthCancelCodeError(Query *q, qint32 errorCode, const QString &errorText);
    void onAuthDropTempAuthKeysError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onBotsSendCustomRequestError(Query *q, qint32 errorCode, const QString &errorText);
    void onBotsAnswerWebhookJSONQueryError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onChannelsReadHistoryError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsDeleteMessagesError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsDeleteUserHistoryError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsReportSpamError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetMessagesError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetParticipantsError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetParticipantError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetChannelsError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetFullChannelError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsCreateChannelError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsEditAboutError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsEditAdminError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsEditTitleError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsEditPhotoError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsCheckUsernameError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsUpdateUsernameError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsJoinChannelError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsLeaveChannelError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsInviteToChannelError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsExportInviteError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsDeleteChannelError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsToggleInvitesError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsExportMessageLinkError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsToggleSignaturesError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsUpdatePinnedMessageError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetAdminedPublicChannelsError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsEditBannedError(Query *q, qint32 errorCode, const QString &errorText);
    void onChannelsGetAdminLogError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onContactsGetStatusesError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsGetContactsError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsImportContactsError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsDeleteContactError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsDeleteContactsError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsBlockError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsUnblockError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsGetBlockedError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsExportCardError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsImportCardError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsSearchError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsResolveUsernameError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsGetTopPeersError(Query *q, qint32 errorCode, const QString &errorText);
    void onContactsResetTopPeerRatingError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onHelpGetConfigError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetNearestDcError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetAppUpdateError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpSaveAppLogError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetInviteTextError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetSupportError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetAppChangelogError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetTermsOfServiceError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpSetBotUpdatesStatusError(Query *q, qint32 errorCode, const QString &errorText);
    void onHelpGetCdnConfigError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onLangpackGetLangPackError(Query *q, qint32 errorCode, const QString &errorText);
    void onLangpackGetStringsError(Query *q, qint32 errorCode, const QString &errorText);
    void onLangpackGetDifferenceError(Query *q, qint32 errorCode, const QString &errorText);
    void onLangpackGetLanguagesError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onMessagesGetMessagesError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetDialogsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetHistoryError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSearchError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReadHistoryError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesDeleteHistoryError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesDeleteMessagesError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReceivedMessagesError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetTypingError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSendMessageError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSendMediaError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesForwardMessagesError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReportSpamError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesHideReportSpamError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetPeerSettingsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetChatsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetFullChatError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesEditChatTitleError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesEditChatPhotoError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesAddChatUserError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesDeleteChatUserError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesCreateChatError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesForwardMessageError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetDhConfigError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesRequestEncryptionError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesAcceptEncryptionError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesDiscardEncryptionError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetEncryptedTypingError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReadEncryptedHistoryError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSendEncryptedError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSendEncryptedFileError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSendEncryptedServiceError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReceivedQueueError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReportEncryptedSpamError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReadMessageContentsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetAllStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetWebPagePreviewError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesExportChatInviteError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesCheckChatInviteError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesImportChatInviteError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetStickerSetError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesInstallStickerSetError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesUninstallStickerSetError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesStartBotError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetMessagesViewsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesToggleChatAdminsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesEditChatAdminError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesMigrateChatError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSearchGlobalError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReorderStickerSetsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetDocumentByHashError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSearchGifsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetSavedGifsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSaveGifError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetInlineBotResultsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetInlineBotResultsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSendInlineBotResultError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetMessageEditDataError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesEditMessageError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesEditInlineBotMessageError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetBotCallbackAnswerError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetBotCallbackAnswerError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetPeerDialogsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSaveDraftError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetAllDraftsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetFeaturedStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReadFeaturedStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetRecentStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSaveRecentStickerError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesClearRecentStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetArchivedStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetMaskStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetAttachedStickersError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetGameScoreError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetInlineGameScoreError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetGameHighScoresError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetInlineGameHighScoresError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetCommonChatsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetAllChatsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetWebPageError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesToggleDialogPinError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesReorderPinnedDialogsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesGetPinnedDialogsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetBotShippingResultsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesSetBotPrecheckoutResultsError(Query *q, qint32 errorCode, const QString &errorText);
    void onMessagesUploadMediaError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onPaymentsGetPaymentFormError(Query *q, qint32 errorCode, const QString &errorText);
    void onPaymentsGetPaymentReceiptError(Query *q, qint32 errorCode, const QString &errorText);
    void onPaymentsValidateRequestedInfoError(Query *q, qint32 errorCode, const QString &errorText);
    void onPaymentsSendPaymentFormError(Query *q, qint32 errorCode, const QString &errorText);
    void onPaymentsGetSavedInfoError(Query *q, qint32 errorCode, const QString &errorText);
    void onPaymentsClearSavedInfoError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onPhoneGetCallConfigError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneRequestCallError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneAcceptCallError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneConfirmCallError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneReceivedCallError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneDiscardCallError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneSetCallRatingError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhoneSaveCallDebugError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onPhotosUpdateProfilePhotoError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhotosUploadProfilePhotoError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhotosDeletePhotosError(Query *q, qint32 errorCode, const QString &errorText);
    void onPhotosGetUserPhotosError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onStickersCreateStickerSetError(Query *q, qint32 errorCode, const QString &errorText);
    void onStickersRemoveStickerFromSetError(Query *q, qint32 errorCode, const QString &errorText);
    void onStickersChangeStickerPositionError(Query *q, qint32 errorCode, const QString &errorText);
    void onStickersAddStickerToSetError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onUpdatesGetStateError(Query *q, qint32 errorCode, const QString &errorText);
    void onUpdatesGetDifferenceError(Query *q, qint32 errorCode, const QString &errorText);
    void onUpdatesGetChannelDifferenceError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onUploadSaveFilePartError(Query *q, qint32 errorCode, const QString &errorText);
    void onUploadGetFileError(Query *q, qint32 errorCode, const QString &errorText);
    void onUploadSaveBigFilePartError(Query *q, qint32 errorCode, const QString &errorText);
    void onUploadGetWebFileError(Query *q, qint32 errorCode, const QString &errorText);
    void onUploadGetCdnFileError(Query *q, qint32 errorCode, const QString &errorText);
    void onUploadReuploadCdnFileError(Query *q, qint32 errorCode, const QString &errorText);
    
    void onUsersGetUsersError(Query *q, qint32 errorCode, const QString &errorText);
    void onUsersGetFullUserError(Query *q, qint32 errorCode, const QString &errorText);

    void onError(Query *q, qint32 errorCode, const QString &errorText, const QVariant &attachedData, bool &accepted);
};

#endif // TELEGRAMAPI_H
