// This file generated by libqtelegram-code-generator.
// You can download it from: https://github.com/Aseman-Land/libqtelegram-code-generator
// DO NOT EDIT THIS FILE BY HAND -- YOUR CHANGES WILL BE OVERWRITTEN

#ifndef TELEGRAMCORE_H
#define TELEGRAMCORE_H

#include <QObject>
#include <QPointer>
#include <QTimerEvent>

#include <functional>
#include <memory>
#include <typeinfo>
#include <utility>

#include "telegramcore_globals.h"
#include "libqtelegram_global.h"

class TelegramApi;
class LIBQTELEGRAMSHARED_EXPORT TelegramCore : public QObject
{
    Q_OBJECT
public:
    TelegramCore(QObject *parent = 0);
    ~TelegramCore();

    class CallbackError {
    public:
        CallbackError() : errorCode(0), null(true) {}
        qint32 errorCode;
        QString errorText;
        bool null;
    };

    template<typename T>
    using Callback = std::function<void (qint64,T,CallbackError)>;

    static CallbackError apiError() {
        CallbackError error;
        error.errorCode = -1;
        error.errorText = "LIBQTELEGRAM_API_ERROR";
        error.null = false;
        return error;
    }

    static qint32 timeOut() { return mTimeOut; }
    static void setTimeOut(const qint32 &timeOut) { mTimeOut = timeOut; }

    QVariantHash lastArguments() const {
        return mLastArgs;
    }

    virtual void init() = 0;
    bool isConnected() const;

    virtual qint64 accountRegisterDevice(qint32 token_type, const QString &token, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUnregisterDevice(qint32 token_type, const QString &token, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUpdateNotifySettings(const InputNotifyPeer &peer, const InputPeerNotifySettings &settings, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetNotifySettings(const InputNotifyPeer &peer, Callback<PeerNotifySettings > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountResetNotifySettings(Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUpdateProfile(const QString &first_name, const QString &last_name, const QString &about, Callback<User > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUpdateStatus(bool offline, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetWallPapers(Callback<QList<WallPaper> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountReportPeer(const InputPeer &peer, const ReportReason &reason, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountCheckUsername(const QString &username, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUpdateUsername(const QString &username, Callback<User > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetPrivacy(const InputPrivacyKey &key, Callback<AccountPrivacyRules > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountSetPrivacy(const InputPrivacyKey &key, const QList<InputPrivacyRule> &rules, Callback<AccountPrivacyRules > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountDeleteAccount(const QString &reason, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetAccountTTL(Callback<AccountDaysTTL > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountSetAccountTTL(const AccountDaysTTL &ttl, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountSendChangePhoneCode(bool allow_flashcall, const QString &phone_number, bool current_number, Callback<AuthSentCode > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountChangePhone(const QString &phone_number, const QString &phone_code_hash, const QString &phone_code, Callback<User > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUpdateDeviceLocked(qint32 period, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetAuthorizations(Callback<AccountAuthorizations > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountResetAuthorization(qint64 hash, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetPassword(Callback<AccountPassword > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetPasswordSettings(const QByteArray &current_password_hash, Callback<AccountPasswordSettings > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountUpdatePasswordSettings(const QByteArray &current_password_hash, const AccountPasswordInputSettings &new_settings, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountSendConfirmPhoneCode(bool allow_flashcall, const QString &hash, bool current_number, Callback<AuthSentCode > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountConfirmPhone(const QString &phone_code_hash, const QString &phone_code, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 accountGetTmpPassword(const QByteArray &password_hash, qint32 period, Callback<AccountTmpPassword > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 authCheckPhone(const QString &phone_number, Callback<AuthCheckedPhone > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authSendCode(bool allow_flashcall, const QString &phone_number, bool current_number, qint32 api_id, const QString &api_hash, Callback<AuthSentCode > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authSignUp(const QString &phone_number, const QString &phone_code_hash, const QString &phone_code, const QString &first_name, const QString &last_name, Callback<AuthAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authSignIn(const QString &phone_number, const QString &phone_code_hash, const QString &phone_code, Callback<AuthAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authLogOut(Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authResetAuthorizations(Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authSendInvites(const QList<QString> &phone_numbers, const QString &message, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authExportAuthorization(qint32 dc_id, Callback<AuthExportedAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authImportAuthorization(qint32 id, const QByteArray &bytes, Callback<AuthAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authBindTempAuthKey(qint64 perm_auth_key_id, qint64 nonce, qint32 expires_at, const QByteArray &encrypted_message, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authImportBotAuthorization(qint32 flags, qint32 api_id, const QString &api_hash, const QString &bot_auth_token, Callback<AuthAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authCheckPassword(const QByteArray &password_hash, Callback<AuthAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authRequestPasswordRecovery(Callback<AuthPasswordRecovery > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authRecoverPassword(const QString &code, Callback<AuthAuthorization > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authResendCode(const QString &phone_number, const QString &phone_code_hash, Callback<AuthSentCode > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authCancelCode(const QString &phone_number, const QString &phone_code_hash, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 authDropTempAuthKeys(const QList<qint64> &except_auth_keys, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 botsSendCustomRequest(const QString &custom_method, const DataJSON &params, Callback<DataJSON > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 botsAnswerWebhookJSONQuery(qint64 query_id, const DataJSON &data, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 channelsReadHistory(const InputChannel &channel, qint32 max_id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsDeleteMessages(const InputChannel &channel, const QList<qint32> &id, Callback<MessagesAffectedMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsDeleteUserHistory(const InputChannel &channel, const InputUser &user_id, Callback<MessagesAffectedHistory > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsReportSpam(const InputChannel &channel, const InputUser &user_id, const QList<qint32> &id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetMessages(const InputChannel &channel, const QList<qint32> &id, Callback<MessagesMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetParticipants(const InputChannel &channel, const ChannelParticipantsFilter &filter, qint32 offset, qint32 limit, Callback<ChannelsChannelParticipants > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetParticipant(const InputChannel &channel, const InputUser &user_id, Callback<ChannelsChannelParticipant > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetChannels(const QList<InputChannel> &id, Callback<MessagesChats > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetFullChannel(const InputChannel &channel, Callback<MessagesChatFull > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsCreateChannel(bool broadcast, bool megagroup, const QString &title, const QString &about, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsEditAbout(const InputChannel &channel, const QString &about, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsEditAdmin(const InputChannel &channel, const InputUser &user_id, const ChannelAdminRights &admin_rights, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsEditTitle(const InputChannel &channel, const QString &title, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsEditPhoto(const InputChannel &channel, const InputChatPhoto &photo, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsCheckUsername(const InputChannel &channel, const QString &username, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsUpdateUsername(const InputChannel &channel, const QString &username, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsJoinChannel(const InputChannel &channel, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsLeaveChannel(const InputChannel &channel, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsInviteToChannel(const InputChannel &channel, const QList<InputUser> &users, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsExportInvite(const InputChannel &channel, Callback<ExportedChatInvite > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsDeleteChannel(const InputChannel &channel, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsToggleInvites(const InputChannel &channel, bool enabled, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsExportMessageLink(const InputChannel &channel, qint32 id, Callback<ExportedMessageLink > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsToggleSignatures(const InputChannel &channel, bool enabled, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsUpdatePinnedMessage(bool silent, const InputChannel &channel, qint32 id, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetAdminedPublicChannels(Callback<MessagesChats > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsEditBanned(const InputChannel &channel, const InputUser &user_id, const ChannelBannedRights &banned_rights, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 channelsGetAdminLog(const InputChannel &channel, const QString &q, const ChannelAdminLogEventsFilter &events_filter, const QList<InputUser> &admins, qint64 max_id, qint64 min_id, qint32 limit, Callback<ChannelsAdminLogResults > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 contactsGetStatuses(Callback<QList<ContactStatus> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsGetContacts(const QString &hash, Callback<ContactsContacts > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsImportContacts(const QList<InputContact> &contacts, bool replace, Callback<ContactsImportedContacts > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsDeleteContact(const InputUser &id, Callback<ContactsLink > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsDeleteContacts(const QList<InputUser> &id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsBlock(const InputUser &id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsUnblock(const InputUser &id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsGetBlocked(qint32 offset, qint32 limit, Callback<ContactsBlocked > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsExportCard(Callback<QList<qint32> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsImportCard(const QList<qint32> &export_card, Callback<User > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsSearch(const QString &q, qint32 limit, Callback<ContactsFound > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsResolveUsername(const QString &username, Callback<ContactsResolvedPeer > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsGetTopPeers(bool correspondents, bool bots_pm, bool bots_inline, bool phone_calls, bool groups, bool channels, qint32 offset, qint32 limit, qint32 hash, Callback<ContactsTopPeers > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 contactsResetTopPeerRating(const TopPeerCategory &category, const InputPeer &peer, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 helpGetConfig(Callback<Config > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetNearestDc(Callback<NearestDc > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetAppUpdate(Callback<HelpAppUpdate > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpSaveAppLog(const QList<InputAppEvent> &events, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetInviteText(Callback<HelpInviteText > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetSupport(Callback<HelpSupport > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetAppChangelog(const QString &prev_app_version, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetTermsOfService(Callback<HelpTermsOfService > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpSetBotUpdatesStatus(qint32 pending_updates_count, const QString &message, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 helpGetCdnConfig(Callback<CdnConfig > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 langpackGetLangPack(const QString &lang_code, Callback<LangPackDifference > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 langpackGetStrings(const QString &lang_code, const QList<QString> &keys, Callback<QList<LangPackString> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 langpackGetDifference(qint32 from_version, Callback<LangPackDifference > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 langpackGetLanguages(Callback<QList<LangPackLanguage> > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 messagesGetMessages(const QList<qint32> &id, Callback<MessagesMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetDialogs(bool exclude_pinned, qint32 offset_date, qint32 offset_id, const InputPeer &offset_peer, qint32 limit, Callback<MessagesDialogs > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetHistory(const InputPeer &peer, qint32 offset_id, qint32 offset_date, qint32 add_offset, qint32 limit, qint32 max_id, qint32 min_id, Callback<MessagesMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSearch(const InputPeer &peer, const QString &q, const InputUser &from_id, const MessagesFilter &filter, qint32 min_date, qint32 max_date, qint32 offset, qint32 max_id, qint32 limit, Callback<MessagesMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReadHistory(const InputPeer &peer, qint32 max_id, Callback<MessagesAffectedMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesDeleteHistory(bool just_clear, const InputPeer &peer, qint32 max_id, Callback<MessagesAffectedHistory > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesDeleteMessages(bool revoke, const QList<qint32> &id, Callback<MessagesAffectedMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReceivedMessages(qint32 max_id, Callback<QList<ReceivedNotifyMessage> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetTyping(const InputPeer &peer, const SendMessageAction &action, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSendMessage(bool no_webpage, bool silent, bool background, bool clear_draft, const InputPeer &peer, qint32 reply_to_msg_id, const QString &message, qint64 random_id, const ReplyMarkup &reply_markup, const QList<MessageEntity> &entities, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSendMedia(bool silent, bool background, bool clear_draft, const InputPeer &peer, qint32 reply_to_msg_id, const InputMedia &media, qint64 random_id, const ReplyMarkup &reply_markup, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesForwardMessages(bool silent, bool background, bool with_my_score, const InputPeer &from_peer, const QList<qint32> &id, const QList<qint64> &random_id, const InputPeer &to_peer, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReportSpam(const InputPeer &peer, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesHideReportSpam(const InputPeer &peer, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetPeerSettings(const InputPeer &peer, Callback<PeerSettings > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetChats(const QList<qint32> &id, Callback<MessagesChats > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetFullChat(qint32 chat_id, Callback<MessagesChatFull > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesEditChatTitle(qint32 chat_id, const QString &title, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesEditChatPhoto(qint32 chat_id, const InputChatPhoto &photo, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesAddChatUser(qint32 chat_id, const InputUser &user_id, qint32 fwd_limit, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesDeleteChatUser(qint32 chat_id, const InputUser &user_id, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesCreateChat(const QList<InputUser> &users, const QString &title, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesForwardMessage(const InputPeer &peer, qint32 id, qint64 random_id, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetDhConfig(qint32 version, qint32 random_length, Callback<MessagesDhConfig > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesRequestEncryption(const InputUser &user_id, qint32 random_id, const QByteArray &g_a, Callback<EncryptedChat > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesAcceptEncryption(const InputEncryptedChat &peer, const QByteArray &g_b, qint64 key_fingerprint, Callback<EncryptedChat > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesDiscardEncryption(qint32 chat_id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetEncryptedTyping(const InputEncryptedChat &peer, bool typing, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReadEncryptedHistory(const InputEncryptedChat &peer, qint32 max_date, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSendEncrypted(const InputEncryptedChat &peer, qint64 random_id, const QByteArray &data, Callback<MessagesSentEncryptedMessage > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSendEncryptedFile(const InputEncryptedChat &peer, qint64 random_id, const QByteArray &data, const InputEncryptedFile &file, Callback<MessagesSentEncryptedMessage > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSendEncryptedService(const InputEncryptedChat &peer, qint64 random_id, const QByteArray &data, Callback<MessagesSentEncryptedMessage > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReceivedQueue(qint32 max_qts, Callback<QList<qint64> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReportEncryptedSpam(const InputEncryptedChat &peer, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReadMessageContents(const QList<qint32> &id, Callback<MessagesAffectedMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetAllStickers(qint32 hash, Callback<MessagesAllStickers > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetWebPagePreview(const QString &message, Callback<MessageMedia > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesExportChatInvite(qint32 chat_id, Callback<ExportedChatInvite > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesCheckChatInvite(const QString &hash, Callback<ChatInvite > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesImportChatInvite(const QString &hash, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetStickerSet(const InputStickerSet &stickerset, Callback<MessagesStickerSet > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesInstallStickerSet(const InputStickerSet &stickerset, bool archived, Callback<MessagesStickerSetInstallResult > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesUninstallStickerSet(const InputStickerSet &stickerset, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesStartBot(const InputUser &bot, const InputPeer &peer, qint64 random_id, const QString &start_param, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetMessagesViews(const InputPeer &peer, const QList<qint32> &id, bool increment, Callback<QList<qint32> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesToggleChatAdmins(qint32 chat_id, bool enabled, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesEditChatAdmin(qint32 chat_id, const InputUser &user_id, bool is_admin, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesMigrateChat(qint32 chat_id, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSearchGlobal(const QString &q, qint32 offset_date, const InputPeer &offset_peer, qint32 offset_id, qint32 limit, Callback<MessagesMessages > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReorderStickerSets(bool masks, const QList<qint64> &order, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetDocumentByHash(const QByteArray &sha256, qint32 size, const QString &mime_type, Callback<Document > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSearchGifs(const QString &q, qint32 offset, Callback<MessagesFoundGifs > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetSavedGifs(qint32 hash, Callback<MessagesSavedGifs > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSaveGif(const InputDocument &id, bool unsave, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetInlineBotResults(const InputUser &bot, const InputPeer &peer, const InputGeoPoint &geo_point, const QString &query, const QString &offset, Callback<MessagesBotResults > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetInlineBotResults(bool gallery, bool privateValue, qint64 query_id, const QList<InputBotInlineResult> &results, qint32 cache_time, const QString &next_offset, const InlineBotSwitchPM &switch_pm, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSendInlineBotResult(bool silent, bool background, bool clear_draft, const InputPeer &peer, qint32 reply_to_msg_id, qint64 random_id, qint64 query_id, const QString &id, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetMessageEditData(const InputPeer &peer, qint32 id, Callback<MessagesMessageEditData > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesEditMessage(bool no_webpage, const InputPeer &peer, qint32 id, const QString &message, const ReplyMarkup &reply_markup, const QList<MessageEntity> &entities, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesEditInlineBotMessage(bool no_webpage, const InputBotInlineMessageID &id, const QString &message, const ReplyMarkup &reply_markup, const QList<MessageEntity> &entities, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetBotCallbackAnswer(bool game, const InputPeer &peer, qint32 msg_id, const QByteArray &data, Callback<MessagesBotCallbackAnswer > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetBotCallbackAnswer(bool alert, qint64 query_id, const QString &message, const QString &url, qint32 cache_time, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetPeerDialogs(const QList<InputPeer> &peers, Callback<MessagesPeerDialogs > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSaveDraft(bool no_webpage, qint32 reply_to_msg_id, const InputPeer &peer, const QString &message, const QList<MessageEntity> &entities, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetAllDrafts(Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetFeaturedStickers(qint32 hash, Callback<MessagesFeaturedStickers > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReadFeaturedStickers(const QList<qint64> &id, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetRecentStickers(bool attached, qint32 hash, Callback<MessagesRecentStickers > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSaveRecentSticker(bool attached, const InputDocument &id, bool unsave, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesClearRecentStickers(bool attached, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetArchivedStickers(bool masks, qint64 offset_id, qint32 limit, Callback<MessagesArchivedStickers > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetMaskStickers(qint32 hash, Callback<MessagesAllStickers > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetAttachedStickers(const InputStickeredMedia &media, Callback<QList<StickerSetCovered> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetGameScore(bool edit_message, bool force, const InputPeer &peer, qint32 id, const InputUser &user_id, qint32 score, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetInlineGameScore(bool edit_message, bool force, const InputBotInlineMessageID &id, const InputUser &user_id, qint32 score, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetGameHighScores(const InputPeer &peer, qint32 id, const InputUser &user_id, Callback<MessagesHighScores > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetInlineGameHighScores(const InputBotInlineMessageID &id, const InputUser &user_id, Callback<MessagesHighScores > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetCommonChats(const InputUser &user_id, qint32 max_id, qint32 limit, Callback<MessagesChats > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetAllChats(const QList<qint32> &except_ids, Callback<MessagesChats > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetWebPage(const QString &url, qint32 hash, Callback<WebPage > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesToggleDialogPin(bool pinned, const InputPeer &peer, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesReorderPinnedDialogs(bool force, const QList<InputPeer> &order, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesGetPinnedDialogs(Callback<MessagesPeerDialogs > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetBotShippingResults(qint64 query_id, const QString &error, const QList<ShippingOption> &shipping_options, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesSetBotPrecheckoutResults(bool success, qint64 query_id, const QString &error, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 messagesUploadMedia(const InputPeer &peer, const InputMedia &media, Callback<MessageMedia > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 paymentsGetPaymentForm(qint32 msg_id, Callback<PaymentsPaymentForm > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 paymentsGetPaymentReceipt(qint32 msg_id, Callback<PaymentsPaymentReceipt > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 paymentsValidateRequestedInfo(bool save, qint32 msg_id, const PaymentRequestedInfo &info, Callback<PaymentsValidatedRequestedInfo > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 paymentsSendPaymentForm(qint32 msg_id, const QString &requested_info_id, const QString &shipping_option_id, const InputPaymentCredentials &credentials, Callback<PaymentsPaymentResult > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 paymentsGetSavedInfo(Callback<PaymentsSavedInfo > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 paymentsClearSavedInfo(bool credentials, bool info, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 phoneGetCallConfig(Callback<DataJSON > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneRequestCall(const InputUser &user_id, qint32 random_id, const QByteArray &g_a_hash, const PhoneCallProtocol &protocol, Callback<PhonePhoneCall > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneAcceptCall(const InputPhoneCall &peer, const QByteArray &g_b, const PhoneCallProtocol &protocol, Callback<PhonePhoneCall > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneConfirmCall(const InputPhoneCall &peer, const QByteArray &g_a, qint64 key_fingerprint, const PhoneCallProtocol &protocol, Callback<PhonePhoneCall > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneReceivedCall(const InputPhoneCall &peer, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneDiscardCall(const InputPhoneCall &peer, qint32 duration, const PhoneCallDiscardReason &reason, qint64 connection_id, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneSetCallRating(const InputPhoneCall &peer, qint32 rating, const QString &comment, Callback<UpdatesType > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 phoneSaveCallDebug(const InputPhoneCall &peer, const DataJSON &debug, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 photosUpdateProfilePhoto(const InputPhoto &id, Callback<UserProfilePhoto > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 photosUploadProfilePhoto(const InputFile &file, Callback<PhotosPhoto > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 photosDeletePhotos(const QList<InputPhoto> &id, Callback<QList<qint64> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 photosGetUserPhotos(const InputUser &user_id, qint32 offset, qint64 max_id, qint32 limit, Callback<PhotosPhotos > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 stickersCreateStickerSet(bool masks, const InputUser &user_id, const QString &title, const QString &short_name, const QList<InputStickerSetItem> &stickers, Callback<MessagesStickerSet > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 stickersRemoveStickerFromSet(const InputDocument &sticker, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 stickersChangeStickerPosition(const InputDocument &sticker, qint32 position, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 stickersAddStickerToSet(const InputStickerSet &stickerset, const InputStickerSetItem &sticker, Callback<MessagesStickerSet > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 updatesGetState(Callback<UpdatesState > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 updatesGetDifference(qint32 pts, qint32 pts_total_limit, qint32 date, qint32 qts, Callback<UpdatesDifference > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 updatesGetChannelDifference(bool force, const InputChannel &channel, const ChannelMessagesFilter &filter, qint32 pts, qint32 limit, Callback<UpdatesChannelDifference > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 uploadSaveFilePart(qint64 file_id, qint32 file_part, const QByteArray &bytes, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 uploadGetFile(const InputFileLocation &location, qint32 offset, qint32 limit, Callback<UploadFile > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 uploadSaveBigFilePart(qint64 file_id, qint32 file_part, qint32 file_total_parts, const QByteArray &bytes, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 uploadGetWebFile(const InputWebFileLocation &location, qint32 offset, qint32 limit, Callback<UploadWebFile > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 uploadGetCdnFile(const QByteArray &file_token, qint32 offset, qint32 limit, Callback<UploadCdnFile > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 uploadReuploadCdnFile(const QByteArray &file_token, const QByteArray &request_token, Callback<bool > callBack = 0, qint32 timeout = timeOut());
    
    virtual qint64 usersGetUsers(const QList<InputUser> &id, Callback<QList<User> > callBack = 0, qint32 timeout = timeOut());
    virtual qint64 usersGetFullUser(const InputUser &id, Callback<UserFull > callBack = 0, qint32 timeout = timeOut());


Q_SIGNALS:
    void accountRegisterDeviceAnswer(qint64 msgId, bool result);
    void accountUnregisterDeviceAnswer(qint64 msgId, bool result);
    void accountUpdateNotifySettingsAnswer(qint64 msgId, bool result);
    void accountGetNotifySettingsAnswer(qint64 msgId, const PeerNotifySettings &result);
    void accountResetNotifySettingsAnswer(qint64 msgId, bool result);
    void accountUpdateProfileAnswer(qint64 msgId, const User &result);
    void accountUpdateStatusAnswer(qint64 msgId, bool result);
    void accountGetWallPapersAnswer(qint64 msgId, const QList<WallPaper> &result);
    void accountReportPeerAnswer(qint64 msgId, bool result);
    void accountCheckUsernameAnswer(qint64 msgId, bool result);
    void accountUpdateUsernameAnswer(qint64 msgId, const User &result);
    void accountGetPrivacyAnswer(qint64 msgId, const AccountPrivacyRules &result);
    void accountSetPrivacyAnswer(qint64 msgId, const AccountPrivacyRules &result);
    void accountDeleteAccountAnswer(qint64 msgId, bool result);
    void accountGetAccountTTLAnswer(qint64 msgId, const AccountDaysTTL &result);
    void accountSetAccountTTLAnswer(qint64 msgId, bool result);
    void accountSendChangePhoneCodeAnswer(qint64 msgId, const AuthSentCode &result);
    void accountChangePhoneAnswer(qint64 msgId, const User &result);
    void accountUpdateDeviceLockedAnswer(qint64 msgId, bool result);
    void accountGetAuthorizationsAnswer(qint64 msgId, const AccountAuthorizations &result);
    void accountResetAuthorizationAnswer(qint64 msgId, bool result);
    void accountGetPasswordAnswer(qint64 msgId, const AccountPassword &result);
    void accountGetPasswordSettingsAnswer(qint64 msgId, const AccountPasswordSettings &result);
    void accountUpdatePasswordSettingsAnswer(qint64 msgId, bool result);
    void accountSendConfirmPhoneCodeAnswer(qint64 msgId, const AuthSentCode &result);
    void accountConfirmPhoneAnswer(qint64 msgId, bool result);
    void accountGetTmpPasswordAnswer(qint64 msgId, const AccountTmpPassword &result);
    
    void authCheckPhoneAnswer(qint64 msgId, const AuthCheckedPhone &result);
    void authSendCodeAnswer(qint64 msgId, const AuthSentCode &result);
    void authSignUpAnswer(qint64 msgId, const AuthAuthorization &result);
    void authSignInAnswer(qint64 msgId, const AuthAuthorization &result);
    void authLogOutAnswer(qint64 msgId, bool result);
    void authResetAuthorizationsAnswer(qint64 msgId, bool result);
    void authSendInvitesAnswer(qint64 msgId, bool result);
    void authExportAuthorizationAnswer(qint64 msgId, const AuthExportedAuthorization &result);
    void authImportAuthorizationAnswer(qint64 msgId, const AuthAuthorization &result);
    void authBindTempAuthKeyAnswer(qint64 msgId, bool result);
    void authImportBotAuthorizationAnswer(qint64 msgId, const AuthAuthorization &result);
    void authCheckPasswordAnswer(qint64 msgId, const AuthAuthorization &result);
    void authRequestPasswordRecoveryAnswer(qint64 msgId, const AuthPasswordRecovery &result);
    void authRecoverPasswordAnswer(qint64 msgId, const AuthAuthorization &result);
    void authResendCodeAnswer(qint64 msgId, const AuthSentCode &result);
    void authCancelCodeAnswer(qint64 msgId, bool result);
    void authDropTempAuthKeysAnswer(qint64 msgId, bool result);
    
    void botsSendCustomRequestAnswer(qint64 msgId, const DataJSON &result);
    void botsAnswerWebhookJSONQueryAnswer(qint64 msgId, bool result);
    
    void channelsReadHistoryAnswer(qint64 msgId, bool result);
    void channelsDeleteMessagesAnswer(qint64 msgId, const MessagesAffectedMessages &result);
    void channelsDeleteUserHistoryAnswer(qint64 msgId, const MessagesAffectedHistory &result);
    void channelsReportSpamAnswer(qint64 msgId, bool result);
    void channelsGetMessagesAnswer(qint64 msgId, const MessagesMessages &result);
    void channelsGetParticipantsAnswer(qint64 msgId, const ChannelsChannelParticipants &result);
    void channelsGetParticipantAnswer(qint64 msgId, const ChannelsChannelParticipant &result);
    void channelsGetChannelsAnswer(qint64 msgId, const MessagesChats &result);
    void channelsGetFullChannelAnswer(qint64 msgId, const MessagesChatFull &result);
    void channelsCreateChannelAnswer(qint64 msgId, const UpdatesType &result);
    void channelsEditAboutAnswer(qint64 msgId, bool result);
    void channelsEditAdminAnswer(qint64 msgId, const UpdatesType &result);
    void channelsEditTitleAnswer(qint64 msgId, const UpdatesType &result);
    void channelsEditPhotoAnswer(qint64 msgId, const UpdatesType &result);
    void channelsCheckUsernameAnswer(qint64 msgId, bool result);
    void channelsUpdateUsernameAnswer(qint64 msgId, bool result);
    void channelsJoinChannelAnswer(qint64 msgId, const UpdatesType &result);
    void channelsLeaveChannelAnswer(qint64 msgId, const UpdatesType &result);
    void channelsInviteToChannelAnswer(qint64 msgId, const UpdatesType &result);
    void channelsExportInviteAnswer(qint64 msgId, const ExportedChatInvite &result);
    void channelsDeleteChannelAnswer(qint64 msgId, const UpdatesType &result);
    void channelsToggleInvitesAnswer(qint64 msgId, const UpdatesType &result);
    void channelsExportMessageLinkAnswer(qint64 msgId, const ExportedMessageLink &result);
    void channelsToggleSignaturesAnswer(qint64 msgId, const UpdatesType &result);
    void channelsUpdatePinnedMessageAnswer(qint64 msgId, const UpdatesType &result);
    void channelsGetAdminedPublicChannelsAnswer(qint64 msgId, const MessagesChats &result);
    void channelsEditBannedAnswer(qint64 msgId, const UpdatesType &result);
    void channelsGetAdminLogAnswer(qint64 msgId, const ChannelsAdminLogResults &result);
    
    void contactsGetStatusesAnswer(qint64 msgId, const QList<ContactStatus> &result);
    void contactsGetContactsAnswer(qint64 msgId, const ContactsContacts &result);
    void contactsImportContactsAnswer(qint64 msgId, const ContactsImportedContacts &result);
    void contactsDeleteContactAnswer(qint64 msgId, const ContactsLink &result);
    void contactsDeleteContactsAnswer(qint64 msgId, bool result);
    void contactsBlockAnswer(qint64 msgId, bool result);
    void contactsUnblockAnswer(qint64 msgId, bool result);
    void contactsGetBlockedAnswer(qint64 msgId, const ContactsBlocked &result);
    void contactsExportCardAnswer(qint64 msgId, const QList<qint32> &result);
    void contactsImportCardAnswer(qint64 msgId, const User &result);
    void contactsSearchAnswer(qint64 msgId, const ContactsFound &result);
    void contactsResolveUsernameAnswer(qint64 msgId, const ContactsResolvedPeer &result);
    void contactsGetTopPeersAnswer(qint64 msgId, const ContactsTopPeers &result);
    void contactsResetTopPeerRatingAnswer(qint64 msgId, bool result);
    
    void helpGetConfigAnswer(qint64 msgId, const Config &result);
    void helpGetNearestDcAnswer(qint64 msgId, const NearestDc &result);
    void helpGetAppUpdateAnswer(qint64 msgId, const HelpAppUpdate &result);
    void helpSaveAppLogAnswer(qint64 msgId, bool result);
    void helpGetInviteTextAnswer(qint64 msgId, const HelpInviteText &result);
    void helpGetSupportAnswer(qint64 msgId, const HelpSupport &result);
    void helpGetAppChangelogAnswer(qint64 msgId, const UpdatesType &result);
    void helpGetTermsOfServiceAnswer(qint64 msgId, const HelpTermsOfService &result);
    void helpSetBotUpdatesStatusAnswer(qint64 msgId, bool result);
    void helpGetCdnConfigAnswer(qint64 msgId, const CdnConfig &result);
    
    void langpackGetLangPackAnswer(qint64 msgId, const LangPackDifference &result);
    void langpackGetStringsAnswer(qint64 msgId, const QList<LangPackString> &result);
    void langpackGetDifferenceAnswer(qint64 msgId, const LangPackDifference &result);
    void langpackGetLanguagesAnswer(qint64 msgId, const QList<LangPackLanguage> &result);
    
    void messagesGetMessagesAnswer(qint64 msgId, const MessagesMessages &result);
    void messagesGetDialogsAnswer(qint64 msgId, const MessagesDialogs &result);
    void messagesGetHistoryAnswer(qint64 msgId, const MessagesMessages &result);
    void messagesSearchAnswer(qint64 msgId, const MessagesMessages &result);
    void messagesReadHistoryAnswer(qint64 msgId, const MessagesAffectedMessages &result);
    void messagesDeleteHistoryAnswer(qint64 msgId, const MessagesAffectedHistory &result);
    void messagesDeleteMessagesAnswer(qint64 msgId, const MessagesAffectedMessages &result);
    void messagesReceivedMessagesAnswer(qint64 msgId, const QList<ReceivedNotifyMessage> &result);
    void messagesSetTypingAnswer(qint64 msgId, bool result);
    void messagesSendMessageAnswer(qint64 msgId, const UpdatesType &result);
    void messagesSendMediaAnswer(qint64 msgId, const UpdatesType &result);
    void messagesForwardMessagesAnswer(qint64 msgId, const UpdatesType &result);
    void messagesReportSpamAnswer(qint64 msgId, bool result);
    void messagesHideReportSpamAnswer(qint64 msgId, bool result);
    void messagesGetPeerSettingsAnswer(qint64 msgId, const PeerSettings &result);
    void messagesGetChatsAnswer(qint64 msgId, const MessagesChats &result);
    void messagesGetFullChatAnswer(qint64 msgId, const MessagesChatFull &result);
    void messagesEditChatTitleAnswer(qint64 msgId, const UpdatesType &result);
    void messagesEditChatPhotoAnswer(qint64 msgId, const UpdatesType &result);
    void messagesAddChatUserAnswer(qint64 msgId, const UpdatesType &result);
    void messagesDeleteChatUserAnswer(qint64 msgId, const UpdatesType &result);
    void messagesCreateChatAnswer(qint64 msgId, const UpdatesType &result);
    void messagesForwardMessageAnswer(qint64 msgId, const UpdatesType &result);
    void messagesGetDhConfigAnswer(qint64 msgId, const MessagesDhConfig &result);
    void messagesRequestEncryptionAnswer(qint64 msgId, const EncryptedChat &result);
    void messagesAcceptEncryptionAnswer(qint64 msgId, const EncryptedChat &result);
    void messagesDiscardEncryptionAnswer(qint64 msgId, bool result);
    void messagesSetEncryptedTypingAnswer(qint64 msgId, bool result);
    void messagesReadEncryptedHistoryAnswer(qint64 msgId, bool result);
    void messagesSendEncryptedAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result);
    void messagesSendEncryptedFileAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result);
    void messagesSendEncryptedServiceAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result);
    void messagesReceivedQueueAnswer(qint64 msgId, const QList<qint64> &result);
    void messagesReportEncryptedSpamAnswer(qint64 msgId, bool result);
    void messagesReadMessageContentsAnswer(qint64 msgId, const MessagesAffectedMessages &result);
    void messagesGetAllStickersAnswer(qint64 msgId, const MessagesAllStickers &result);
    void messagesGetWebPagePreviewAnswer(qint64 msgId, const MessageMedia &result);
    void messagesExportChatInviteAnswer(qint64 msgId, const ExportedChatInvite &result);
    void messagesCheckChatInviteAnswer(qint64 msgId, const ChatInvite &result);
    void messagesImportChatInviteAnswer(qint64 msgId, const UpdatesType &result);
    void messagesGetStickerSetAnswer(qint64 msgId, const MessagesStickerSet &result);
    void messagesInstallStickerSetAnswer(qint64 msgId, const MessagesStickerSetInstallResult &result);
    void messagesUninstallStickerSetAnswer(qint64 msgId, bool result);
    void messagesStartBotAnswer(qint64 msgId, const UpdatesType &result);
    void messagesGetMessagesViewsAnswer(qint64 msgId, const QList<qint32> &result);
    void messagesToggleChatAdminsAnswer(qint64 msgId, const UpdatesType &result);
    void messagesEditChatAdminAnswer(qint64 msgId, bool result);
    void messagesMigrateChatAnswer(qint64 msgId, const UpdatesType &result);
    void messagesSearchGlobalAnswer(qint64 msgId, const MessagesMessages &result);
    void messagesReorderStickerSetsAnswer(qint64 msgId, bool result);
    void messagesGetDocumentByHashAnswer(qint64 msgId, const Document &result);
    void messagesSearchGifsAnswer(qint64 msgId, const MessagesFoundGifs &result);
    void messagesGetSavedGifsAnswer(qint64 msgId, const MessagesSavedGifs &result);
    void messagesSaveGifAnswer(qint64 msgId, bool result);
    void messagesGetInlineBotResultsAnswer(qint64 msgId, const MessagesBotResults &result);
    void messagesSetInlineBotResultsAnswer(qint64 msgId, bool result);
    void messagesSendInlineBotResultAnswer(qint64 msgId, const UpdatesType &result);
    void messagesGetMessageEditDataAnswer(qint64 msgId, const MessagesMessageEditData &result);
    void messagesEditMessageAnswer(qint64 msgId, const UpdatesType &result);
    void messagesEditInlineBotMessageAnswer(qint64 msgId, bool result);
    void messagesGetBotCallbackAnswerAnswer(qint64 msgId, const MessagesBotCallbackAnswer &result);
    void messagesSetBotCallbackAnswerAnswer(qint64 msgId, bool result);
    void messagesGetPeerDialogsAnswer(qint64 msgId, const MessagesPeerDialogs &result);
    void messagesSaveDraftAnswer(qint64 msgId, bool result);
    void messagesGetAllDraftsAnswer(qint64 msgId, const UpdatesType &result);
    void messagesGetFeaturedStickersAnswer(qint64 msgId, const MessagesFeaturedStickers &result);
    void messagesReadFeaturedStickersAnswer(qint64 msgId, bool result);
    void messagesGetRecentStickersAnswer(qint64 msgId, const MessagesRecentStickers &result);
    void messagesSaveRecentStickerAnswer(qint64 msgId, bool result);
    void messagesClearRecentStickersAnswer(qint64 msgId, bool result);
    void messagesGetArchivedStickersAnswer(qint64 msgId, const MessagesArchivedStickers &result);
    void messagesGetMaskStickersAnswer(qint64 msgId, const MessagesAllStickers &result);
    void messagesGetAttachedStickersAnswer(qint64 msgId, const QList<StickerSetCovered> &result);
    void messagesSetGameScoreAnswer(qint64 msgId, const UpdatesType &result);
    void messagesSetInlineGameScoreAnswer(qint64 msgId, bool result);
    void messagesGetGameHighScoresAnswer(qint64 msgId, const MessagesHighScores &result);
    void messagesGetInlineGameHighScoresAnswer(qint64 msgId, const MessagesHighScores &result);
    void messagesGetCommonChatsAnswer(qint64 msgId, const MessagesChats &result);
    void messagesGetAllChatsAnswer(qint64 msgId, const MessagesChats &result);
    void messagesGetWebPageAnswer(qint64 msgId, const WebPage &result);
    void messagesToggleDialogPinAnswer(qint64 msgId, bool result);
    void messagesReorderPinnedDialogsAnswer(qint64 msgId, bool result);
    void messagesGetPinnedDialogsAnswer(qint64 msgId, const MessagesPeerDialogs &result);
    void messagesSetBotShippingResultsAnswer(qint64 msgId, bool result);
    void messagesSetBotPrecheckoutResultsAnswer(qint64 msgId, bool result);
    void messagesUploadMediaAnswer(qint64 msgId, const MessageMedia &result);
    
    void paymentsGetPaymentFormAnswer(qint64 msgId, const PaymentsPaymentForm &result);
    void paymentsGetPaymentReceiptAnswer(qint64 msgId, const PaymentsPaymentReceipt &result);
    void paymentsValidateRequestedInfoAnswer(qint64 msgId, const PaymentsValidatedRequestedInfo &result);
    void paymentsSendPaymentFormAnswer(qint64 msgId, const PaymentsPaymentResult &result);
    void paymentsGetSavedInfoAnswer(qint64 msgId, const PaymentsSavedInfo &result);
    void paymentsClearSavedInfoAnswer(qint64 msgId, bool result);
    
    void phoneGetCallConfigAnswer(qint64 msgId, const DataJSON &result);
    void phoneRequestCallAnswer(qint64 msgId, const PhonePhoneCall &result);
    void phoneAcceptCallAnswer(qint64 msgId, const PhonePhoneCall &result);
    void phoneConfirmCallAnswer(qint64 msgId, const PhonePhoneCall &result);
    void phoneReceivedCallAnswer(qint64 msgId, bool result);
    void phoneDiscardCallAnswer(qint64 msgId, const UpdatesType &result);
    void phoneSetCallRatingAnswer(qint64 msgId, const UpdatesType &result);
    void phoneSaveCallDebugAnswer(qint64 msgId, bool result);
    
    void photosUpdateProfilePhotoAnswer(qint64 msgId, const UserProfilePhoto &result);
    void photosUploadProfilePhotoAnswer(qint64 msgId, const PhotosPhoto &result);
    void photosDeletePhotosAnswer(qint64 msgId, const QList<qint64> &result);
    void photosGetUserPhotosAnswer(qint64 msgId, const PhotosPhotos &result);
    
    void stickersCreateStickerSetAnswer(qint64 msgId, const MessagesStickerSet &result);
    void stickersRemoveStickerFromSetAnswer(qint64 msgId, bool result);
    void stickersChangeStickerPositionAnswer(qint64 msgId, bool result);
    void stickersAddStickerToSetAnswer(qint64 msgId, const MessagesStickerSet &result);
    
    void updatesGetStateAnswer(qint64 msgId, const UpdatesState &result);
    void updatesGetDifferenceAnswer(qint64 msgId, const UpdatesDifference &result);
    void updatesGetChannelDifferenceAnswer(qint64 msgId, const UpdatesChannelDifference &result);
    
    void uploadSaveFilePartAnswer(qint64 msgId, bool result);
    void uploadGetFileAnswer(qint64 msgId, const UploadFile &result);
    void uploadSaveBigFilePartAnswer(qint64 msgId, bool result);
    void uploadGetWebFileAnswer(qint64 msgId, const UploadWebFile &result);
    void uploadGetCdnFileAnswer(qint64 msgId, const UploadCdnFile &result);
    void uploadReuploadCdnFileAnswer(qint64 msgId, bool result);
    
    void usersGetUsersAnswer(qint64 msgId, const QList<User> &result);
    void usersGetFullUserAnswer(qint64 msgId, const UserFull &result);


    void accountRegisterDeviceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUnregisterDeviceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUpdateNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountResetNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUpdateProfileError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUpdateStatusError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetWallPapersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountReportPeerError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountCheckUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUpdateUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetPrivacyError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountSetPrivacyError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountDeleteAccountError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetAccountTTLError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountSetAccountTTLError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountSendChangePhoneCodeError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountChangePhoneError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUpdateDeviceLockedError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetAuthorizationsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountResetAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetPasswordSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountUpdatePasswordSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountSendConfirmPhoneCodeError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountConfirmPhoneError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void accountGetTmpPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void authCheckPhoneError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authSendCodeError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authSignUpError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authSignInError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authLogOutError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authResetAuthorizationsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authSendInvitesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authExportAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authImportAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authBindTempAuthKeyError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authImportBotAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authCheckPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authRequestPasswordRecoveryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authRecoverPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authResendCodeError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authCancelCodeError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void authDropTempAuthKeysError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void botsSendCustomRequestError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void botsAnswerWebhookJSONQueryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void channelsReadHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsDeleteMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsDeleteUserHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetParticipantsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetParticipantError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetChannelsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetFullChannelError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsCreateChannelError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsEditAboutError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsEditAdminError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsEditTitleError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsEditPhotoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsCheckUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsUpdateUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsJoinChannelError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsLeaveChannelError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsInviteToChannelError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsExportInviteError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsDeleteChannelError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsToggleInvitesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsExportMessageLinkError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsToggleSignaturesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsUpdatePinnedMessageError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetAdminedPublicChannelsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsEditBannedError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void channelsGetAdminLogError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void contactsGetStatusesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsGetContactsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsImportContactsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsDeleteContactError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsDeleteContactsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsBlockError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsUnblockError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsGetBlockedError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsExportCardError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsImportCardError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsSearchError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsResolveUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsGetTopPeersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void contactsResetTopPeerRatingError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void helpGetConfigError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetNearestDcError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetAppUpdateError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpSaveAppLogError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetInviteTextError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetSupportError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetAppChangelogError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetTermsOfServiceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpSetBotUpdatesStatusError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void helpGetCdnConfigError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void langpackGetLangPackError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void langpackGetStringsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void langpackGetDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void langpackGetLanguagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void messagesGetMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSearchError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReadHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesDeleteHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesDeleteMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReceivedMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetTypingError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSendMessageError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSendMediaError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesForwardMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesHideReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetPeerSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetChatsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetFullChatError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesEditChatTitleError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesEditChatPhotoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesAddChatUserError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesDeleteChatUserError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesCreateChatError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesForwardMessageError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetDhConfigError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesRequestEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesAcceptEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesDiscardEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetEncryptedTypingError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReadEncryptedHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSendEncryptedError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSendEncryptedFileError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSendEncryptedServiceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReceivedQueueError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReportEncryptedSpamError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReadMessageContentsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetAllStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetWebPagePreviewError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesExportChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesCheckChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesImportChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesInstallStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesUninstallStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesStartBotError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetMessagesViewsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesToggleChatAdminsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesEditChatAdminError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesMigrateChatError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSearchGlobalError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReorderStickerSetsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetDocumentByHashError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSearchGifsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetSavedGifsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSaveGifError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetInlineBotResultsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetInlineBotResultsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSendInlineBotResultError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetMessageEditDataError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesEditMessageError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesEditInlineBotMessageError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetBotCallbackAnswerError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetBotCallbackAnswerError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetPeerDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSaveDraftError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetAllDraftsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetFeaturedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReadFeaturedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetRecentStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSaveRecentStickerError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesClearRecentStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetArchivedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetMaskStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetAttachedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetGameScoreError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetInlineGameScoreError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetGameHighScoresError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetInlineGameHighScoresError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetCommonChatsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetAllChatsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetWebPageError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesToggleDialogPinError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesReorderPinnedDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesGetPinnedDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetBotShippingResultsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesSetBotPrecheckoutResultsError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void messagesUploadMediaError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void paymentsGetPaymentFormError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void paymentsGetPaymentReceiptError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void paymentsValidateRequestedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void paymentsSendPaymentFormError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void paymentsGetSavedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void paymentsClearSavedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void phoneGetCallConfigError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneRequestCallError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneAcceptCallError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneConfirmCallError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneReceivedCallError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneDiscardCallError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneSetCallRatingError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void phoneSaveCallDebugError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void photosUpdateProfilePhotoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void photosUploadProfilePhotoError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void photosDeletePhotosError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void photosGetUserPhotosError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void stickersCreateStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void stickersRemoveStickerFromSetError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void stickersChangeStickerPositionError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void stickersAddStickerToSetError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void updatesGetStateError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void updatesGetDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void updatesGetChannelDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void uploadSaveFilePartError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void uploadGetFileError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void uploadSaveBigFilePartError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void uploadGetWebFileError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void uploadGetCdnFileError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void uploadReuploadCdnFileError(qint64 msgId, qint32 errorCode, const QString &errorText);
    
    void usersGetUsersError(qint64 msgId, qint32 errorCode, const QString &errorText);
    void usersGetFullUserError(qint64 msgId, qint32 errorCode, const QString &errorText);

    void error(qint64 id, qint32 errorCode, const QString &errorText, const QString &functionName);

protected Q_SLOTS:
    virtual void onAccountRegisterDeviceAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountUnregisterDeviceAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountUpdateNotifySettingsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountGetNotifySettingsAnswer(qint64 msgId, const PeerNotifySettings &result, const QVariant &attachedData);
    virtual void onAccountResetNotifySettingsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountUpdateProfileAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    virtual void onAccountUpdateStatusAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountGetWallPapersAnswer(qint64 msgId, const QList<WallPaper> &result, const QVariant &attachedData);
    virtual void onAccountReportPeerAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountCheckUsernameAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountUpdateUsernameAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    virtual void onAccountGetPrivacyAnswer(qint64 msgId, const AccountPrivacyRules &result, const QVariant &attachedData);
    virtual void onAccountSetPrivacyAnswer(qint64 msgId, const AccountPrivacyRules &result, const QVariant &attachedData);
    virtual void onAccountDeleteAccountAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountGetAccountTTLAnswer(qint64 msgId, const AccountDaysTTL &result, const QVariant &attachedData);
    virtual void onAccountSetAccountTTLAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountSendChangePhoneCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    virtual void onAccountChangePhoneAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    virtual void onAccountUpdateDeviceLockedAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountGetAuthorizationsAnswer(qint64 msgId, const AccountAuthorizations &result, const QVariant &attachedData);
    virtual void onAccountResetAuthorizationAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountGetPasswordAnswer(qint64 msgId, const AccountPassword &result, const QVariant &attachedData);
    virtual void onAccountGetPasswordSettingsAnswer(qint64 msgId, const AccountPasswordSettings &result, const QVariant &attachedData);
    virtual void onAccountUpdatePasswordSettingsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountSendConfirmPhoneCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    virtual void onAccountConfirmPhoneAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAccountGetTmpPasswordAnswer(qint64 msgId, const AccountTmpPassword &result, const QVariant &attachedData);
    
    virtual void onAuthCheckPhoneAnswer(qint64 msgId, const AuthCheckedPhone &result, const QVariant &attachedData);
    virtual void onAuthSendCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    virtual void onAuthSignUpAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    virtual void onAuthSignInAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    virtual void onAuthLogOutAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAuthResetAuthorizationsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAuthSendInvitesAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAuthExportAuthorizationAnswer(qint64 msgId, const AuthExportedAuthorization &result, const QVariant &attachedData);
    virtual void onAuthImportAuthorizationAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    virtual void onAuthBindTempAuthKeyAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAuthImportBotAuthorizationAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    virtual void onAuthCheckPasswordAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    virtual void onAuthRequestPasswordRecoveryAnswer(qint64 msgId, const AuthPasswordRecovery &result, const QVariant &attachedData);
    virtual void onAuthRecoverPasswordAnswer(qint64 msgId, const AuthAuthorization &result, const QVariant &attachedData);
    virtual void onAuthResendCodeAnswer(qint64 msgId, const AuthSentCode &result, const QVariant &attachedData);
    virtual void onAuthCancelCodeAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onAuthDropTempAuthKeysAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    virtual void onBotsSendCustomRequestAnswer(qint64 msgId, const DataJSON &result, const QVariant &attachedData);
    virtual void onBotsAnswerWebhookJSONQueryAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    virtual void onChannelsReadHistoryAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onChannelsDeleteMessagesAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    virtual void onChannelsDeleteUserHistoryAnswer(qint64 msgId, const MessagesAffectedHistory &result, const QVariant &attachedData);
    virtual void onChannelsReportSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onChannelsGetMessagesAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    virtual void onChannelsGetParticipantsAnswer(qint64 msgId, const ChannelsChannelParticipants &result, const QVariant &attachedData);
    virtual void onChannelsGetParticipantAnswer(qint64 msgId, const ChannelsChannelParticipant &result, const QVariant &attachedData);
    virtual void onChannelsGetChannelsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    virtual void onChannelsGetFullChannelAnswer(qint64 msgId, const MessagesChatFull &result, const QVariant &attachedData);
    virtual void onChannelsCreateChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsEditAboutAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onChannelsEditAdminAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsEditTitleAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsEditPhotoAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsCheckUsernameAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onChannelsUpdateUsernameAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onChannelsJoinChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsLeaveChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsInviteToChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsExportInviteAnswer(qint64 msgId, const ExportedChatInvite &result, const QVariant &attachedData);
    virtual void onChannelsDeleteChannelAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsToggleInvitesAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsExportMessageLinkAnswer(qint64 msgId, const ExportedMessageLink &result, const QVariant &attachedData);
    virtual void onChannelsToggleSignaturesAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsUpdatePinnedMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsGetAdminedPublicChannelsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    virtual void onChannelsEditBannedAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onChannelsGetAdminLogAnswer(qint64 msgId, const ChannelsAdminLogResults &result, const QVariant &attachedData);
    
    virtual void onContactsGetStatusesAnswer(qint64 msgId, const QList<ContactStatus> &result, const QVariant &attachedData);
    virtual void onContactsGetContactsAnswer(qint64 msgId, const ContactsContacts &result, const QVariant &attachedData);
    virtual void onContactsImportContactsAnswer(qint64 msgId, const ContactsImportedContacts &result, const QVariant &attachedData);
    virtual void onContactsDeleteContactAnswer(qint64 msgId, const ContactsLink &result, const QVariant &attachedData);
    virtual void onContactsDeleteContactsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onContactsBlockAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onContactsUnblockAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onContactsGetBlockedAnswer(qint64 msgId, const ContactsBlocked &result, const QVariant &attachedData);
    virtual void onContactsExportCardAnswer(qint64 msgId, const QList<qint32> &result, const QVariant &attachedData);
    virtual void onContactsImportCardAnswer(qint64 msgId, const User &result, const QVariant &attachedData);
    virtual void onContactsSearchAnswer(qint64 msgId, const ContactsFound &result, const QVariant &attachedData);
    virtual void onContactsResolveUsernameAnswer(qint64 msgId, const ContactsResolvedPeer &result, const QVariant &attachedData);
    virtual void onContactsGetTopPeersAnswer(qint64 msgId, const ContactsTopPeers &result, const QVariant &attachedData);
    virtual void onContactsResetTopPeerRatingAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    virtual void onHelpGetConfigAnswer(qint64 msgId, const Config &result, const QVariant &attachedData);
    virtual void onHelpGetNearestDcAnswer(qint64 msgId, const NearestDc &result, const QVariant &attachedData);
    virtual void onHelpGetAppUpdateAnswer(qint64 msgId, const HelpAppUpdate &result, const QVariant &attachedData);
    virtual void onHelpSaveAppLogAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onHelpGetInviteTextAnswer(qint64 msgId, const HelpInviteText &result, const QVariant &attachedData);
    virtual void onHelpGetSupportAnswer(qint64 msgId, const HelpSupport &result, const QVariant &attachedData);
    virtual void onHelpGetAppChangelogAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onHelpGetTermsOfServiceAnswer(qint64 msgId, const HelpTermsOfService &result, const QVariant &attachedData);
    virtual void onHelpSetBotUpdatesStatusAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onHelpGetCdnConfigAnswer(qint64 msgId, const CdnConfig &result, const QVariant &attachedData);
    
    virtual void onLangpackGetLangPackAnswer(qint64 msgId, const LangPackDifference &result, const QVariant &attachedData);
    virtual void onLangpackGetStringsAnswer(qint64 msgId, const QList<LangPackString> &result, const QVariant &attachedData);
    virtual void onLangpackGetDifferenceAnswer(qint64 msgId, const LangPackDifference &result, const QVariant &attachedData);
    virtual void onLangpackGetLanguagesAnswer(qint64 msgId, const QList<LangPackLanguage> &result, const QVariant &attachedData);
    
    virtual void onMessagesGetMessagesAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    virtual void onMessagesGetDialogsAnswer(qint64 msgId, const MessagesDialogs &result, const QVariant &attachedData);
    virtual void onMessagesGetHistoryAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    virtual void onMessagesSearchAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    virtual void onMessagesReadHistoryAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    virtual void onMessagesDeleteHistoryAnswer(qint64 msgId, const MessagesAffectedHistory &result, const QVariant &attachedData);
    virtual void onMessagesDeleteMessagesAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    virtual void onMessagesReceivedMessagesAnswer(qint64 msgId, const QList<ReceivedNotifyMessage> &result, const QVariant &attachedData);
    virtual void onMessagesSetTypingAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesSendMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesSendMediaAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesForwardMessagesAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesReportSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesHideReportSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetPeerSettingsAnswer(qint64 msgId, const PeerSettings &result, const QVariant &attachedData);
    virtual void onMessagesGetChatsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    virtual void onMessagesGetFullChatAnswer(qint64 msgId, const MessagesChatFull &result, const QVariant &attachedData);
    virtual void onMessagesEditChatTitleAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesEditChatPhotoAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesAddChatUserAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesDeleteChatUserAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesCreateChatAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesForwardMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesGetDhConfigAnswer(qint64 msgId, const MessagesDhConfig &result, const QVariant &attachedData);
    virtual void onMessagesRequestEncryptionAnswer(qint64 msgId, const EncryptedChat &result, const QVariant &attachedData);
    virtual void onMessagesAcceptEncryptionAnswer(qint64 msgId, const EncryptedChat &result, const QVariant &attachedData);
    virtual void onMessagesDiscardEncryptionAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesSetEncryptedTypingAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesReadEncryptedHistoryAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesSendEncryptedAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result, const QVariant &attachedData);
    virtual void onMessagesSendEncryptedFileAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result, const QVariant &attachedData);
    virtual void onMessagesSendEncryptedServiceAnswer(qint64 msgId, const MessagesSentEncryptedMessage &result, const QVariant &attachedData);
    virtual void onMessagesReceivedQueueAnswer(qint64 msgId, const QList<qint64> &result, const QVariant &attachedData);
    virtual void onMessagesReportEncryptedSpamAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesReadMessageContentsAnswer(qint64 msgId, const MessagesAffectedMessages &result, const QVariant &attachedData);
    virtual void onMessagesGetAllStickersAnswer(qint64 msgId, const MessagesAllStickers &result, const QVariant &attachedData);
    virtual void onMessagesGetWebPagePreviewAnswer(qint64 msgId, const MessageMedia &result, const QVariant &attachedData);
    virtual void onMessagesExportChatInviteAnswer(qint64 msgId, const ExportedChatInvite &result, const QVariant &attachedData);
    virtual void onMessagesCheckChatInviteAnswer(qint64 msgId, const ChatInvite &result, const QVariant &attachedData);
    virtual void onMessagesImportChatInviteAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesGetStickerSetAnswer(qint64 msgId, const MessagesStickerSet &result, const QVariant &attachedData);
    virtual void onMessagesInstallStickerSetAnswer(qint64 msgId, const MessagesStickerSetInstallResult &result, const QVariant &attachedData);
    virtual void onMessagesUninstallStickerSetAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesStartBotAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesGetMessagesViewsAnswer(qint64 msgId, const QList<qint32> &result, const QVariant &attachedData);
    virtual void onMessagesToggleChatAdminsAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesEditChatAdminAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesMigrateChatAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesSearchGlobalAnswer(qint64 msgId, const MessagesMessages &result, const QVariant &attachedData);
    virtual void onMessagesReorderStickerSetsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetDocumentByHashAnswer(qint64 msgId, const Document &result, const QVariant &attachedData);
    virtual void onMessagesSearchGifsAnswer(qint64 msgId, const MessagesFoundGifs &result, const QVariant &attachedData);
    virtual void onMessagesGetSavedGifsAnswer(qint64 msgId, const MessagesSavedGifs &result, const QVariant &attachedData);
    virtual void onMessagesSaveGifAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetInlineBotResultsAnswer(qint64 msgId, const MessagesBotResults &result, const QVariant &attachedData);
    virtual void onMessagesSetInlineBotResultsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesSendInlineBotResultAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesGetMessageEditDataAnswer(qint64 msgId, const MessagesMessageEditData &result, const QVariant &attachedData);
    virtual void onMessagesEditMessageAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesEditInlineBotMessageAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetBotCallbackAnswerAnswer(qint64 msgId, const MessagesBotCallbackAnswer &result, const QVariant &attachedData);
    virtual void onMessagesSetBotCallbackAnswerAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetPeerDialogsAnswer(qint64 msgId, const MessagesPeerDialogs &result, const QVariant &attachedData);
    virtual void onMessagesSaveDraftAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetAllDraftsAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesGetFeaturedStickersAnswer(qint64 msgId, const MessagesFeaturedStickers &result, const QVariant &attachedData);
    virtual void onMessagesReadFeaturedStickersAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetRecentStickersAnswer(qint64 msgId, const MessagesRecentStickers &result, const QVariant &attachedData);
    virtual void onMessagesSaveRecentStickerAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesClearRecentStickersAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetArchivedStickersAnswer(qint64 msgId, const MessagesArchivedStickers &result, const QVariant &attachedData);
    virtual void onMessagesGetMaskStickersAnswer(qint64 msgId, const MessagesAllStickers &result, const QVariant &attachedData);
    virtual void onMessagesGetAttachedStickersAnswer(qint64 msgId, const QList<StickerSetCovered> &result, const QVariant &attachedData);
    virtual void onMessagesSetGameScoreAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onMessagesSetInlineGameScoreAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetGameHighScoresAnswer(qint64 msgId, const MessagesHighScores &result, const QVariant &attachedData);
    virtual void onMessagesGetInlineGameHighScoresAnswer(qint64 msgId, const MessagesHighScores &result, const QVariant &attachedData);
    virtual void onMessagesGetCommonChatsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    virtual void onMessagesGetAllChatsAnswer(qint64 msgId, const MessagesChats &result, const QVariant &attachedData);
    virtual void onMessagesGetWebPageAnswer(qint64 msgId, const WebPage &result, const QVariant &attachedData);
    virtual void onMessagesToggleDialogPinAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesReorderPinnedDialogsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesGetPinnedDialogsAnswer(qint64 msgId, const MessagesPeerDialogs &result, const QVariant &attachedData);
    virtual void onMessagesSetBotShippingResultsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesSetBotPrecheckoutResultsAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onMessagesUploadMediaAnswer(qint64 msgId, const MessageMedia &result, const QVariant &attachedData);
    
    virtual void onPaymentsGetPaymentFormAnswer(qint64 msgId, const PaymentsPaymentForm &result, const QVariant &attachedData);
    virtual void onPaymentsGetPaymentReceiptAnswer(qint64 msgId, const PaymentsPaymentReceipt &result, const QVariant &attachedData);
    virtual void onPaymentsValidateRequestedInfoAnswer(qint64 msgId, const PaymentsValidatedRequestedInfo &result, const QVariant &attachedData);
    virtual void onPaymentsSendPaymentFormAnswer(qint64 msgId, const PaymentsPaymentResult &result, const QVariant &attachedData);
    virtual void onPaymentsGetSavedInfoAnswer(qint64 msgId, const PaymentsSavedInfo &result, const QVariant &attachedData);
    virtual void onPaymentsClearSavedInfoAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    virtual void onPhoneGetCallConfigAnswer(qint64 msgId, const DataJSON &result, const QVariant &attachedData);
    virtual void onPhoneRequestCallAnswer(qint64 msgId, const PhonePhoneCall &result, const QVariant &attachedData);
    virtual void onPhoneAcceptCallAnswer(qint64 msgId, const PhonePhoneCall &result, const QVariant &attachedData);
    virtual void onPhoneConfirmCallAnswer(qint64 msgId, const PhonePhoneCall &result, const QVariant &attachedData);
    virtual void onPhoneReceivedCallAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onPhoneDiscardCallAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onPhoneSetCallRatingAnswer(qint64 msgId, const UpdatesType &result, const QVariant &attachedData);
    virtual void onPhoneSaveCallDebugAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    virtual void onPhotosUpdateProfilePhotoAnswer(qint64 msgId, const UserProfilePhoto &result, const QVariant &attachedData);
    virtual void onPhotosUploadProfilePhotoAnswer(qint64 msgId, const PhotosPhoto &result, const QVariant &attachedData);
    virtual void onPhotosDeletePhotosAnswer(qint64 msgId, const QList<qint64> &result, const QVariant &attachedData);
    virtual void onPhotosGetUserPhotosAnswer(qint64 msgId, const PhotosPhotos &result, const QVariant &attachedData);
    
    virtual void onStickersCreateStickerSetAnswer(qint64 msgId, const MessagesStickerSet &result, const QVariant &attachedData);
    virtual void onStickersRemoveStickerFromSetAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onStickersChangeStickerPositionAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onStickersAddStickerToSetAnswer(qint64 msgId, const MessagesStickerSet &result, const QVariant &attachedData);
    
    virtual void onUpdatesGetStateAnswer(qint64 msgId, const UpdatesState &result, const QVariant &attachedData);
    virtual void onUpdatesGetDifferenceAnswer(qint64 msgId, const UpdatesDifference &result, const QVariant &attachedData);
    virtual void onUpdatesGetChannelDifferenceAnswer(qint64 msgId, const UpdatesChannelDifference &result, const QVariant &attachedData);
    
    virtual void onUploadSaveFilePartAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onUploadGetFileAnswer(qint64 msgId, const UploadFile &result, const QVariant &attachedData);
    virtual void onUploadSaveBigFilePartAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    virtual void onUploadGetWebFileAnswer(qint64 msgId, const UploadWebFile &result, const QVariant &attachedData);
    virtual void onUploadGetCdnFileAnswer(qint64 msgId, const UploadCdnFile &result, const QVariant &attachedData);
    virtual void onUploadReuploadCdnFileAnswer(qint64 msgId, bool result, const QVariant &attachedData);
    
    virtual void onUsersGetUsersAnswer(qint64 msgId, const QList<User> &result, const QVariant &attachedData);
    virtual void onUsersGetFullUserAnswer(qint64 msgId, const UserFull &result, const QVariant &attachedData);
    
    
    virtual void onAccountRegisterDeviceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUnregisterDeviceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUpdateNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountResetNotifySettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUpdateProfileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUpdateStatusError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetWallPapersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountReportPeerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountCheckUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUpdateUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetPrivacyError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountSetPrivacyError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountDeleteAccountError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetAccountTTLError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountSetAccountTTLError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountSendChangePhoneCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountChangePhoneError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUpdateDeviceLockedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetAuthorizationsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountResetAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetPasswordSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountUpdatePasswordSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountSendConfirmPhoneCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountConfirmPhoneError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAccountGetTmpPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onAuthCheckPhoneError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthSendCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthSignUpError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthSignInError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthLogOutError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthResetAuthorizationsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthSendInvitesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthExportAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthImportAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthBindTempAuthKeyError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthImportBotAuthorizationError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthCheckPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthRequestPasswordRecoveryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthRecoverPasswordError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthResendCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthCancelCodeError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onAuthDropTempAuthKeysError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onBotsSendCustomRequestError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onBotsAnswerWebhookJSONQueryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onChannelsReadHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsDeleteMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsDeleteUserHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetParticipantsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetParticipantError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetChannelsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetFullChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsCreateChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsEditAboutError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsEditAdminError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsEditTitleError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsEditPhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsCheckUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsUpdateUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsJoinChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsLeaveChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsInviteToChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsExportInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsDeleteChannelError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsToggleInvitesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsExportMessageLinkError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsToggleSignaturesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsUpdatePinnedMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetAdminedPublicChannelsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsEditBannedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onChannelsGetAdminLogError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onContactsGetStatusesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsGetContactsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsImportContactsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsDeleteContactError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsDeleteContactsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsBlockError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsUnblockError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsGetBlockedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsExportCardError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsImportCardError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsSearchError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsResolveUsernameError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsGetTopPeersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onContactsResetTopPeerRatingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onHelpGetConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetNearestDcError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetAppUpdateError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpSaveAppLogError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetInviteTextError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetSupportError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetAppChangelogError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetTermsOfServiceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpSetBotUpdatesStatusError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onHelpGetCdnConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onLangpackGetLangPackError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onLangpackGetStringsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onLangpackGetDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onLangpackGetLanguagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onMessagesGetMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSearchError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReadHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesDeleteHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesDeleteMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReceivedMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetTypingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSendMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSendMediaError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesForwardMessagesError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesHideReportSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetPeerSettingsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetChatsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetFullChatError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesEditChatTitleError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesEditChatPhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesAddChatUserError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesDeleteChatUserError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesCreateChatError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesForwardMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetDhConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesRequestEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesAcceptEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesDiscardEncryptionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetEncryptedTypingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReadEncryptedHistoryError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSendEncryptedError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSendEncryptedFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSendEncryptedServiceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReceivedQueueError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReportEncryptedSpamError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReadMessageContentsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetAllStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetWebPagePreviewError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesExportChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesCheckChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesImportChatInviteError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesInstallStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesUninstallStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesStartBotError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetMessagesViewsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesToggleChatAdminsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesEditChatAdminError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesMigrateChatError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSearchGlobalError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReorderStickerSetsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetDocumentByHashError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSearchGifsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetSavedGifsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSaveGifError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetInlineBotResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetInlineBotResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSendInlineBotResultError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetMessageEditDataError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesEditMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesEditInlineBotMessageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetBotCallbackAnswerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetBotCallbackAnswerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetPeerDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSaveDraftError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetAllDraftsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetFeaturedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReadFeaturedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetRecentStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSaveRecentStickerError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesClearRecentStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetArchivedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetMaskStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetAttachedStickersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetGameScoreError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetInlineGameScoreError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetGameHighScoresError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetInlineGameHighScoresError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetCommonChatsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetAllChatsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetWebPageError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesToggleDialogPinError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesReorderPinnedDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesGetPinnedDialogsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetBotShippingResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesSetBotPrecheckoutResultsError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onMessagesUploadMediaError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onPaymentsGetPaymentFormError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPaymentsGetPaymentReceiptError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPaymentsValidateRequestedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPaymentsSendPaymentFormError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPaymentsGetSavedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPaymentsClearSavedInfoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onPhoneGetCallConfigError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneRequestCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneAcceptCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneConfirmCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneReceivedCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneDiscardCallError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneSetCallRatingError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhoneSaveCallDebugError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onPhotosUpdateProfilePhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhotosUploadProfilePhotoError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhotosDeletePhotosError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onPhotosGetUserPhotosError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onStickersCreateStickerSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onStickersRemoveStickerFromSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onStickersChangeStickerPositionError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onStickersAddStickerToSetError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onUpdatesGetStateError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUpdatesGetDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUpdatesGetChannelDifferenceError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onUploadSaveFilePartError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUploadGetFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUploadSaveBigFilePartError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUploadGetWebFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUploadGetCdnFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUploadReuploadCdnFileError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    
    virtual void onUsersGetUsersError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);
    virtual void onUsersGetFullUserError(qint64 msgId, qint32 errorCode, const QString &errorText, const QVariant &attachedData);

    virtual void onError(qint64 id, qint32 errorCode, const QString &errorText, const QString &functionName, const QVariant &attachedData, bool &accepted);

protected:
    qint64 retry(qint64 msgId);
    void timerEvent(QTimerEvent *e);

    void setApi(TelegramApi *api);
    QPointer<TelegramApi> mApi;

    void stopTimeOut(qint64 msgId) {
        qint32 timer = mTimer.take(msgId);
        if(timer) killTimer(timer);
    }

    void startTimeOut(qint64 msgId, int timeOut) {
        stopTimeOut(msgId);
        if(!timeOut) return;
        mTimer[msgId] = startTimer(timeOut);
    }

    template<typename T>
    void callBackPush(qint64 msgId, Callback<T> callback) {
        if(!callback || mCallbacks.contains(msgId)) return;
        mCallbacks.insert(msgId, CallbackStore(std::move(callback)));
    }

    template<typename T>
    Callback<T> callBackGet(qint64 msgId);

    template<typename T>
    void callBackCall(qint64 msgId, const T &result, const CallbackError &error = CallbackError(), bool remove = true) {
        if(remove) {
            auto cbs = mCallbacks.take(msgId);
            cbs(msgId, result, error);
        } else {
            auto cbs = mCallbacks.value(msgId);
            cbs(msgId, result, error);
        }
    }

private:
    class CallbackStore;
    QHash<qint64, CallbackStore> mCallbacks;
    QHash<qint64, QVariantHash> mRecallArgs;
    QVariantHash mLastArgs;
    QHash<qint64, qint32> mTimer;
    static qint32 mTimeOut;

    /*! === privates === !*/
};


class TelegramCore::CallbackStore : public QObject
{
    Q_OBJECT
public:
    template<class T>
    CallbackStore(Callback<T> func) : m_argResType(&typeid(T)) {
        if (!func) return;
        m_ptrCb = std::shared_ptr<void>(reinterpret_cast<void*>(new Callback<T>(std::forward<Callback<T>>(func))), [](void* p) {
            if(p) delete reinterpret_cast<Callback<T>*>(p);
            p = nullptr;
        });
    }

    CallbackStore() : m_argResType(nullptr) {}
    CallbackStore(const CallbackStore& rhs) : m_argResType(rhs.m_argResType), m_ptrCb(rhs.m_ptrCb) {}
    CallbackStore(CallbackStore&& rhs) noexcept : m_argResType(std::move(rhs.m_argResType)), m_ptrCb(std::move(rhs.m_ptrCb)) {}
    CallbackStore& operator=(const CallbackStore& rhs) {
        if(&rhs != this) {
            m_argResType = rhs.m_argResType;
            m_ptrCb = rhs.m_ptrCb;
        }
        return *this;
    }

    CallbackStore& operator=(CallbackStore&& rhs) noexcept {
        if(&rhs != this) {
            m_argResType = std::move(rhs.m_argResType);
            m_ptrCb = std::move(rhs.m_ptrCb);
        }
        return *this;
    }

    template<typename T>
    void operator()(qint64 msgId, T&& result, const CallbackError& error) const {
        if (*this && typeid(T) == (*m_argResType)) {
            auto cb = reinterpret_cast<Callback<T>*>(m_ptrCb.get());
            if (!cb || !bool(*cb)) return;
            (*cb)(msgId, std::forward<T>(result), error);
        }
    }

    template<typename T>
    Callback<T> getCallback() const {
        if(!bool(*this) || typeid(T) != (*m_argResType)) return 0;
        QPointer<const CallbackStore> guard(this);
        return [guard] (qint64 msgId, T&& result, const CallbackError& error) {
             if(guard) {
                 guard->operator()(msgId, std::forward<T>(result), error);
             }
        };
    }

    explicit operator bool() const {
        return bool(m_ptrCb);
    }

private:
    const std::type_info* m_argResType;
    std::shared_ptr<void> m_ptrCb;
};

template<typename T>
TelegramCore::Callback<T> TelegramCore::callBackGet(qint64 msgId) {
    return mCallbacks.value(msgId).getCallback<T>();
}

#endif // TELEGRAMCORE_H
