/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.data;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.StaticText;
import org.libreoffice.report.pentaho.model.DataStyle;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataStyleReadHandler
extends ElementReadHandler {
    private final DataStyle dataStyle;
    private final List<Object> children;
    private final boolean hasCData;

    public DataStyleReadHandler(boolean hasCData) {
        this.hasCData = hasCData;
        this.dataStyle = new DataStyle();
        this.children = new ArrayList<Object>();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0".equals(uri) || "urn:oasis:names:tc:opendocument:xmlns:style:1.0".equals(uri)) {
            DataStyleReadHandler xrh = new DataStyleReadHandler("text".equals(tagName) || "currency-symbol".equals(tagName) || "embedded-text".equals(tagName));
            this.children.add((Object)xrh);
            return xrh;
        }
        return null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.hasCData) {
            this.children.add(new StaticText(new String(ch, start, length)));
        }
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.children.size(); ++i) {
            Object o = this.children.get(i);
            if (o instanceof ElementReadHandler) {
                ElementReadHandler handler = (ElementReadHandler)((Object)o);
                this.dataStyle.addNode(handler.getElement());
                continue;
            }
            if (!(o instanceof StaticText)) continue;
            this.dataStyle.addNode((StaticText)o);
        }
    }

    public DataStyle getDataStyle() {
        return this.dataStyle;
    }

    @Override
    public Element getElement() {
        return this.dataStyle;
    }
}

