/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.displaymodel;

import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.util.IntList;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class FlowContext
implements Cloneable {
    public static final int STATE_OPEN = 0;
    public static final int STATE_SUSPEND = 1;
    public static final int STATE_CLOSE = 2;
    private IntList displayModels = new IntList(30);
    private IntList displayRoles = new IntList(30);
    private IntList elementState = new IntList(30);
    private FastStack layoutContexts = new FastStack();
    private int activeContext;

    public void addElement(int n, int n2, LayoutContext layoutContext) {
        this.displayModels.push(n);
        this.displayRoles.push(n2);
        this.elementState.push(0);
        this.layoutContexts.push((Object)layoutContext);
        this.activeContext = this.displayModels.size() - 1;
    }

    public int getCurrentDisplayRole() {
        if (this.displayRoles.size() == 0) {
            return 1;
        }
        return this.displayRoles.get(this.activeContext);
    }

    public int getCurrentDisplayModel() {
        if (this.displayModels.size() == 0) {
            return 1;
        }
        return this.displayModels.get(this.activeContext);
    }

    public int getActiveDisplayModel() {
        if (this.displayModels.size() == 0) {
            return 1;
        }
        int n = this.activeContext;
        while (this.elementState.get(n) == 1) {
            --n;
        }
        return this.displayModels.get(n);
    }

    public void suspend() {
        int n = this.elementState.get(this.activeContext);
        if (n != 0) {
            throw new IllegalStateException("Only open elements can be suspended.");
        }
        this.elementState.set(this.activeContext, 1);
        while (this.elementState.get(this.activeContext) == 1) {
            --this.activeContext;
        }
    }

    public int close() {
        int n = this.elementState.pop();
        this.displayRoles.pop();
        this.displayModels.pop();
        this.layoutContexts.pop();
        this.activeContext = Math.min(this.activeContext - 1, this.elementState.size());
        return n;
    }

    public LayoutContext getCurrentLayoutContext() {
        return (LayoutContext)this.layoutContexts.peek();
    }

    public int getCurrentState() {
        return this.elementState.peek();
    }

    public Object clone() throws CloneNotSupportedException {
        FlowContext flowContext = (FlowContext)super.clone();
        flowContext.displayModels = (IntList)this.displayModels.clone();
        flowContext.displayRoles = (IntList)this.displayRoles.clone();
        flowContext.elementState = (IntList)this.elementState.clone();
        flowContext.layoutContexts = (FastStack)this.layoutContexts.clone();
        return flowContext;
    }

    public boolean isEmpty() {
        return this.layoutContexts.isEmpty();
    }
}

