/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class AddCommand
extends SvnCommand {
    private final boolean recursive;
    private final boolean force;
    private final VCSFileProxy[] files;

    public AddCommand(FileSystem fileSystem, VCSFileProxy[] files, boolean recursive, boolean force) {
        super(fileSystem);
        this.recursive = recursive;
        this.force = force;
        this.files = files;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.ADD;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("add");
        if (!this.recursive) {
            arguments.add("-N");
        }
        arguments.addFileArguments(this.files);
        this.setCommandWorkingDirectory(this.files);
    }

    @Override
    protected void config(VCSFileProxy configDir, String username, String password, SvnCommand.Arguments arguments) {
        arguments.addConfigDir(configDir);
    }

    @Override
    public void errorText(String line) {
        if (line.startsWith("svn: warning:")) {
            return;
        }
        super.errorText(line);
    }
}

