/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class CopyCommand
extends SvnCommand {
    private final CopyType type;
    private SVNUrl fromUrl;
    private SVNUrl toUrl;
    private VCSFileProxy fromFile;
    private VCSFileProxy toFile;
    private String msg;
    private SVNRevision rev;
    private boolean makeParents;
    public static final String MAKE_PARENTS_ARGUMENT = "--parents";

    public CopyCommand(FileSystem fileSystem, SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev) {
        super(fileSystem);
        this.fromUrl = fromUrl;
        this.toUrl = toUrl;
        this.msg = msg;
        this.rev = rev;
        this.type = CopyType.url2url;
    }

    public CopyCommand(FileSystem fileSystem, SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev, boolean makeParents) {
        super(fileSystem);
        this.fromUrl = fromUrl;
        this.toUrl = toUrl;
        this.msg = msg;
        this.rev = rev;
        this.makeParents = makeParents;
        this.type = CopyType.url2url;
    }

    public CopyCommand(FileSystem fileSystem, SVNUrl fromUrl, VCSFileProxy toFile, SVNRevision rev) {
        super(fileSystem);
        this.fromUrl = fromUrl;
        this.toFile = toFile;
        this.rev = rev;
        this.type = CopyType.url2file;
    }

    public CopyCommand(FileSystem fileSystem, VCSFileProxy fromFile, SVNUrl toUrl, String msg) {
        super(fileSystem);
        this.fromFile = fromFile;
        this.toUrl = toUrl;
        this.msg = msg;
        this.type = CopyType.file2url;
    }

    public CopyCommand(FileSystem fileSystem, VCSFileProxy fromFile, VCSFileProxy toFile) {
        super(fileSystem);
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.type = CopyType.file2file;
    }

    public CopyCommand(FileSystem fileSystem, VCSFileProxy fromFile, SVNUrl toUrl, String msg, boolean makeParents) {
        super(fileSystem);
        this.fromFile = fromFile;
        this.toUrl = toUrl;
        this.msg = msg;
        this.makeParents = makeParents;
        this.type = CopyType.file2url;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.COPY;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("copy");
        switch (this.type) {
            case url2url: {
                arguments.add(this.fromUrl);
                arguments.addNonExistent(this.toUrl);
                if (this.rev == null) break;
                arguments.add(this.rev);
                break;
            }
            case url2file: {
                arguments.add(this.fromUrl);
                arguments.add(this.toFile.getPath());
                if (this.rev != null) {
                    arguments.add(this.rev);
                }
                this.setCommandWorkingDirectory(this.toFile);
                break;
            }
            case file2url: {
                arguments.add(this.fromFile);
                arguments.addNonExistent(this.toUrl);
                this.setCommandWorkingDirectory(this.fromFile);
                break;
            }
            case file2file: {
                arguments.add(this.fromFile);
                arguments.add(this.toFile);
                this.setCommandWorkingDirectory(this.fromFile);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal copytype: " + (Object)((Object)this.type));
            }
        }
        arguments.addMessage(this.msg);
        if (this.makeParents) {
            arguments.add(MAKE_PARENTS_ARGUMENT);
        }
    }

    private static enum CopyType {
        url2url,
        url2file,
        file2url,
        file2file;

    }
}

