/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNConflictDescriptor;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class StatusCommand
extends SvnCommand {
    private static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss Z";
    private byte[] output;
    private final VCSFileProxy[] files;
    private final boolean getAll;
    private final boolean descend;
    private final boolean checkUpdates;
    private final boolean ignoreExternals;

    public StatusCommand(FileSystem fileSystem, VCSFileProxy[] files, boolean getAll, boolean descend, boolean checkUpdates, boolean ignoreExternals) {
        super(fileSystem);
        this.files = files;
        this.getAll = getAll;
        this.descend = descend;
        this.checkUpdates = checkUpdates;
        this.ignoreExternals = ignoreExternals;
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.STATUS;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("status");
        arguments.add("--xml");
        if (this.getAll) {
            arguments.add("-v");
            arguments.add("--no-ignore");
        }
        if (!this.descend) {
            arguments.add("-N");
        }
        if (this.checkUpdates) {
            arguments.add("-u");
        }
        if (this.ignoreExternals) {
            arguments.add("--ignore-externals");
        }
        arguments.add(this.files);
    }

    @Override
    public void output(byte[] bytes) {
        this.output = bytes;
    }

    public Status[] getStatusValues() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new Status[0];
        }
        try {
            XMLReader saxReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            saxReader.setContentHandler(xmlEntriesHandler);
            saxReader.setErrorHandler(xmlEntriesHandler);
            InputSource source = new InputSource(new ByteArrayInputStream(this.output));
            saxReader.parse(source);
            return xmlEntriesHandler.getStatusValues();
        }
        catch (SAXException ex) {
            throw new SVNClientException(ex);
        }
        catch (IOException ex) {
            throw new SVNClientException(ex);
        }
    }

    public static class Status {
        private final VCSFileProxy path;
        private final SVNStatusKind wcStatus;
        private final SVNStatusKind wcPropsStatus;
        private final SVNRevision.Number wcRev;
        private final boolean wcLocked;
        private final boolean wcCopied;
        private final boolean wcSwitched;
        private final boolean treeConflict;
        private final SVNRevision.Number commitRev;
        private final String author;
        private final Date changeDate;
        private final String lockOwner;
        private final String lockComment;
        private final Date lockCreated;
        private final SVNStatusKind repoStatus;
        private final SVNStatusKind repoPropsStatus;

        public Status(VCSFileProxy path, SVNStatusKind wcStatus, SVNStatusKind wcPropsStatus, SVNRevision.Number wcRev, boolean wcLocked, boolean wcCopied, boolean wcSwitched, SVNRevision.Number commitRev, String author, Date changeDate, String lockOwner, String lockComment, Date lockCreated, SVNStatusKind repoStatus, SVNStatusKind repoPropsStatus, boolean treeConflict) {
            this.path = path;
            this.wcStatus = wcStatus;
            this.wcPropsStatus = wcPropsStatus;
            this.wcRev = wcRev;
            this.wcLocked = wcLocked;
            this.wcCopied = wcCopied;
            this.wcSwitched = wcSwitched;
            this.commitRev = commitRev;
            this.author = author;
            this.changeDate = changeDate;
            this.lockOwner = lockOwner;
            this.lockComment = lockComment;
            this.lockCreated = lockCreated;
            this.repoStatus = repoStatus;
            this.repoPropsStatus = repoPropsStatus;
            this.treeConflict = treeConflict;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getChangeDate() {
            return this.changeDate;
        }

        public SVNRevision.Number getCommitRev() {
            return this.commitRev;
        }

        public String getLockComment() {
            return this.lockComment;
        }

        public Date getLockCreated() {
            return this.lockCreated;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public VCSFileProxy getPath() {
            return this.path;
        }

        public SVNStatusKind getRepoPropsStatus() {
            return this.repoPropsStatus;
        }

        public SVNStatusKind getRepoStatus() {
            return this.repoStatus;
        }

        public boolean isWcCopied() {
            return this.wcCopied;
        }

        public boolean isWcLocked() {
            return this.wcLocked;
        }

        public SVNStatusKind getWcPropsStatus() {
            return this.wcPropsStatus;
        }

        public SVNRevision.Number getWcRev() {
            return this.wcRev;
        }

        public SVNStatusKind getWcStatus() {
            return this.wcStatus;
        }

        public boolean isWcSwitched() {
            return this.wcSwitched;
        }

        public boolean hasTreeConflicts() {
            return this.treeConflict;
        }

        public SVNConflictDescriptor getConflictDescriptor() {
            return null;
        }

        public String toString() {
            return this.path + "(" + (Object)((Object)this.wcStatus) + ")";
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private final List<Status> statusValues = new ArrayList<Status>();
        private static final String WC_ST_ELEMENT_NAME = "wc-status";
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ELEMENT_NAME = "name";
        private static final String SIZE_ELEMENT_NAME = "size";
        private static final String COMMIT_ELEMENT_NAME = "commit";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String LOCK_ELEMENT_NAME = "lock";
        private static final String REPO_ST_ELEMENT_NAME = "repos-status";
        private static final String TOKEN_ELEMENT_NAME = "token";
        private static final String OWNER_ELEMENT_NAME = "owner";
        private static final String COMMENT_ELEMENT_NAME = "comment";
        private static final String CREATED_ELEMENT_NAME = "created";
        private static final String EXPIRES_ELEMENT_NAME = "expires";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String PROPS_ATTRIBUTE = "props";
        private static final String ITEM_ATTRIBUTE = "item";
        private static final String WC_LOCKED_ATTRIBUTE = "wc-locked";
        private static final String COPIED_ATTRIBUTE = "copied";
        private static final String SWITCHED_ATTRIBUTE = "switched";
        private static final String REVISION_ATTRIBUTE = "revision";
        private static final String TREE_CONFLICT_ATTRIBUTE = "tree-conflicted";
        private static final String PATH_ATTR = "path";
        private static final String WC_PROPS_ATTR = "wcprops";
        private static final String REPO_PROPS_ATTR = "repoprops";
        private static final String WC_ITEM_ATTR = "wcitem";
        private static final String REPO_ITEM_ATTR = "repoitem";
        private static final String WC_LOCKED_ATTR = "wc-locked";
        private static final String WC_COPIED_ATTR = "copied";
        private static final String WC_SWITCHED_ATTR = "switched";
        private static final String WC_REVISION_ATTR = "wcrevision";
        private static final String WC_TREE_CONFLICT_ATTR = "tree-conflicted";
        private static final String CI_REVISION_ATTR = "reporevision";
        private Map<String, String> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes elementAttributes) throws SAXException {
            this.tag = qName.trim();
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                this.values = new HashMap<String, String>();
                String path = elementAttributes.getValue("path");
                path = VCSFileProxySupport.getResource((VCSFileProxy)StatusCommand.this.files[0], (String)path).normalizeFile().getPath();
                this.values.put("path", path);
            } else if (WC_ST_ELEMENT_NAME.equals(qName)) {
                this.values.put(WC_ITEM_ATTR, elementAttributes.getValue(ITEM_ATTRIBUTE));
                this.values.put(WC_PROPS_ATTR, elementAttributes.getValue(PROPS_ATTRIBUTE));
                this.values.put(WC_REVISION_ATTR, elementAttributes.getValue(REVISION_ATTRIBUTE));
                this.values.put("wc-locked", elementAttributes.getValue("wc-locked"));
                this.values.put("copied", elementAttributes.getValue("copied"));
                this.values.put("switched", elementAttributes.getValue("switched"));
                this.values.put("tree-conflicted", elementAttributes.getValue("tree-conflicted"));
            } else if (REPO_ST_ELEMENT_NAME.equals(qName)) {
                this.values.put(REPO_ITEM_ATTR, elementAttributes.getValue(ITEM_ATTRIBUTE));
                this.values.put(REPO_PROPS_ATTR, elementAttributes.getValue(PROPS_ATTRIBUTE));
            } else if (COMMIT_ELEMENT_NAME.equals(qName)) {
                this.values.put(CI_REVISION_ATTR, elementAttributes.getValue(REVISION_ATTRIBUTE));
            }
            if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String s = this.toString(length, ch, start);
            String v = this.values.get(s);
            if (v == null) {
                this.values.put(this.tag, s);
            } else {
                this.values.put(this.tag, v + s);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                if (this.values != null) {
                    String path = this.values.get("path");
                    if (this.values.get(WC_ST_ELEMENT_NAME) == null) {
                        throw new SAXException("'wc-status' tag expected under 'entry'");
                    }
                    SVNStatusKind wcStatus = SVNStatusKind.fromString(this.values.get(WC_ITEM_ATTR));
                    SVNStatusKind wcPropsStatus = SVNStatusKind.fromString(this.values.get(WC_PROPS_ATTR));
                    SVNRevision.Number wcRev = this.getRevision(this.values.get(WC_REVISION_ATTR));
                    boolean locked = this.getBoolean(this.values.get("wc-locked"));
                    boolean copied = this.getBoolean(this.values.get("copied"));
                    boolean switched = this.getBoolean(this.values.get("switched"));
                    boolean treeConflict = this.getBoolean(this.values.get("tree-conflicted"));
                    SVNRevision.Number ciRev = this.getRevision(this.values.get(CI_REVISION_ATTR));
                    String author = this.values.get(AUTHOR_ELEMENT_NAME);
                    Date date = this.getDate(this.values.get(DATE_ELEMENT_NAME));
                    String token = null;
                    String owner = null;
                    String lockComment = null;
                    Date lockCreated = null;
                    Date lockExpires = null;
                    if (this.values.get(LOCK_ELEMENT_NAME) != null) {
                        token = this.values.get(TOKEN_ELEMENT_NAME);
                        if (token == null) {
                            throw new SAXException("'token' tag expected under 'lock'");
                        }
                        owner = this.values.get(OWNER_ELEMENT_NAME);
                        if (owner == null) {
                            throw new SAXException("'owner' tag expected under 'lock'");
                        }
                        lockComment = this.values.get(COMMENT_ELEMENT_NAME);
                        lockCreated = this.getDate(this.values.get(CREATED_ELEMENT_NAME));
                        lockExpires = this.getDate(this.values.get(EXPIRES_ELEMENT_NAME));
                    }
                    SVNStatusKind repoStatus = SVNStatusKind.NONE;
                    SVNStatusKind repoPropsStatus = SVNStatusKind.NONE;
                    if (this.values.get(REPO_ST_ELEMENT_NAME) != null) {
                        repoStatus = SVNStatusKind.fromString(this.values.get(REPO_ITEM_ATTR));
                        repoPropsStatus = SVNStatusKind.fromString(this.values.get(REPO_PROPS_ATTR));
                    }
                    this.statusValues.add(new Status(VCSFileProxySupport.getResource((VCSFileProxy)StatusCommand.this.files[0], (String)path), wcStatus, wcPropsStatus, wcRev, locked, copied, switched, ciRev, author, date, owner, lockComment, lockCreated, repoStatus, repoPropsStatus, treeConflict));
                }
                this.values = null;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public Status[] getStatusValues() {
            return this.statusValues != null ? this.statusValues.toArray(new Status[this.statusValues.size()]) : new Status[]{};
        }

        private boolean getBoolean(String value) {
            return value != null && value.trim().equals("true");
        }

        private String toString(int length, char[] ch, int start) {
            char[] c = new char[length];
            System.arraycopy(ch, start, c, 0, length);
            return new String(c);
        }

        private Date getDate(String dateValue) {
            Date date = null;
            if (dateValue != null) {
                try {
                    date = new SimpleDateFormat(StatusCommand.DATE_FORMAT).parse(dateValue);
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException ex) {
                    Subversion.LOG.log(Level.INFO, dateValue, ex);
                }
                catch (Exception ex) {
                    Subversion.LOG.log(Level.SEVERE, "Cannot parse date: " + dateValue, ex);
                }
            }
            return date;
        }

        private SVNRevision.Number getRevision(String revisionValue) {
            SVNRevision.Number rev = null;
            if (revisionValue != null && !revisionValue.trim().equals("")) {
                try {
                    rev = new SVNRevision.Number(Long.parseLong(revisionValue));
                }
                catch (NumberFormatException e) {
                    rev = new SVNRevision.Number(-1L);
                }
            }
            return rev;
        }
    }
}

