/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;

public class RepositoryCacheMap<K, V> {
    private final TreeMap<K, RepositoryCacheValue<V>> keyToValue = new TreeMap();
    private final TreeMap<RepositoryCacheValue<V>, K> valueToKey = new TreeMap();
    private final int capacity;
    private static final int DEFAULT_CAPACITY = 20;
    private static AtomicInteger currentBornStamp = new AtomicInteger(0);
    private static final boolean ASSERTIONS = Boolean.getBoolean("cnd.repository.cache.map.assert");

    public RepositoryCacheMap(int capacity) {
        this.capacity = capacity > 0 ? capacity : 20;
    }

    public V get(K key) {
        RepositoryCacheValue<V> value = this.keyToValue.get(key);
        if (value != null) {
            this.valueToKey.remove(value);
            value.frequency.incrementAndGet();
            value.newBorn.set(false);
            this.valueToKey.put((RepositoryCacheValue<K>)value, (RepositoryCacheValue<V>)key);
            return value.value;
        }
        return null;
    }

    public V put(K key, V value) {
        RepositoryCacheValue<V> entry = new RepositoryCacheValue<V>(value);
        try {
            this.softAssert(this.keyToValue.size() >= this.valueToKey.size(), "valueToKeyStorage contains more elements than keyToValueStorage key=", key);
            this.softAssert(this.keyToValue.size() <= this.valueToKey.size(), "keyToValueStorage contains more elements than valueToKeyStorage", null);
            if (this.keyToValue.size() >= this.capacity) {
                RepositoryCacheValue<V> minValue = this.valueToKey.firstKey();
                K minKey = this.valueToKey.get(minValue);
                this.keyToValue.remove(minKey);
                this.valueToKey.remove(minValue);
                RepositoryCacheValue<V> oldValue = this.keyToValue.put(key, entry);
                this.softAssert(oldValue == null, "Value replacement in RepositoryCacheMap key=", key);
                this.valueToKey.put((RepositoryCacheValue<K>)entry, (RepositoryCacheValue<V>)key);
                return minValue.value;
            }
            RepositoryCacheValue<V> oldValue = this.keyToValue.put(key, entry);
            this.softAssert(oldValue == null, "Value replacement in RepositoryCacheMap key=", key);
            this.valueToKey.put((RepositoryCacheValue<K>)entry, (RepositoryCacheValue<V>)key);
        }
        catch (NoSuchElementException e) {
            RepositoryExceptions.throwException((Object)this, (Throwable)e);
        }
        return null;
    }

    public V remove(K key) {
        RepositoryCacheValue<V> entry = this.keyToValue.remove(key);
        if (entry != null) {
            this.valueToKey.remove(entry);
            return entry.value;
        }
        return null;
    }

    public Collection<V> remove(Filter<V> filter) {
        ArrayList retSet = new ArrayList(this.size());
        ArrayList<RepositoryCacheValue<V>> entriesToRemove = new ArrayList<RepositoryCacheValue<V>>(20);
        for (RepositoryCacheValue<Object> entry : this.valueToKey.keySet()) {
            if (!filter.accept(entry.value)) continue;
            retSet.add(entry.value);
            entriesToRemove.add(entry);
        }
        for (RepositoryCacheValue<Object> entry : entriesToRemove) {
            K removedKey = this.valueToKey.get(entry);
            this.valueToKey.remove(entry);
            this.keyToValue.remove(removedKey);
        }
        return retSet;
    }

    public int size() {
        return this.keyToValue.size();
    }

    public Collection<V> values() {
        ArrayList retSet = new ArrayList(this.size());
        for (RepositoryCacheValue<V> entry : this.valueToKey.keySet()) {
            retSet.add(entry.value);
        }
        return retSet;
    }

    public Collection<K> keys() {
        ArrayList<K> retSet = new ArrayList<K>(this.size());
        for (K key : this.keyToValue.keySet()) {
            retSet.add(key);
        }
        return retSet;
    }

    private void softAssert(boolean condition, String message, K key) {
        if (ASSERTIONS && !condition) {
            Exception ex = new Exception();
            StackTraceElement[] trace = ex.getStackTrace();
            if (key == null) {
                System.err.println(message);
            } else {
                System.err.println(message + key);
            }
            for (int i = 1; i < trace.length; ++i) {
                System.err.println("\tat " + trace[i]);
            }
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return currentBornStamp;
    }

    public static interface Filter<V> {
        public boolean accept(V var1);
    }

    private static final class RepositoryCacheValue<V>
    implements Comparable<RepositoryCacheValue<V>> {
        public V value;
        public AtomicInteger frequency = new AtomicInteger(1);
        public AtomicBoolean newBorn = new AtomicBoolean(true);
        public final int bornStamp = RepositoryCacheMap.access$000().incrementAndGet();

        RepositoryCacheValue(V value) {
            this.value = value;
        }

        private int compareAdults(RepositoryCacheValue<V> elemToCompare) {
            int objValue;
            int ownValue = this.frequency.intValue();
            if (ownValue < (objValue = elemToCompare.frequency.intValue())) {
                return -1;
            }
            if (ownValue == objValue) {
                ownValue = this.bornStamp;
                objValue = elemToCompare.bornStamp;
                if (ownValue < objValue) {
                    return -1;
                }
                if (ownValue > objValue) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        private int compareNewBorns(RepositoryCacheValue<V> elemToCompare) {
            int ownValue = this.bornStamp;
            int objValue = elemToCompare.bornStamp;
            if (ownValue < objValue) {
                return -1;
            }
            if (ownValue > objValue) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(RepositoryCacheValue<V> elemToCompare) {
            boolean ownChildhood = this.newBorn.get();
            boolean objChildhood = elemToCompare.newBorn.get();
            if (ownChildhood && objChildhood) {
                return this.compareNewBorns(elemToCompare);
            }
            if (ownChildhood && !objChildhood) {
                return 1;
            }
            if (!ownChildhood && objChildhood) {
                return -1;
            }
            return this.compareAdults(elemToCompare);
        }

        public String toString() {
            return "RepositoryCacheValue {" + this.value + ", frq=" + this.frequency + ", nwBrn=" + this.newBorn + ", stmp=" + this.bornStamp + '}';
        }
    }
}

