/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;

public abstract class DenseMapBaseTypeUInt<DerivedT, KeyT>
implements NativeType.SizeofCapable {
    protected final int defaultValue;
    protected final DenseMapInfo<KeyT> keyInfoT;
    protected final KeyT emptyKey;
    protected final KeyT tombstoneKey;
    static final int INVALID_INDEX = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_MASK = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_FLAG = Integer.MIN_VALUE;

    protected DenseMapBaseTypeUInt(DenseMapInfo<KeyT> keyInfo, int defaultValue) {
        this.keyInfoT = keyInfo;
        this.defaultValue = defaultValue;
        this.emptyKey = this.keyInfoT.getEmptyKey();
        this.tombstoneKey = keyInfo.getTombstoneKey();
        assert (this.emptyKey != null && this.tombstoneKey != null) : "empty/tombstoneKey key marker must be non null " + this.keyInfoT;
        assert (this.keyInfoT.getEmptyKey() == this.emptyKey) : "empty key must be persistent between calls" + this.keyInfoT;
        assert (this.keyInfoT.getTombstoneKey() == this.tombstoneKey) : "tombstone key must be persistent between calls" + this.keyInfoT;
        assert (this.emptyKey != this.tombstoneKey) : "EmptyKey must be different from TombstoneKey:" + keyInfo;
        if (ADTAliases.CHECK_DENSE_MAP_INFO) assert (keyInfo.getHashValue(keyInfo.getEmptyKey()) != keyInfo.getHashValue(keyInfo.getTombstoneKey())) : "EmptyKey must have different hashCode to TombstoneKey:" + keyInfo;
    }

    public DenseMapIteratorTypeUInt<KeyT> begin() {
        return this.empty() ? this.end() : new DenseMapIteratorTypeUInt<KeyT>(this.keyInfoT, this.$Buckets(), 0, this.getNumBuckets());
    }

    public DenseMapIteratorTypeUInt<KeyT> end() {
        return new DenseMapIteratorTypeUInt<KeyT>(this.keyInfoT, this.$Buckets(), this.getNumBuckets(), this.getNumBuckets(), true);
    }

    public boolean empty() {
        return this.getNumEntries() == 0;
    }

    public int size() {
        return this.getNumEntries();
    }

    public void resize(int Size) {
        if (Size >= this.getNumBuckets()) {
            this.grow(Size);
        }
    }

    public void clear() {
        if (this.getNumEntries() == 0 && this.getNumTombstones() == 0) {
            return;
        }
        if (this.getNumEntries() * 4 < this.getNumBuckets() && this.getNumBuckets() > 64) {
            this.shrink_and_clear();
            return;
        }
        KeyT EmptyKey = this.getEmptyKey();
        KeyT TombstoneKey = this.getTombstoneKey();
        std_pair.pairTypeUInt<KeyT>[] Buckets = this.$Buckets();
        int P = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P, (int)E)) {
            if (Buckets[P].first != EmptyKey) {
                if (Buckets[P].first != TombstoneKey) {
                    if (!this.isDataPointerLike()) {
                        Native.destroy((int)Buckets[P].second);
                    }
                    this.decrementNumEntries();
                }
                Buckets[P].first = EmptyKey;
            }
            ++P;
        }
        this.setNumTombstones(0);
    }

    public int count(KeyT Val) {
        return this.LookupBucketFor(Val, true) == Integer.MAX_VALUE ? 0 : 1;
    }

    public DenseMapIteratorTypeUInt<KeyT> find(KeyT Val) {
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIteratorTypeUInt<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public <LookupKeyT> DenseMapIteratorTypeUInt<KeyT> find_as(LookupKeyT Val) {
        int TheBucket = this.LookupBucketForAltKey(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIteratorTypeUInt<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public int lookup(KeyT Val) {
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return this.$Buckets()[TheBucket].second;
        }
        return Native.$tryClone((int)this.defaultValue);
    }

    public std_pair.pairTypeBool<DenseMapIteratorTypeUInt<KeyT>> insert(std_pair.pairTypeUInt<KeyT> KV) {
        int TheBucket = this.LookupBucketFor(KV.first, false);
        assert (TheBucket != Integer.MAX_VALUE);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(KV.first, KV.second, TheBucket & Integer.MAX_VALUE);
            return std.make_pair_T_bool(new DenseMapIteratorTypeUInt<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)true);
        }
        return std.make_pair_T_bool(new DenseMapIteratorTypeUInt<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)false);
    }

    public void insert(type.iterator<?, std_pair.pairTypeUInt<KeyT>> I, type.iterator<?, std_pair.pairTypeUInt<KeyT>> E) {
        while (Native.$noteq_iter(I, E)) {
            this.insert((std_pair.pairTypeUInt)I.$star());
            I.$preInc();
        }
    }

    public boolean erase(KeyT Val) {
        int TheBucketIdx = this.LookupBucketFor(Val, true);
        if (TheBucketIdx == Integer.MAX_VALUE) {
            return false;
        }
        std_pair.pairTypeUInt<KeyT> TheBucket = this.$Buckets()[TheBucketIdx];
        if (!this.isDataPointerLike()) {
            Native.destroy((int)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
        return true;
    }

    public void erase(DenseMapIteratorTypeUInt<KeyT> I) {
        std_pair.pairTypeUInt<KeyT> TheBucket = I.$arrow();
        if (!this.isDataPointerLike()) {
            Native.destroy((int)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
    }

    public std_pair.pairTypeUInt<KeyT> FindAndConstruct(KeyT Key) {
        int TheBucket = this.LookupBucketFor(Key, false);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(Key, this.defaultValue, TheBucket & Integer.MAX_VALUE);
        }
        return this.$Buckets()[TheBucket];
    }

    public int $at(KeyT Key) {
        return this.FindAndConstruct(Key).second;
    }

    public int $set(KeyT Key, int Val) {
        this.FindAndConstruct(Key).second = Val;
        return this.FindAndConstruct(Key).second;
    }

    public uint.ref ref$at(final KeyT Key) {
        return new uint.ref(){
            final std_pair.pairTypeUInt<KeyT> pair;
            {
                this.pair = DenseMapBaseTypeUInt.this.FindAndConstruct(Key);
            }

            public int $deref() {
                assert (Native.$eq((Object)Key, (Object)this.pair.first));
                return this.pair.second;
            }

            public int $set(int value) {
                assert (Native.$eq((Object)Key, (Object)this.pair.first));
                this.pair.second = DenseMapBaseTypeUInt.this.isDataPointerLike() ? value : Native.$tryClone((int)value);
                return value;
            }

            public String toString() {
                return "$(" + Key + ")\n => [" + this.pair.second + "]";
            }
        };
    }

    public boolean isPointerIntoBucketsArray(void.ptr Ptr) {
        if (Ptr != null && this.getBuckets() != null && this.getBucketsEnd() != null) {
            return Ptr.$greatereq(this.getBuckets()) && Ptr.$less(this.getBucketsEnd());
        }
        return false;
    }

    public void.ptr getPointerIntoBucketsArray() {
        return this.getBuckets();
    }

    protected void destroyAll() {
        if (this.getNumBuckets() == 0) {
            return;
        }
        KeyT EmptyKey = this.getEmptyKey();
        KeyT TombstoneKey = this.getTombstoneKey();
        std_pair.pairTypeUInt<KeyT>[] Buckets = this.$Buckets();
        int P = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P, (int)E)) {
            if (Buckets[P].first != EmptyKey && Buckets[P].first != TombstoneKey) {
                if (!this.isDataPointerLike()) {
                    Native.destroy((int)Buckets[P].second);
                }
                if (!this.isKeyPointerLike()) {
                    Native.destroy((Object)Buckets[P].first);
                }
            }
            ++P;
        }
    }

    protected void initEmpty() {
        this.setNumEntries(0);
        this.setNumTombstones(0);
        KeyT EmptyKey = this.getEmptyKey();
        std_pair.pairTypeUInt<KeyT>[] Buckets = this.$Buckets();
        int E = this.getNumBuckets();
        for (int B = 0; B != E; ++B) {
            Buckets[B].first = EmptyKey;
        }
    }

    protected void moveFromOldBuckets(std_pair.pairTypeUInt<KeyT>[] OldBucketsBegin, int Num) {
        this.initEmpty();
        KeyT EmptyKey = this.getEmptyKey();
        KeyT TombstoneKey = this.getTombstoneKey();
        std_pair.pairTypeUInt<KeyT>[] Buckets = this.$Buckets();
        int E = Num;
        for (int B = 0; B != Num; ++B) {
            std_pair.pairTypeUInt<KeyT> oldPair = OldBucketsBegin[B];
            Object OldKey = oldPair.first;
            if (OldKey == EmptyKey || OldKey == TombstoneKey) continue;
            int DestBucketIdx = this.LookupBucketFor(OldKey, false);
            assert (DestBucketIdx != Integer.MAX_VALUE) : "Key already in new map?";
            assert (DestBucketIdx < 0) : "Key " + System.identityHashCode(OldKey) + " already in new map?" + System.identityHashCode(Buckets[DestBucketIdx]) + ":\nWhen Inserting Key=" + OldKey + "\nFound In Map=" + Buckets[DestBucketIdx];
            assert ((DestBucketIdx &= Integer.MAX_VALUE) >= 0);
            assert (DestBucketIdx != Integer.MAX_VALUE);
            std_pair.pairTypeUInt<KeyT> DestBucket = Buckets[DestBucketIdx];
            DestBucket.first = OldKey;
            DestBucket.second = oldPair.second;
            this.incrementNumEntries();
        }
    }

    protected <OtherBaseT> void copyFrom(DenseMapBaseTypeUInt<OtherBaseT, KeyT> other) {
        this.setNumEntries(other.getNumEntries());
        this.setNumTombstones(other.getNumTombstones());
        std_pair.pairTypeUInt<KeyT>[] ourBuckets = this.$Buckets();
        std_pair.pairTypeUInt<KeyT>[] otherBuckets = other.$Buckets();
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            ourBuckets[i].first = otherBuckets[i].first;
            if (ourBuckets[i].first == this.getEmptyKey() || ourBuckets[i].first == this.getTombstoneKey()) continue;
            if (!this.isKeyPointerLike()) {
                ourBuckets[i].first = Native.$tryClone((Object)otherBuckets[i].first);
            }
            ourBuckets[i].second = this.isDataPointerLike() ? otherBuckets[i].second : Native.$tryClone((int)otherBuckets[i].second);
        }
    }

    protected void swap(DenseMapBaseTypeUInt<DerivedT, KeyT> RHS) {
        int tmp = RHS.getNumEntries();
        RHS.setNumEntries(this.getNumEntries());
        this.setNumEntries(tmp);
        tmp = RHS.getNumTombstones();
        RHS.setNumTombstones(this.getNumTombstones());
        this.setNumTombstones(tmp);
    }

    protected int getHashValue(KeyT Val) {
        return this.keyInfoT.getHashValue(Val);
    }

    protected <LookupKeyT> int getHashValueAlt(LookupKeyT Val) {
        return this.keyInfoT.getHashValue(Val);
    }

    protected final KeyT getEmptyKey() {
        return this.emptyKey;
    }

    protected final KeyT getTombstoneKey() {
        return this.tombstoneKey;
    }

    protected abstract int getNumEntries();

    protected abstract void setNumEntries(int var1);

    private void incrementNumEntries() {
        this.setNumEntries(this.getNumEntries() + 1);
    }

    private void decrementNumEntries() {
        this.setNumEntries(this.getNumEntries() - 1);
    }

    protected abstract int getNumTombstones();

    protected abstract void setNumTombstones(int var1);

    private void incrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() + 1);
    }

    private void decrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() - 1);
    }

    protected abstract type.ptr<std_pair.pairTypeUInt<KeyT>> getBuckets();

    protected abstract std_pair.pairTypeUInt<KeyT>[] $Buckets();

    protected abstract int getNumBuckets();

    private type.ptr<std_pair.pairTypeUInt<KeyT>> getBucketsEnd() {
        return NativePointer.create_type$ptr((Object[])this.$Buckets(), (int)this.getNumBuckets());
    }

    protected abstract void grow(int var1);

    protected abstract void shrink_and_clear();

    private int InsertIntoBucket(KeyT Key, int Value, int TheBucketIndex) {
        TheBucketIndex = this.InsertIntoBucketImpl(Key, TheBucketIndex);
        std_pair.pairTypeUInt<KeyT> TheBucket = this.$Buckets()[TheBucketIndex];
        assert (Key != this.emptyKey);
        assert (Key != this.tombstoneKey);
        TheBucket.first = Key;
        TheBucket.second = Value;
        return TheBucketIndex;
    }

    private int InsertIntoBucketImpl(KeyT Key, int TheBucket) {
        int NumBuckets;
        int NewNumEntries = this.getNumEntries() + 1;
        if (NewNumEntries * 4 >= (NumBuckets = this.getNumBuckets()) * 3) {
            this.grow(NumBuckets * 2);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
            NumBuckets = this.getNumBuckets();
        } else if (Native.$lesseq((int)(NumBuckets - (NewNumEntries + this.getNumTombstones())), (int)(NumBuckets / 8))) {
            this.grow(NumBuckets);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
        }
        assert (TheBucket != Integer.MAX_VALUE);
        this.incrementNumEntries();
        KeyT EmptyKey = this.getEmptyKey();
        if (this.$Buckets()[TheBucket].first != EmptyKey) {
            this.decrementNumTombstones();
        }
        return TheBucket;
    }

    private int LookupBucketFor(KeyT Key, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std_pair.pairTypeUInt<KeyT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        KeyT EmptyKey = this.getEmptyKey();
        KeyT TombstoneKey = this.getTombstoneKey();
        assert (Key != EmptyKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        assert (Key != TombstoneKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        int BucketNo = this.getHashValue(Key) & NumBuckets - 1;
        int ProbeAmt = 1;
        while (true) {
            std_pair.pairTypeUInt<KeyT> ThisBucket = Buckets[BucketNo];
            if (this.keyInfoT.isEqual(Key, ThisBucket.first)) {
                return BucketNo;
            }
            if (ThisBucket.first == EmptyKey) {
                int Bucket2;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket2 = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket2 >= 0 && Bucket2 != Integer.MAX_VALUE);
                return Bucket2 | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey && FoundTombstone == Integer.MAX_VALUE) {
                FoundTombstone = BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    private <LookupKeyT> int LookupBucketForAltKey(LookupKeyT Key, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std_pair.pairTypeUInt<KeyT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        KeyT EmptyKey = this.getEmptyKey();
        KeyT TombstoneKey = this.getTombstoneKey();
        int BucketNo = this.getHashValueAlt(Key) & NumBuckets - 1;
        int ProbeAmt = 1;
        while (true) {
            std_pair.pairTypeUInt<KeyT> ThisBucket = Buckets[BucketNo];
            if (this.keyInfoT.isEqual(Key, ThisBucket.first)) {
                return BucketNo;
            }
            if (ThisBucket.first != EmptyKey) {
                int Bucket2;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket2 = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket2 >= 0 && Bucket2 != Integer.MAX_VALUE);
                return Bucket2 | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey && FoundTombstone == Integer.MAX_VALUE) {
                FoundTombstone = BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    public int getMemorySize() {
        return this.getNumBuckets() * NativeType.sizeof(type.ptr.class);
    }

    public int $sizeof() {
        return this.getMemorySize();
    }

    protected final boolean isDataPointerLike() {
        return false;
    }

    protected final boolean isKeyPointerLike() {
        return this.keyInfoT.isKeyPointerLike();
    }
}

