/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys.impl;

import java.util.Iterator;
import java.util.logging.Level;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.ErrorOr;
import org.llvm.support.impl.ProgramStatics;
import org.llvm.support.llvm;
import org.llvm.support.spi.ExecuteProgramProvider;
import org.llvm.support.sys.ProcessInfo;
import org.llvm.support.sys.WindowsEncodingMethod;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.openide.util.Lookup;

public final class ProgramSysGlobals {
    public static byte EnvPathSeparator = NativePointer.$((char)':');

    public static ErrorOr<std.string> findProgramByName(StringRef Name) {
        return ProgramSysGlobals.findProgramByName(Name, new ArrayRef<StringRef>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorOr<std.string> findProgramByName(StringRef Name, ArrayRef<StringRef> Paths) {
        SmallVector<StringRef> EnvironmentPaths = null;
        try {
            char.ptr PathEnv;
            assert (!Name.empty()) : "Must have a name!";
            if (Name.find(NativePointer.$((char)'/')) != StringRef.npos) {
                ErrorOr<std.string> errorOr = new ErrorOr<std.string>(new std.string(Name.$basic_string()));
                return errorOr;
            }
            EnvironmentPaths = new SmallVector<StringRef>(16, new StringRef());
            if (Paths.empty() && (PathEnv = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"PATH")))) != null) {
                llvm.SplitString(new StringRef(PathEnv), EnvironmentPaths, new StringRef(NativePointer.$((String)":")));
                Paths.$assign(new ArrayRef<StringRef>(EnvironmentPaths));
            }
            for (StringRef Path2 : Paths) {
                SmallVectorImplChar FilePath = null;
                try {
                    if (Path2.empty()) continue;
                    FilePath = new SmallString(Path2, 128);
                    path.append((SmallString)FilePath, Name);
                    if (!fs.can_execute(new Twine(((SmallString)FilePath).c_str()))) continue;
                    ErrorOr<std.string> errorOr = new ErrorOr<std.string>(new std.string(((SmallString)FilePath).str().$basic_string()));
                    return errorOr;
                }
                finally {
                    if (FilePath == null) continue;
                    FilePath.$destroy();
                }
            }
            ErrorOr errorOr = new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.no_such_file_or_directory);
            return errorOr;
        }
        finally {
            if (EnvironmentPaths != null) {
                EnvironmentPaths.$destroy();
            }
        }
    }

    public static std_errors.error_code ChangeStdinToBinary() {
        return new std_errors.error_code();
    }

    public static std_errors.error_code ChangeStdoutToBinary() {
        return new std_errors.error_code();
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, (type.ptr<char.ptr>)((type.ptr)null), (type.ptr<StringRef>)((type.ptr)null), 0, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, (type.ptr<StringRef>)((type.ptr)null), 0, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, redirects, 0, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, 0, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait, int memoryLimit) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, null, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait, int memoryLimit, std.string ErrMsg) {
        return ProgramSysGlobals.ExecuteAndWait(Program, args, envp, redirects, secondsToWait, memoryLimit, ErrMsg, null);
    }

    public static int ExecuteAndWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int secondsToWait, int memoryLimit, std.string ErrMsg, bool.ptr ExecutionFailed) {
        try {
            ProcessInfo PI = new ProcessInfo();
            if (ProgramStatics.Execute(PI, Program, args, envp, redirects, memoryLimit, ErrMsg)) {
                if (ExecutionFailed != null) {
                    ExecutionFailed.$set(false);
                }
                ProcessInfo Result = ProgramSysGlobals.Wait(PI, secondsToWait, secondsToWait == 0, ErrMsg);
                return Result.ReturnCode;
            }
            if (ExecutionFailed != null) {
                ExecutionFailed.$set(true);
            }
        }
        catch (Throwable thr) {
            NativeTrace.printStackTraceOnce((Throwable)thr, (Level)Level.SEVERE, (boolean)true);
        }
        return -1;
    }

    public static ProcessInfo ExecuteNoWait(StringRef Program, type.ptr<char.ptr> args) throws Throwable {
        return ProgramSysGlobals.ExecuteNoWait(Program, args, (type.ptr<char.ptr>)((type.ptr)null), (type.ptr<StringRef>)((type.ptr)null), 0, null, null);
    }

    public static ProcessInfo ExecuteNoWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp) throws Throwable {
        return ProgramSysGlobals.ExecuteNoWait(Program, args, envp, (type.ptr<StringRef>)((type.ptr)null), 0, null, null);
    }

    public static ProcessInfo ExecuteNoWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects) throws Throwable {
        return ProgramSysGlobals.ExecuteNoWait(Program, args, envp, redirects, 0, null, null);
    }

    public static ProcessInfo ExecuteNoWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int memoryLimit) throws Throwable {
        return ProgramSysGlobals.ExecuteNoWait(Program, args, envp, redirects, memoryLimit, null, null);
    }

    public static ProcessInfo ExecuteNoWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int memoryLimit, std.string ErrMsg) throws Throwable {
        return ProgramSysGlobals.ExecuteNoWait(Program, args, envp, redirects, memoryLimit, ErrMsg, null);
    }

    public static ProcessInfo ExecuteNoWait(StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int memoryLimit, std.string ErrMsg, bool.ptr ExecutionFailed) throws Throwable {
        ProcessInfo PI = new ProcessInfo();
        if (ExecutionFailed != null) {
            ExecutionFailed.$set(false);
        }
        if (!ProgramStatics.Execute(PI, Program, args, envp, redirects, memoryLimit, ErrMsg) && ExecutionFailed != null) {
            ExecutionFailed.$set(true);
        }
        return PI;
    }

    public static boolean argumentsFitWithinSystemLimits(ArrayRef<char.ptr> Args) {
        ExecuteProgramProvider provider = ProgramSysGlobals.findProvider();
        return provider.argumentsFitWithinSystemLimits(Args);
    }

    public static std_errors.error_code writeFileWithEncoding(StringRef FileName, StringRef Contents) {
        return ProgramSysGlobals.writeFileWithEncoding(FileName, Contents, WindowsEncodingMethod.WEM_UTF8);
    }

    public static std_errors.error_code writeFileWithEncoding(StringRef FileName, StringRef Contents, WindowsEncodingMethod Encoding) {
        ExecuteProgramProvider provider = ProgramSysGlobals.findProvider();
        return provider.writeFileWithEncoding(FileName, Contents, Encoding);
    }

    public static ProcessInfo Wait(ProcessInfo PI, int SecondsToWait, boolean WaitUntilTerminates) {
        return ProgramSysGlobals.Wait(PI, SecondsToWait, WaitUntilTerminates, null);
    }

    public static ProcessInfo Wait(ProcessInfo PI, int SecondsToWait, boolean WaitUntilTerminates, std.string ErrMsg) {
        ExecuteProgramProvider provider = ProgramSysGlobals.findProvider();
        return provider.Wait(PI, SecondsToWait, WaitUntilTerminates, ErrMsg);
    }

    private static ExecuteProgramProvider findProvider() {
        Iterator iterator2 = Lookup.getDefault().lookupAll(ExecuteProgramProvider.class).iterator();
        if (iterator2.hasNext()) {
            ExecuteProgramProvider p = (ExecuteProgramProvider)iterator2.next();
            return p;
        }
        return null;
    }
}

